<?php
include('../config/constants.php');
include('partials/menu.php');
?>

<style>
body, .main-content, .wrapper {
  direction: rtl;
  font-family: 'Tajawal', Arial, sans-serif;
  background: #f8fafc;
}
.cashier-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(140px, 1fr));
  gap: 18px;
  margin-top: 25px;
}
.table-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 3px 16px rgba(0,0,0,0.07);
  padding: 25px 10px 15px 10px;
  text-align: center;
  transition: box-shadow 0.22s, transform 0.22s;
  position: relative;
  cursor: pointer;
  border: 3px solid #e0e0e0;
  min-height: 120px;
  z-index: 1;
  margin: 8px;
}
.table-card:hover {
  box-shadow: 0 10px 32px 0 rgba(33,150,243,0.17), 0 3px 16px rgba(33,150,243,0.19);
  transform: translateY(-8px) scale(1.045);
  border-color: #1976d2 !important;
  z-index: 10;
}
.table-card.busy {
  border-color: #ffb300;
  background: linear-gradient(135deg, #ffe082 50%, #fffbe9 100%);
}
.table-card.free {
  border-color: #8bc34a;
  background: linear-gradient(135deg, #d0f8ce 60%, #ffffff 100%);
}
.table-card .table-num {
  font-size: 36px;
  font-weight: bold;
  color: #222;
  margin-bottom: 6px;
  letter-spacing: 2px;
}
.table-card .table-status {
  font-size: 16px;
  font-weight: 600;
  margin-bottom: 15px;
  display: block;
}
.table-card .details-btn {
  display: block;
  margin: 0 auto;
  margin-top: 0;
  background: #1976d2;
  color: #fff;
  border: none;
  border-radius: 6px;
  font-size: 15px;
  font-weight: bold;
  padding: 6px 18px;
  cursor: pointer;
  transition: background 0.15s;
}
.table-card .details-btn:hover {
  background: #0d47a1;
}
.delivery-label {
    color: #fff;
    background: #e53935;
    border-radius: 6px;
    padding: 3px 12px;
    font-size: 16px;
    margin-bottom: 5px;
    display: inline-block;
    font-weight: bold;
    letter-spacing: 1px;
}
/* باقي CSS (نافذة التفاصيل، نافذة التعديل) كما هو ... */
.modal-bg {
  display: none;
  position: fixed;
  top: 0; right: 0; left: 0; bottom: 0;
  background: rgba(30,44,58,0.35);
  z-index: 1000;
  align-items: center;
  justify-content: center;
}
.modal-bg.active { display: flex; }
.modal-card {
  background: #fff;
  border-radius: 15px;
  box-shadow: 0 10px 30px rgba(16,36,94,0.12);
  max-width: 500px;
  min-width: 310px;
  width: 96vw;
  padding: 24px;
  position: relative;
  animation: popup 0.22s cubic-bezier(.47,1.64,.41,.8);
}
@keyframes popup {
  0% { transform: scale(0.85) translateY(50px);}
  100% { transform: scale(1) translateY(0);}
}
.modal-card .close-btn {
  position: absolute;
  left: 12px;
  top: 12px;
  font-size: 19px;
  background: #e5e7eb;
  border: none;
  border-radius: 5px;
  cursor: pointer;
  color: #333;
  padding: 2px 10px;
  font-weight: bold;
}
.modal-card h3 { font-size: 22px; color: #1976d2; font-weight: bold; margin-bottom: 18px;}
.modal-card table {
  width: 100%;
  border-collapse: collapse;
  margin-bottom: 13px;
}
.modal-card th, .modal-card td {
  padding: 8px 4px;
  border-bottom: 1px solid #ececec;
  text-align: right;
  font-size: 15px;
}
.modal-card th { color: #00518a;}
.modal-card .actions-row {
  text-align: left;
  margin-top: 14px;
}
.modal-card .act-btn {
  margin-left: 7px;
  background: #1976d2;
  color: #fff;
  border: none;
  border-radius: 6px;
  font-size: 15px;
  padding: 6px 13px;
  cursor: pointer;
  transition: background 0.13s;
}
.modal-card .act-btn:hover {
  background: #0d47a1;
}
.modal-card .del-btn {
  background: #f44336;
}
.modal-card .del-btn:hover {
  background: #b71c1c;
}
.modal-card .print-btn {
  background: #8bc34a;
}
.modal-card .print-btn:hover {
  background: #388e3c;
}
</style>

<div class="main-content">
  <div class="wrapper">
    <h1>لوحة الكاشير - إدارة الطاولات</h1>
    <div id="tables_container" class="cashier-grid"></div>
  </div>
</div>

<!-- نافذة التفاصيل -->
<div class="modal-bg" id="detailsModal">
  <div class="modal-card" id="modalContent">
    <button class="close-btn" onclick="closeModal()">×</button>
    <div id="modalInner"></div>
  </div>
</div>

<!-- نافذة تعديل الكمية -->
<div id="editModal" style="display:none; position:fixed;top:0;left:0;right:0;bottom:0;background:rgba(0,0,0,0.17);z-index:1100;align-items:center;justify-content:center;">
  <div style="background:#fff;padding:25px 30px;border-radius:14px;box-shadow:0 8px 30px #0002;max-width:320px;margin:auto;position:relative;">
    <span onclick="closeEditModal()" style="position:absolute;left:10px;top:5px;cursor:pointer;font-size:22px;">×</span>
    <form id="editForm" onsubmit="return saveEditQty();">
      <input type="hidden" name="edit_order_id" id="edit_order_id">
      <input type="hidden" name="edit_table" id="edit_table">
      <label for="edit_qty">تعديل الكمية:</label>
      <input type="number" min="1" name="edit_qty" id="edit_qty" required style="width:100px;padding:6px;margin:7px 0;">
      <button type="submit" class="act-btn">حفظ</button>
    </form>
  </div>
</div>

<script>
// تحميل الطاولات والدليفري بشكل تلقائي كل 10 ثواني
function loadTables() {
  fetch('fetch_tables.php')
    .then(response => response.text())
    .then(html => {
      document.getElementById('tables_container').innerHTML = html;

      // الكرت كله يفتح التفاصيل حسب data-detail
      document.querySelectorAll('.table-card').forEach(function(card) {
        const param = card.getAttribute('data-detail');
        if (param) {
          card.onclick = function() { showDetails(param); };
        }
      });
    });
}
loadTables();
setInterval(loadTables, 10000);

// عند الضغط على تفاصيل طاولة أو دليفري
function showDetails(param) {
  fetch('fetch_table_details.php?table=' + encodeURIComponent(param))
    .then(response => response.text())
    .then(html => {
      document.getElementById('modalInner').innerHTML = html;
      document.getElementById('detailsModal').classList.add('active');
    });
}
function closeModal() {
  document.getElementById('detailsModal').classList.remove('active');
}

// تنفيذ العمليات (حذف/تعديل/دفع)
function orderAction(param, action, order_id = null) {
  let formData = new FormData();
  formData.append('param', param);
  formData.append('action', action);
  if(order_id) formData.append('order_id', order_id);

  fetch('order_actions.php', {
    method: 'POST',
    body: formData
  })
  .then(res => res.json())
  .then(data => {
    if(data.success){
      showDetails(param);
      loadTables();
    } else {
      alert('حدث خطأ: ' + data.message);
    }
  });
}

// زر طباعة الفاتورة
function printInvoice(param) {
  window.open('print-invoice.php?table=' + encodeURIComponent(param), '_blank');
}

// ---- دوال نافذة تعديل الكمية ----
function showEditModal(orderId, qty, param) {
    document.getElementById('edit_order_id').value = orderId;
    document.getElementById('edit_qty').value = qty;
    document.getElementById('edit_table').value = param;
    document.getElementById('editModal').style.display = 'flex';
}
function closeEditModal() {
    document.getElementById('editModal').style.display = 'none';
}
function saveEditQty() {
    let orderId = document.getElementById('edit_order_id').value;
    let qty = document.getElementById('edit_qty').value;
    let param = document.getElementById('edit_table').value;

    let formData = new FormData();
    formData.append('action', 'edit');
    formData.append('param', param);
    formData.append('order_id', orderId);
    formData.append('qty', qty);

    fetch('order_actions.php', {
        method: 'POST',
        body: formData
    })
    .then(res => res.json())
    .then(data => {
        if(data.success){
            closeEditModal();
            showDetails(param);
            loadTables();
        } else {
            alert('حدث خطأ: ' + data.message);
        }
    });

    return false;
}
</script>
