<?php
include('../config/constants.php');
header("Content-Type: text/html; charset=utf-8");

// عدد الطاولات الكلي
$total_tables = 30;

// الطاولات العادية
$sql = "SELECT customer_name AS table_number, 
           MAX(status) AS status,
           (SELECT order_type FROM tbl_order WHERE customer_name = t.customer_name ORDER BY id DESC LIMIT 1) as order_type
        FROM tbl_order t
        GROUP BY customer_name
        HAVING order_type != 'delivery'
        ORDER BY customer_name+0 ASC";
$res = mysqli_query($conn, $sql);

$existing_tables = array();

while ($row = mysqli_fetch_assoc($res)) {
    $table = trim($row['table_number']);
    $existing_tables[$table] = $row['status'];
}

// كروت الطاولات
for ($i = 1; $i <= $total_tables; $i++) {
    $table = (string)$i;
    $status = isset($existing_tables[$table]) ? $existing_tables[$table] : 'خالية';
    $busy = ($status != 'Delivered' && $status != 'Cancelled' && $status != 'خالية');
    $status_text = $busy ? "مشغولة" : "خالية";
    $status_color = $busy ? "#8e24aa" : "#ba68c8";
    $card_class = $busy ? 'table-card busy' : 'table-card free';

    echo "<div class='$card_class' data-detail='table_$table'>";
    echo "<div class='table-num'>طاولة $table</div>";
    echo "<div class='table-status' style='color:$status_color;'>$status_text</div>";
    echo "<button class='details-btn' onclick=\"event.stopPropagation();showDetails('table_$table')\">تفاصيل</button>";
    echo "</div>";
}

// كروت الدليفري (كل طلب مستقل برقم id خاص به)
$sql_delivery = "
SELECT id, customer_name, customer_contact, customer_address
FROM tbl_order
WHERE order_type = 'delivery' AND status NOT IN ('Delivered','Cancelled')
ORDER BY id DESC";
$res_delivery = mysqli_query($conn, $sql_delivery);

while($row = mysqli_fetch_assoc($res_delivery)) {
    echo "<div class='table-card busy' data-detail='delivery_{$row['id']}'>";
    echo "<div class='delivery-label'>دليفري</div>";
    echo "<div style='font-size:19px;font-weight:bold;margin-bottom:5px;'>".htmlspecialchars($row['customer_name'])."</div>";
    echo "<div style='font-size:14px;color:#555;'>الهاتف: ".htmlspecialchars($row['customer_contact'])."</div>";
    echo "<div style='font-size:14px;color:#555;'>العنوان: ".htmlspecialchars($row['customer_address'])."</div>";
    echo "<button class='details-btn' onclick=\"event.stopPropagation();showDetails('delivery_{$row['id']}')\">تفاصيل</button>";
    echo "</div>";
}
?>
<style>
/* ... CSS كما هو ... */
.table-card {
  background: #fff;
  border-radius: 18px;
  box-shadow: 0 3px 16px rgba(0,0,0,0.07);
  padding: 25px 10px 15px 10px;
  text-align: center;
  transition: box-shadow 0.22s, transform 0.22s;
  position: relative;
  cursor: pointer;
  border: 3px solid #e0e0e0;
  min-height: 120px;
  z-index: 1;
  margin: 8px;
}
.table-card.busy {
  border-color: #ffb300;
  background: linear-gradient(135deg, #ffe082 50%, #fffbe9 100%);
}
.table-card.free {
  border-color: #8bc34a;
  background: linear-gradient(135deg, #d0f8ce 60%, #ffffff 100%);
}
.table-card .table-num {
  font-size: 32px;
  font-weight: bold;
  color: #222;
  margin-bottom: 6px;
  letter-spacing: 2px;
}
.table-card .table-status {
  font-size: 16px;
  font-weight: 600;
  margin-bottom: 15px;
  display: block;
}
.details-btn {
  margin: 0 auto;
  background: #1976d2;
  color: #fff;
  border: none;
  border-radius: 6px;
  font-size: 15px;
  font-weight: bold;
  padding: 6px 18px;
  cursor: pointer;
  transition: background 0.15s;
}
.details-btn:hover {
  background: #0d47a1;
}
.delivery-label {
    color: #fff;
    background: #e53935;
    border-radius: 6px;
    padding: 3px 12px;
    font-size: 16px;
    margin-bottom: 5px;
    display: inline-block;
    font-weight: bold;
    letter-spacing: 1px;
}
</style>
<script>
// كل الكروت تفتح التفاصيل حسب data-detail (حط هذا السكريبت في الـcashier.php وليس هنا)
document.addEventListener('DOMContentLoaded', function() {
  document.querySelectorAll('.table-card').forEach(function(card) {
    card.onclick = function() {
      var param = card.getAttribute('data-detail');
      if(param) showDetails(param);
    }
  });
});
</script>
