<?php include('partials/menu.php'); ?>

<style>
body, .main-content, .wrapper, table, th, td {
  direction: rtl;
  text-align: right;
}
.order-details-cell {
    direction: ltr;
    text-align: left;
    unicode-bidi: plaintext;
}
.center-cell {
    text-align: center !important;
    vertical-align: middle !important;
}
</style>

<div class="main-content">
    <div class="wrapper" style="text-align: center;">
        <h1 class="text">الطلبات التي تم استلامها</h1>
        <br /><br /><br />

        <?php 
            if(isset($_SESSION['update']))
            {
                echo $_SESSION['update'];
                unset($_SESSION['update']);
            }
        ?>
        <br><br>

        <table class="tbl-full">
            <tr>
                <th class="center-cell" width="5%">التسلسل</th>
                <th class="center-cell" width="10%">رقم الطاولة</th>
                <th width="30%">تفاصيل الطلب</th>
                <th class="center-cell" width="10%">إجمالي الكمية</th>
                <th width="15%">ملاحظات</th>
                <th width="10%">حالة الطلب</th>
                <th class="center-cell">الإجراء</th>
            </tr>

            <?php 
                // جلب كل الطلبات لتجميعها يدويًا برمجياً
                $orders = [];
                $sql = "SELECT * FROM tbl_order ORDER BY id ASC";
                $res = mysqli_query($conn, $sql);

                while($row = mysqli_fetch_assoc($res)) {
                    $table = $row['customer_name'];
                    $food = $row['food'];
                    $qty = $row['qty'];
                    $note = $row['customer_address'];
                    $status = $row['status'];
                    $id = $row['id'];

                    if(!isset($orders[$table])) {
                        $orders[$table] = [
                            'foods' => [],
                            'notes' => [],
                            'total_qty' => 0,
                            'status' => $status,
                            'last_id' => $id
                        ];
                    }
                    if(!isset($orders[$table]['foods'][$food])) {
                        $orders[$table]['foods'][$food] = 0;
                    }
                    $orders[$table]['foods'][$food] += $qty;
                    $orders[$table]['total_qty'] += $qty;
                    if($note != '') {
                        $orders[$table]['notes'][] = $note;
                    }
                    if($id > $orders[$table]['last_id']) {
                        $orders[$table]['status'] = $status;
                        $orders[$table]['last_id'] = $id;
                    }
                }

                $sn = 1;
                foreach(array_reverse($orders, true) as $table => $order) {
                    // تفاصيل الوجبات مع الكمية
                    $details = [];
                    foreach($order['foods'] as $foodName => $qty) {
                        $details[] = $foodName . ' (' . $qty . ')';
                    }
                    $all_details = implode(' + ', $details);

                    // كل الملاحظات
                    $notes = implode(' | ', $order['notes']);

                    ?>
                    <tr>
                        <td class="center-cell"><?php echo $sn++; ?></td>
                        <td class="center-cell"><?php echo htmlspecialchars($table); ?></td>
                        <td class="order-details-cell"><?php echo $all_details; ?></td>
                        <td class="center-cell"><?php echo $order['total_qty']; ?></td>
                        <td><?php echo htmlspecialchars($notes); ?></td>
                        <td>
                            <?php
                            if($order['status']=="Ordered")
                                echo "<label style='color: blue;'>Ordered</label>";
                            elseif($order['status']=="On Delivery")
                                echo "<label style='color: orange;'>On Delivery</label>";
                            elseif($order['status']=="Delivered")
                                echo "<label style='color: green;'><b>Delivered</b></label>";
                            elseif($order['status']=="Cancelled")
                                echo "<label style='color: red;'>Cancelled</label>";
                            else
                                echo "<label>".$order['status']."</label>";
                            ?>
                        </td>
                        <td class="center-cell">
                            <a href="<?php echo SITEURL; ?>admin/update-order.php?id=<?php echo $order['last_id']; ?>" class="btn-secondary">تحديث</a>
                        </td>
                    </tr>
                    <?php
                }
                if(count($orders) == 0) {
                    echo "<tr><td colspan='7' class='error'>الطلبات غير متوفرة</td></tr>";
                }
            ?>
        </table>
    </div>
</div>

<?php include('partials/footer.php'); ?>