<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/error_action_log.txt");

include('../config/constants.php');
header('Content-Type: application/json');

// دعم النظام الجديد للـ param
$action   = isset($_POST['action']) ? $_POST['action'] : '';
$param    = isset($_POST['param']) ? $_POST['param'] : '';
$order_id = isset($_POST['order_id']) ? intval($_POST['order_id']) : 0;
$response = array('success'=>false, 'message'=>'init');

$table = '';
$delivery_id = 0;

// استخراج معرّف الطلب أو الطاولة من param
if (strpos($param, 'delivery_') === 0) {
    $delivery_id = intval(substr($param, 9));
} elseif (strpos($param, 'table_') === 0) {
    $table = mysqli_real_escape_string($conn, substr($param, 6));
}

// حذف طلب مفرد
if($action == 'delete' && $order_id > 0) {
    $sql = "DELETE FROM tbl_order WHERE id=$order_id";
    $q = mysqli_query($conn, $sql);
    if(!$q) error_log("MYSQL DELETE ERROR: " . mysqli_error($conn));
    if($q){
        $response['success'] = true;
        $response['message'] = 'deleted';
    } else {
        $response['message'] = 'فشل الحذف.';
    }
}
// تسديد كل الطلبات
elseif($action == 'paid') {
    if($delivery_id > 0) {
        // تسديد دليفري فقط حسب الـ id
        $sql = "UPDATE tbl_order SET status='Delivered' WHERE id='$delivery_id'";
        $q = mysqli_query($conn, $sql);
        if(!$q) error_log("MYSQL PAID ERROR: " . mysqli_error($conn));
        if($q){
            $response['success'] = true;
            $response['message'] = 'paid';
        } else {
            $response['message'] = 'فشل التسديد.';
        }
    }
    elseif($table != '') {
        // تسديد جميع طلبات طاولة
        $sql = "UPDATE tbl_order SET status='Delivered' WHERE customer_name='$table' AND status NOT IN ('Delivered','Cancelled')";
        $q = mysqli_query($conn, $sql);
        if(!$q) error_log("MYSQL PAID ERROR: " . mysqli_error($conn));
        if($q){
            $response['success'] = true;
            $response['message'] = 'paid';
        } else {
            $response['message'] = 'فشل التسديد.';
        }
    } else {
        $response['message'] = 'طلب غير صحيح!';
    }
}
// تعديل الكمية
elseif($action == 'edit' && $order_id > 0) {
    $qty = isset($_POST['qty']) ? intval($_POST['qty']) : 1;
    $rowq = mysqli_query($conn, "SELECT price FROM tbl_order WHERE id=$order_id LIMIT 1");
    if(!$rowq) error_log("MYSQL SELECT ERROR: " . mysqli_error($conn));
    $row = mysqli_fetch_assoc($rowq);
    $unit_price = $row ? $row['price'] : 0;
    $total = $unit_price * $qty;
    $sql = "UPDATE tbl_order SET qty=$qty, total=$total WHERE id=$order_id";
    $uq = mysqli_query($conn, $sql);
    if(!$uq) error_log("MYSQL EDIT ERROR: " . mysqli_error($conn));
    if($uq){
        $response['success'] = true;
        $response['message'] = 'edited';
    } else {
        $response['message'] = 'فشل التعديل.';
    }
} else {
    $response['message'] = 'طلب غير صحيح!';
}

echo json_encode($response);
?>
