<?php
include('../config/constants.php');
include('partials/menu.php');

$param = isset($_GET['table']) ? $_GET['table'] : '';

if (!$param) {
    echo "<div class='error'>رقم الطاولة أو الطلب غير محدد.</div>";
    exit;
}

// تهيئة المتغيرات
$table_number = '';
$order_id = 0;
$title = '';
$total_amount = 0;

// تحقق نوع الطلب
if (strpos($param, 'delivery_') === 0) {
    // طلب دليفري حسب الـ ID
    $order_id = intval(substr($param, 9));
    $sql = "SELECT * FROM tbl_order WHERE id = $order_id LIMIT 1";
    $res = mysqli_query($conn, $sql);
    $title = 'فاتورة طلب دليفري';
} elseif (strpos($param, 'table_') === 0) {
    // طلبات طاولة حسب الرقم
    $table_number = mysqli_real_escape_string($conn, substr($param, 6));
    $sql = "SELECT * FROM tbl_order WHERE customer_name = '$table_number' AND status NOT IN ('Delivered','Cancelled') ORDER BY order_date ASC";
    $res = mysqli_query($conn, $sql);
    $title = "فاتورة طلبات الطاولة رقم: " . htmlspecialchars($table_number);
} else {
    echo "<div class='error'>طلب غير صحيح!</div>";
    exit;
}

if (!$res || mysqli_num_rows($res) == 0) {
    echo "<div class='error'>لا توجد طلبات لهذا الطلب أو الطاولة.</div>";
    exit;
}
?>

<div class="main-content">
    <div class="wrapper">
        <h1><?php echo $title; ?></h1>
        <table class="tbl-full">
            <tr>
                <th>تاريخ الطلب</th>
                <th>اسم الوجبة</th>
                <th>الكمية</th>
                <th>السعر</th>
                <th>المجموع</th>
            </tr>
            <?php while($row = mysqli_fetch_assoc($res)) {
                $line_total = $row['price'] * $row['qty'];
                $total_amount += $line_total;
            ?>
            <tr>
                <td><?php echo $row['order_date']; ?></td>
                <td><?php echo htmlspecialchars($row['food']); ?></td>
                <td><?php echo $row['qty']; ?></td>
                <td><?php echo $row['price']; ?> د.ع</td>
                <td><?php echo $line_total; ?> د.ع</td>
            </tr>
            <?php } ?>
            <tr>
                <td colspan="4" style="text-align:right; font-weight:bold;">الإجمالي الكلي:</td>
                <td style="font-weight:bold;"><?php echo $total_amount; ?> د.ع</td>
            </tr>
        </table>
        <br>
        <button onclick="window.print();" class="btn-primary">طباعة الفاتورة</button>
        <a href="cashier.php" class="btn-secondary" style="margin-left:15px;">العودة للكاشير</a>
    </div>
</div>

<?php include('partials/footer.php'); ?>
