<?php
include('config/constants.php');

// تفعيل عرض الأخطاء (لن تظهر أحيانًا على الاستضافة لكن تُفيد بالفحص)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// دالة للتسجيل في ملف debug.txt
function log_debug($msg) {
    file_put_contents('debug.txt', date("Y-m-d H:i:s")." : ".$msg."\n", FILE_APPEND);
}

log_debug("===== New Request =====");
log_debug("POST: " . print_r($_POST, true));

// استبدال ?? بطريقة تدعم كل نسخ PHP
$action = isset($_POST['action']) ? $_POST['action'] : '';
$response = array('success'=>false);

if ($action == 'done' && !empty($_POST['kitchen_order_id'])) {
    log_debug("Starting SQL delete for kitchen_order_id: " . $_POST['kitchen_order_id']);
    $ids = explode(',', $_POST['kitchen_order_id']);
    $ids = array_map('intval', $ids);
    $ids_list = implode(',', $ids);
    $sql = "DELETE FROM kitchen_orders WHERE id IN ($ids_list)";
    log_debug("Running SQL: $sql");
    $query = mysqli_query($conn, $sql);
    if(!$query) {
        log_debug("SQL ERROR: " . mysqli_error($conn));
    }
    $response['success'] = $query ? true : false;
    $response['sql'] = $sql;
}
elseif ($action == 'clear') {
    log_debug("Starting CLEAR all from kitchen_orders");
    $sql = "DELETE FROM kitchen_orders";
    log_debug("Running SQL: $sql");
    $query = mysqli_query($conn, $sql);
    if(!$query) {
        log_debug("SQL ERROR: " . mysqli_error($conn));
    }
    $response['success'] = $query ? true : false;
    $response['sql'] = $sql;
} else {
    log_debug("No valid action or missing params");
    $response['message'] = 'No valid action or missing params';
}

// الإرجاع بصيغة JSON
echo json_encode($response);
flush();
exit;
