<?php
session_start();
header('Content-Type: application/json');
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'يجب تسجيل الدخول أولاً.']); exit;
}
include('config.php');
mysqli_set_charset($conn, "utf8mb4");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $supplier = isset($_POST['supplier']) ? trim($_POST['supplier']) : '';
    $pay_amount = isset($_POST['pay_amount']) ? floatval($_POST['pay_amount']) : 0;
    $pay_note = isset($_POST['pay_note']) ? trim($_POST['pay_note']) : '';

    if ($supplier == '' || $pay_amount <= 0) {
        echo json_encode(['success' => false, 'message' => 'يرجى تحديد المورد وإدخال مبلغ صحيح.']); exit;
    }

    // استخراج الدين الحالي للمورد
    $supplier_sql = mysqli_real_escape_string($conn, $supplier);
    $r = mysqli_query($conn, "
        SELECT SUM(quantity * cost_price) as total_invoice, SUM(IFNULL(paid_amount,0)) as total_paid
        FROM purchases
        WHERE supplier='$supplier_sql'
    ");
    $data = mysqli_fetch_assoc($r);
    $debt = floatval($data['total_invoice']) - floatval($data['total_paid']);

    if ($debt <= 0) {
        echo json_encode(['success' => false, 'message' => 'لا يوجد دين لهذا المورد.']); exit;
    }
    if ($pay_amount > $debt) {
        echo json_encode(['success' => false, 'message' => 'المبلغ أكبر من الدين المتبقي!']); exit;
    }

    // توزيع الدفع على الفواتير الأقدم فالأحدث (First Unpaid First Paid)
    $res = mysqli_query($conn, "SELECT id, quantity, cost_price, paid_amount FROM purchases WHERE supplier='$supplier_sql' ORDER BY purchase_date ASC, id ASC");
    $remaining = $pay_amount;
    $success = false;
    while ($row = mysqli_fetch_assoc($res)) {
        $invoice_total = floatval($row['quantity']) * floatval($row['cost_price']);
        $already_paid = floatval($row['paid_amount']);
        $to_pay = min($remaining, $invoice_total - $already_paid);
        if ($to_pay > 0) {
            $id = intval($row['id']);
            // إضافة الملاحظة فقط لأول دفعة (ممكن تطوير ذلك لاحقاً)
            if ($pay_note && !$success) {
                mysqli_query($conn, "UPDATE purchases SET paid_amount = paid_amount + $to_pay, notes = CONCAT(IFNULL(notes,''),'".mysqli_real_escape_string($conn, "\n")."$pay_note') WHERE id=$id");
            } else {
                mysqli_query($conn, "UPDATE purchases SET paid_amount = paid_amount + $to_pay WHERE id=$id");
            }
            $remaining -= $to_pay;
            $success = true;
            if ($remaining <= 0) break;
        }
    }

    echo json_encode([
        'success' => true,
        'message' => 'تم تسديد المبلغ بنجاح للمورد: ' . htmlspecialchars($supplier)
    ]);
    exit;
}

echo json_encode(['success' => false, 'message' => 'طلب غير صالح.']);
exit;
?>
