<?php
session_start();
include('config.php');

$sale_id = isset($_GET['sale_id']) ? intval($_GET['sale_id']) : 0;
if (!$sale_id) die('فاتورة غير موجودة');

$sale = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM sales WHERE id=$sale_id"));
$sale_items = mysqli_query($conn, "
    SELECT si.*, m.name 
    FROM sales_items si
    JOIN medicines m ON si.medicine_id = m.id
    WHERE si.sale_id=$sale_id
");

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>طباعة فاتورة</title>
    <style>
        body {font-family: 'Cairo', Arial, sans-serif; background: #fff;}
        .invoice-box {max-width: 360px; margin: 20px auto; padding: 18px 22px; border: 1px solid #e3e3e3; border-radius: 12px;}
        h2 {text-align: center; margin: 8px 0 14px 0;}
        table {width: 100%; border-collapse: collapse; font-size: 1rem;}
        th, td {padding: 6px 4px; text-align: center;}
        th {background: #f1f5fa;}
        .total-row {font-weight: bold; background: #eaf1fb;}
        @media print { .btn-print {display: none;}}
    </style>
</head>
<body>
    <div class="invoice-box">
        <h2>فاتورة بيع</h2>
        <div style="text-align:right; font-size:1rem;">
            <b>رقم الفاتورة:</b> <?= $sale['id'] ?><br>
            <b>التاريخ:</b> <?= date('Y-m-d H:i', strtotime($sale['sale_date'])) ?>
        </div>
        <table border="1" style="margin-top:12px;">
            <tr>
                <th>الصنف</th>
                <th>الكمية</th>
                <th>السعر</th>
                <th>الإجمالي</th>
            </tr>
            <?php
            $total = 0;
            while($item = mysqli_fetch_assoc($sale_items)): 
                $line = $item['quantity'] * $item['price'];
                $total += $line;
            ?>
            <tr>
                <td><?= htmlspecialchars($item['name']) ?></td>
                <td><?= $item['quantity'] ?></td>
                <td><?= $item['price'] ?></td>
                <td><?= number_format($line, 2) ?></td>
            </tr>
            <?php endwhile; ?>
            <tr class="total-row">
                <td colspan="3">الإجمالي الكلي</td>
                <td><?= number_format($total, 2) ?></td>
            </tr>
        </table>
        <button onclick="window.print();" class="btn-print" style="width:100%;margin-top:12px;padding:10px;border:none;background:#1976d2;color:#fff;font-size:1.1rem;border-radius:7px;">طباعة</button>
    </div>
</body>
</html>
