<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// --- المتغيرات ---
$success = '';
$error = '';
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$medicines = [];
$medicine_id = isset($_GET['medicine_id']) ? intval($_GET['medicine_id']) : 0;

// ========== 1. البحث عن الدواء ==========
if ($search != '' && !$medicine_id) {
    $search_sql = mysqli_real_escape_string($conn, $search);
    $result = mysqli_query($conn, "SELECT * FROM medicines WHERE name LIKE '%$search_sql%' OR barcode LIKE '%$search_sql%' ORDER BY name ASC LIMIT 30");
    while ($row = mysqli_fetch_assoc($result)) {
        $medicines[] = $row;
    }
}

// ========== 2. عرض فواتير البيع للدواء ==========
$sales = array();
if ($medicine_id) {
    $med_res = mysqli_query($conn, "SELECT * FROM medicines WHERE id = $medicine_id LIMIT 1");
    $medicine = mysqli_fetch_assoc($med_res);

    $sql = "SELECT si.*, s.sale_date, s.id as sale_id, u.username
            FROM sales_items si
            JOIN sales s ON si.sale_id = s.id
            JOIN users u ON s.user_id = u.id
            WHERE si.medicine_id = $medicine_id
            ORDER BY s.sale_date DESC
            LIMIT 30";
    $res = mysqli_query($conn, $sql);
    while ($row = mysqli_fetch_assoc($res)) $sales[] = $row;

    // عند تنفيذ المرتجع
    if (isset($_POST['do_return'])) {
        $returns = isset($_POST['return_qty']) ? $_POST['return_qty'] : array();
        $prices  = isset($_POST['return_price']) ? $_POST['return_price'] : array();
        $reason  = isset($_POST['reason']) ? mysqli_real_escape_string($conn, $_POST['reason']) : '';
        $user_id = $_SESSION['user_id'];

        $any_return = false;
        foreach($returns as $i => $qty) {
            $qty = intval($qty);
            $price = isset($prices[$i]) ? floatval($prices[$i]) : 0;
            $sale_item = $sales[$i];
            if ($qty > 0 && $qty <= $sale_item['quantity']) {
                // 1. سجل المرتجع في جدول sales_returns (مرة واحدة لكل فاتورة)
                $sale_id = intval($sale_item['sale_id']);
                // تحقق إذا كان هناك بالفعل مرتجع لنفس الفاتورة خلال هذه العملية، إذا لا أضف مرتجع جديد
                $result_return = mysqli_query($conn, "INSERT INTO sales_returns (sale_id, user_id, customer_name, return_date, reason)
                                    VALUES ($sale_id, $user_id, NULL, NOW(), '$reason')");
                if (!$result_return) {
                    $error = "خطأ في إدخال المرتجع: " . mysqli_error($conn);
                    break;
                }
                $sales_return_id = mysqli_insert_id($conn);

                // 2. سجل تفاصيل المرتجع في sales_return_items
                $result_item = mysqli_query($conn, "INSERT INTO sales_return_items (sales_return_id, product_id, quantity, price)
                                    VALUES ($sales_return_id, $medicine_id, $qty, $price)");
                if (!$result_item) {
                    $error = "خطأ في إدخال تفاصيل المرتجع: " . mysqli_error($conn);
                    break;
                }

                // 3. زيد الكمية في المخزن
                mysqli_query($conn, "UPDATE medicines SET quantity = quantity + $qty WHERE id = $medicine_id");

                // 4. خصم المبلغ من الفاتورة (إذا تريد التأثير المالي مباشرة)
                mysqli_query($conn, "UPDATE sales SET total = total - ($qty * $price), paid = paid - ($qty * $price) WHERE id = $sale_id");

                $any_return = true;
            }
        }
        if ($any_return && !$error) $success = "تم تنفيذ المرتجع بنجاح!";
        elseif (!$any_return && !$error) $error = "لم يتم تحديد أي كمية للإرجاع أو الكمية غير صحيحة.";
        // إعادة جلب بيانات المبيعات بعد المرتجع
        $res = mysqli_query($conn, $sql);
        $sales = array();
        while ($row = mysqli_fetch_assoc($res)) $sales[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>مرتجع المبيعات حسب اسم الدواء</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: #f6fafd; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 730px; margin: 44px auto; background: #fff; border-radius: 16px; box-shadow: 0 5px 28px #e8f3fa70; padding: 30px;}
        h2 {text-align: center; color: #1976d2; font-size: 2rem; margin-bottom: 25px;}
        .search-box {display: flex; gap: 7px; margin-bottom: 19px;}
        .search-box input[type="text"] {flex:1; padding: 11px; border-radius: 9px; border: 1px solid #b6cced; background: #f3f7fb; font-size: 1.13rem;}
        .m-btn {background: linear-gradient(90deg,#fffbe8 80%,#fff3e0 100%); color: #e65100; border: 1.7px solid #ffe066; border-radius: 8px; font-weight: bold; font-size: 1.02rem; padding: 8px 15px; cursor: pointer; transition: background .14s;}
        .m-btn:hover {background: linear-gradient(90deg,#ffe6bc 80%,#ffefc7 100%);}
        .barcode-btn {
            background: linear-gradient(90deg,#fffde4 80%,#fefae2 100%);
            color: #d4a607;
            border-color: #ffe066;
            margin-left: 0 !important;
        }
        .barcode-btn:hover {
            background: linear-gradient(90deg,#fff8bc 80%,#fff7b0 100%);
            color: #a87b05;
        }
        .result-row {background: #fcfdfe; border-radius: 10px; margin: 9px 0; padding: 11px 17px; display: flex; align-items: center; justify-content: space-between; box-shadow:0 1px 7px #e3eefd0e;}
        #reader {width: 100%; margin: 0 auto 18px auto; border-radius: 13px; overflow: hidden; display: none;}
        table {width: 100%; border-collapse: collapse; margin-bottom: 14px;}
        th, td {padding: 7px; text-align: center;}
        th {background: #eaf1fb;}
        tr:nth-child(even) {background: #f7fbfd;}
        .qty-input, .price-input {width: 70px; padding: 3px; border-radius: 6px; border: 1px solid #c4d3f6; text-align: center;}
        .success {color: #43a047; text-align:center;}
        .error {color: #d32f2f; text-align:center;}
        @media(max-width: 750px){
            .container {padding:10px;}
            h2 {font-size: 1.3rem;}
            .search-box input[type="text"]{font-size:.97rem;}
        }
    </style>
</head>
<body>
<div class="container">
    <h2>مرتجع المبيعات حسب اسم الدواء</h2>

    <!-- ========== البحث عن الدواء ========== -->
    <?php if (!$medicine_id): ?>
        <form class="search-box" method="get" autocomplete="off" id="search-form">
            <input type="text" id="search-input" name="search" placeholder="ابحث باسم الدواء أو الباركود..." value="<?php echo htmlspecialchars($search); ?>">
            <button type="button" class="m-btn barcode-btn" id="scan-btn" title="بحث بالباركود">
                <svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg>
                باركود
            </button>
            <button type="submit" class="m-btn">بحث</button>
        </form>
        <div id="reader"></div>
        <?php if ($search != '' && count($medicines) == 0): ?>
            <div style="text-align:center; color:#b00;">لا توجد أدوية مطابقة.</div>
        <?php endif; ?>
        <?php foreach($medicines as $med): ?>
            <div class="result-row">
                <div>
                    <b><?php echo htmlspecialchars($med['name']); ?></b>
                    <div style="font-size: 0.97rem; color:#888;">باركود: <?php echo htmlspecialchars($med['barcode']); ?></div>
                </div>
                <a href="sales_return.php?medicine_id=<?php echo $med['id']; ?>" class="m-btn">عرض الفواتير</a>
            </div>
        <?php endforeach; ?>

    <!-- ========== عرض الفواتير وإجراء المرتجع ========== -->
    <?php elseif ($medicine_id && isset($medicine)): ?>
        <div style="margin-bottom:20px;">
            <b>اسم الدواء:</b> <?php echo htmlspecialchars($medicine['name']); ?><br>
            <b>باركود:</b> <?php echo htmlspecialchars($medicine['barcode']); ?>
        </div>
        <?php if ($success): ?>
            <div class="success"><?php echo htmlspecialchars($success); ?></div>
        <?php elseif ($error): ?>
            <div class="error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form method="post">
            <input type="hidden" name="do_return" value="1">
            <table border="1">
                <tr>
                    <th>تاريخ الفاتورة</th>
                    <th>رقم الفاتورة</th>
                    <th>اسم المستخدم</th>
                    <th>الكمية المباعة</th>
                    <th>سعر البيع الأصلي</th>
                    <th>الكمية المرجعة</th>
                    <th>السعر المرجع</th>
                </tr>
                <?php foreach($sales as $i => $item): ?>
                <tr>
                    <td><?php echo htmlspecialchars(date('Y-m-d', strtotime($item['sale_date']))); ?></td>
                    <td><?php echo htmlspecialchars($item['sale_id']); ?></td>
                    <td><?php echo htmlspecialchars($item['username']); ?></td>
                    <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                    <td><?php echo htmlspecialchars($item['price']); ?></td>
                    <td>
                        <input type="number" class="qty-input" name="return_qty[<?php echo $i; ?>]" min="0" max="<?php echo $item['quantity']; ?>" value="0">
                    </td>
                    <td>
                        <input type="number" class="price-input" name="return_price[<?php echo $i; ?>]" step="0.01" min="0" value="<?php echo $item['price']; ?>">
                    </td>
                </tr>
                <?php endforeach; ?>
            </table>
            <div style="margin-bottom:10px;">
                <input type="text" name="reason" placeholder="سبب المرتجع (اختياري)" style="width:98%;padding:8px;border-radius:8px;border:1px solid #ccc;">
            </div>
            <button type="submit" class="m-btn">تنفيذ المرتجع</button>
            <a href="sales_return.php" class="m-btn" style="background:#f2f4f7;color:#1976d2;border:1px solid #bcd;">رجوع</a>
        </form>
    <?php endif; ?>
</div>

<!-- كود الكاميرا (باركود) -->
<script>
const scanBtn = document.getElementById('scan-btn');
const readerDiv = document.getElementById('reader');
const searchInput = document.getElementById('search-input');
let scannerOn = false;
let html5QrCode;
if(scanBtn) {
    scanBtn.onclick = function () {
        if (!scannerOn) {
            readerDiv.style.display = 'block';
            scanBtn.textContent = 'إيقاف الكاميرا';
            scannerOn = true;
            html5QrCode = new Html5Qrcode("reader");
            html5QrCode.start(
                { facingMode: "environment" },
                { fps: 10, qrbox: { width: 250, height: 80 } },
                barcode => {
                    searchInput.value = barcode;
                    html5QrCode.stop().then(() => {
                        readerDiv.style.display = 'none';
                        scanBtn.innerHTML = '<svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg> باركود';
                        scannerOn = false;
                        document.getElementById('search-form').submit();
                    });
                },
                errorMessage => {}
            );
        } else {
            html5QrCode.stop().then(() => {
                readerDiv.style.display = 'none';
                scanBtn.innerHTML = '<svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg> باركود';
                scannerOn = false;
            });
        }
    }
}
</script>
</body>
</html>
