<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');
mysqli_set_charset($conn, "utf8mb4");

// استقبال اسم المورد من الرابط
$supplier = '';
if (isset($_GET['supplier'])) {
    $supplier = trim($_GET['supplier']);
    $supplier = urldecode($supplier);
}

if ($supplier == '') {
    echo '<div style="margin:50px auto;max-width:440px;text-align:center;font-size:1.35rem;color:#d32f2f;background:#fff3f3;border-radius:15px;padding:40px 15px;">
        <b>مورد غير محدد!</b>
        <br>
        <a href="suppliers.php" style="display:inline-block;margin-top:23px;background:#1976d2;color:#fff;padding:10px 27px;border-radius:10px;text-decoration:none;">رجوع إلى إدارة الموردين</a>
    </div>';
    exit;
}

// جلب تفاصيل المورد من قاعدة البيانات
$supplier_sql = mysqli_real_escape_string($conn, $supplier);
$res = mysqli_query($conn, "SELECT * FROM purchases WHERE supplier='$supplier_sql' AND supplier != '' ORDER BY purchase_date DESC, id DESC");

$total_invoice = 0;
$total_paid = 0;
$rows = array();
while ($row = mysqli_fetch_assoc($res)) {
    $rows[] = $row;
    $total_invoice += floatval($row['quantity']) * floatval($row['cost_price']);
    $total_paid += floatval($row['paid_amount']);
}
$debt = $total_invoice - $total_paid;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تفاصيل المورد - <?php echo htmlspecialchars($supplier); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600;700&display=swap" rel="stylesheet">
    <style>
        body {background:#f6f8fa;font-family:'Cairo',Arial,sans-serif;}
        .container {max-width: 850px; margin: 48px auto; background: #fff; border-radius: 22px; box-shadow: 0 7px 34px #dbe7f355; padding: 38px 16px 25px 16px;}
        h2 {color: #0890c2; text-align: center; margin-bottom:16px; font-size:2.12rem;}
        .supplier-name {color:#1976d2;font-weight:bold;font-size:1.32rem;text-align:center;margin-bottom:16px;}
        .summary {display:flex;justify-content:center;gap:23px;margin-bottom:25px;flex-wrap:wrap;}
        .sum-card {background:#eaf1fb;border-radius:10px;padding:18px 24px;min-width:170px;text-align:center;}
        .sum-title {font-size:1.07rem;color:#101c3c;font-weight:600;margin-bottom:7px;}
        .sum-value {font-size:1.3rem;font-weight:700;}
        .sum-debt {color:#d32f2f;}
        .sum-zero {color:#43a047;}
        table {width:100%;border-collapse:collapse;background:#fff;box-shadow:0 3px 12px #dde7fc32;}
        th,td {padding:10px;text-align:center;border-bottom:1px solid #eaeaea;}
        th {background:#eaf1fb;}
        tr:hover {background:#f7faff;}
        .back-btn {display:inline-block;margin:22px auto 0 auto;background:#1976d2;color:#fff;padding:11px 32px;border-radius:10px;text-decoration:none;font-size:1.09rem;transition:background .14s;}
        .back-btn:hover {background:#1453a1;}
        /* تسديد الدين */
        .pay-box {background:#f5fcf6; padding:22px 11px 17px 11px; border-radius:13px; margin-bottom:27px; box-shadow:0 2px 8px #a9e6be3f;}
        .pay-box label {font-weight:bold;}
        .pay-box input[type="number"], .pay-box input[type="text"] {padding:8px; border-radius:7px; border:1.1px solid #b8bdd1;}
        .pay-btn {padding:8px 26px; border-radius:8px; background:linear-gradient(90deg,#43a047 80%,#1976d2 100%); color:#fff; font-weight:bold; font-size:1.07rem; border:none; cursor:pointer;}
        @media(max-width:650px){.container{max-width:99vw;padding:6px;}th,td{font-size:.97rem;}}
    </style>
</head>
<body>
<div class="container">
    <h2>تفاصيل المورد</h2>
    <div class="supplier-name"><?php echo htmlspecialchars($supplier); ?></div>
    <div class="summary">
        <div class="sum-card">
            <div class="sum-title">إجمالي الفواتير</div>
            <div class="sum-value"><?php echo number_format($total_invoice,2); ?> د.ع</div>
        </div>
        <div class="sum-card">
            <div class="sum-title">إجمالي المدفوع</div>
            <div class="sum-value"><?php echo number_format($total_paid,2); ?> د.ع</div>
        </div>
        <div class="sum-card">
            <div class="sum-title">الدين الحالي</div>
            <div class="sum-value <?php echo ($debt <= 0 ? 'sum-zero':'sum-debt'); ?>" id="currentDebt"><?php echo number_format(max($debt,0),2); ?> د.ع</div>
        </div>
    </div>

    <!-- نموذج تسديد الدين -->
    <?php if($debt > 0): ?>
    <form id="payForm" class="pay-box" autocomplete="off">
        <div style="font-size:1.1rem; color:#0890c2; font-weight:bold; margin-bottom:8px;">
            تسديد دين المورد: <span style="color:#1976d2;"><?php echo htmlspecialchars($supplier); ?></span>
        </div>
        <div style="margin-bottom:10px;">
            <label>المتبقي حالياً:</label>
            <span style="color:#c41d1d; font-weight:bold;" id="debtValue"><?php echo number_format($debt,2); ?></span>
        </div>
        <div style="margin-bottom:10px;">
            <label>المبلغ المراد تسديده:</label>
            <input type="number" step="any" min="1" max="<?php echo $debt; ?>" id="pay_amount" name="pay_amount" required style="width:110px;">
        </div>
        <div style="margin-bottom:10px;">
            <label>ملاحظة (اختياري):</label>
            <input type="text" id="pay_note" name="pay_note" placeholder="مثلاً تم التسديد جزئي أو دفع كامل" style="width:250px;">
        </div>
        <button type="submit" class="pay-btn">تسديد</button>
    </form>
    <div id="payMessage"></div>
    <?php endif; ?>

    <table>
        <tr>
            <th>اسم الدواء</th>
            <th>الكمية</th>
            <th>سعر الشراء</th>
            <th>إجمالي الفاتورة</th>
            <th>المدفوع</th>
            <th>تاريخ الشراء</th>
            <th>ملاحظات</th>
        </tr>
        <?php if(count($rows)): ?>
            <?php foreach($rows as $row): ?>
                <tr>
                    <td>
                        <?php
                        if (!empty($row['medicine_id'])) {
                            $medid = intval($row['medicine_id']);
                            $q = mysqli_query($conn,"SELECT name FROM medicines WHERE id=$medid");
                            $medrow = mysqli_fetch_assoc($q);
                            echo htmlspecialchars($medrow ? $medrow['name'] : '---');
                        } else {
                            echo '---';
                        }
                        ?>
                    </td>
                    <td><?php echo htmlspecialchars($row['quantity']); ?></td>
                    <td><?php echo htmlspecialchars($row['cost_price']); ?></td>
                    <td><?php echo number_format($row['quantity'] * $row['cost_price'],2); ?></td>
                    <td><?php echo htmlspecialchars($row['paid_amount']); ?></td>
                    <td><?php echo htmlspecialchars($row['purchase_date']); ?></td>
                    <td><?php echo htmlspecialchars($row['notes']); ?></td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="7" style="color:#888;">لا توجد فواتير لهذا المورد.</td></tr>
        <?php endif; ?>
    </table>
    <a href="suppliers.php" class="back-btn">رجوع إلى الموردين</a>
</div>

<?php if($debt > 0): ?>
<script>
document.getElementById('payForm').addEventListener('submit', function(e){
    e.preventDefault();
    var amount = parseFloat(document.getElementById('pay_amount').value) || 0;
    var note   = document.getElementById('pay_note').value;
    var debt   = parseFloat(document.getElementById('debtValue').innerText.replace(/,/g, '')) || 0;
    var messageDiv = document.getElementById('payMessage');
    messageDiv.innerHTML = '';
    if (amount <= 0 || amount > debt) {
        messageDiv.innerHTML = '<div style="background:#fff3f2;color:#d32f2f;font-weight:bold;padding:10px 15px;margin-top:14px;border-radius:8px;">يجب أن يكون المبلغ بين 1 والمبلغ المتبقي</div>';
        return;
    }
    var xhr = new XMLHttpRequest();
    xhr.open("POST", "pay_supplier_ajax.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    if (resp.success) {
                        document.getElementById('debtValue').innerText = resp.new_debt;
                        messageDiv.innerHTML = '<div style="background:#eaf9f0;color:#43a047;font-weight:bold;padding:10px 15px;margin-top:14px;border-radius:8px;">' + resp.message + '</div>';
                        document.getElementById('pay_amount').value = '';
                        document.getElementById('pay_note').value = '';
                        setTimeout(() => location.reload(), 1300);
                    } else {
                        messageDiv.innerHTML = '<div style="background:#fff3f2;color:#d32f2f;font-weight:bold;padding:10px 15px;margin-top:14px;border-radius:8px;">' + resp.message + '</div>';
                    }
                } catch(e) {
                    messageDiv.innerHTML = '<div style="background:#fff3f2;color:#d32f2f;font-weight:bold;padding:10px 15px;margin-top:14px;border-radius:8px;">خطأ غير متوقع!</div>';
                }
            } else {
                messageDiv.innerHTML = '<div style="background:#fff3f2;color:#d32f2f;font-weight:bold;padding:10px 15px;margin-top:14px;border-radius:8px;">تعذر الاتصال بالسيرفر.</div>';
            }
        }
    };
    xhr.send("supplier=" + encodeURIComponent("<?php echo $supplier; ?>") + "&pay_amount=" + amount + "&pay_note=" + encodeURIComponent(note));
});
</script>
<?php endif; ?>
</body>
</html>
