<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');
mysqli_set_charset($conn, "utf8mb4");

// إضافة مورد جديد
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['new_supplier_name'])) {
    $new_supplier = trim($_POST['new_supplier_name']);
    if ($new_supplier != '') {
        $exists = mysqli_query($conn, "SELECT 1 FROM purchases WHERE supplier='" . mysqli_real_escape_string($conn, $new_supplier) . "' LIMIT 1");
        if (!mysqli_num_rows($exists)) {
            mysqli_query($conn, "INSERT INTO purchases (supplier, quantity, cost_price, paid_amount) VALUES ('" . mysqli_real_escape_string($conn, $new_supplier) . "', 0, 0, 0)");
        }
    }
}

// حذف مورد وكل الفواتير الخاصة به
if (isset($_GET['del']) && $_GET['del'] != '') {
    $supplier = mysqli_real_escape_string($conn, $_GET['del']);
    mysqli_query($conn, "DELETE FROM purchases WHERE supplier='$supplier'");
    header("Location: suppliers.php?deleted=1");
    exit;
}

// البحث
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$where = ($search != '') ? "AND supplier LIKE '%" . mysqli_real_escape_string($conn, $search) . "%'" : "";

// جلب جميع الموردين مع حساب الدين الحالي (مجموع الفواتير - مجموع المدفوع)
$suppliers = [];
$res = mysqli_query($conn, "
    SELECT supplier,
        SUM(quantity * cost_price) as total_invoice,
        SUM(IFNULL(paid_amount,0)) as total_paid
    FROM purchases
    WHERE supplier IS NOT NULL AND supplier != '' $where
    GROUP BY supplier
    HAVING total_invoice > 0 OR total_paid > 0
    ORDER BY supplier ASC
");

while ($row = mysqli_fetch_assoc($res)) {
    $row['debt'] = floatval($row['total_invoice']) - floatval($row['total_paid']);
    $suppliers[] = $row;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الموردين والديون</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700;600&display=swap" rel="stylesheet">
    <style>
        body {
            background: #f6f8fa;
            font-family: 'Cairo', Arial, sans-serif;
        }
        .container {
            max-width: 860px;
            margin: 40px auto 0;
            background: #fff;
            border-radius: 26px;
            box-shadow: 0 8px 36px #dbe7f355;
            padding: 40px 17px 28px 17px;
        }
        h2 {
            color: #0890c2;
            text-align: center;
            font-size: 2.18rem;
            font-weight: 900;
            margin-bottom: 29px;
            letter-spacing: 1.2px;
            text-shadow: 0 2px 16px #d5f5f799;
        }
        .actions-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            margin-bottom: 26px;
            gap: 13px;
        }
        .add-form {
            display: flex;
            gap: 8px;
            align-items: center;
        }
        .add-form input[type="text"] {
            padding: 11px 10px;
            border-radius: 11px;
            border: 1.1px solid #b6cced;
            font-size: 1.07rem;
            width: 175px;
            transition: border-color .17s;
        }
        .add-form input[type="text"]:focus {
            border-color: #1976d2;
            outline: none;
        }
        .add-btn {
            background: linear-gradient(90deg, #43a047 78%, #3ed1b7 100%);
            color: #fff;
            padding: 10px 27px;
            border: none;
            border-radius: 11px;
            font-weight: bold;
            font-size: 1.06rem;
            cursor: pointer;
            box-shadow: 0 2px 10px #84e6b85a;
            transition: background .16s;
            display: flex;
            align-items: center;
        }
        .add-btn:hover {background: linear-gradient(90deg, #1976d2 90%, #43a047 100%);}
        .add-btn svg {margin-left: 6px;}
        .search-box {
            flex: 1;
            display: flex;
            justify-content: end;
        }
        .search-box input {
            padding: 10px 12px;
            border-radius: 11px;
            border: 1.1px solid #b6cced;
            font-size: 1.05rem;
            width: 190px;
            transition: border-color .16s;
        }
        .search-box input:focus {
            border-color: #1976d2;
            outline: none;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            box-shadow: 0 6px 16px #dde7fc33;
            border-radius: 19px;
            overflow: hidden;
        }
        th, td {
            padding: 13px 6px;
            text-align: center;
            border-bottom: 1px solid #eaeaea;
            font-size: 1.08rem;
        }
        th {
            background: #eaf1fb;
            font-size: 1.12rem;
        }
        tr:hover {background: #f6fbff;}
        .op-btn {
            padding: 8px 22px;
            border: none;
            border-radius: 10px;
            font-weight: bold;
            cursor: pointer;
            font-size: 1rem;
            text-decoration: none;
            transition: background .15s, box-shadow .15s;
            box-shadow: 0 2px 8px #cde9f349;
            margin-left: 4px;
        }
        .view-btn {
            background: linear-gradient(90deg, #1976d2 90%, #17b4e6 100%);
            color: #fff;
        }
        .del-btn {
            background: linear-gradient(90deg, #d32f2f 90%, #ff7c76 100%);
            color: #fff;
        }
        .view-btn:hover {background: linear-gradient(90deg, #1453a1 90%, #17b4e6 100%);}
        .del-btn:hover {background: linear-gradient(90deg, #ae2727 90%, #fd6767 100%);}
        .success-msg {
            color: #43a047;
            text-align: center;
            font-weight: bold;
            margin-bottom: 14px;
            background: #eaf9f0;
            border-radius: 11px;
            padding: 13px;
        }
        .debt-zero {
            color: #43a047;
            font-weight: 700;
        }
        .debt-positive {
            color: #d32f2f;
            font-weight: 900;
        }
        /* مودال */
        .modal {display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:#19274279; z-index:9999; align-items:center; justify-content:center;}
        .modal.active {display:flex;}
        .modal-content {
            background: #fff; border-radius: 15px; min-width: 320px; max-width:97vw;
            box-shadow: 0 7px 36px #9cc8ff67; padding: 25px 17px 18px 17px;
            display:flex; flex-direction:column; align-items:center; animation: fadeIn .33s;
        }
        @keyframes fadeIn { from{opacity:0;} to{opacity:1;} }
        .btn-edit {background:linear-gradient(90deg,#d9f2ea 80%,#c9f5f9 100%); color: #039b79; border: 1px solid #61cbc9; padding: 6px 14px; border-radius:8px;}
        .btn-edit:hover {background:linear-gradient(90deg,#aafae2 80%,#7cdce8 100%); color:#025c4c;}
        .btn-cancel {background:#eee; color:#444; border:1px solid #bbb; padding:6px 13px; border-radius:8px;}
        .btn-cancel:hover {background:#f7e7e7;}
        @media(max-width: 950px){
            .container {max-width:99vw;}
            table,th,td{font-size:.97rem;}
        }
        @media(max-width: 620px){
            .container{padding:10px;}
            .actions-bar {flex-direction: column; gap:13px;}
            .add-form, .search-box{width:100%; justify-content:center;}
            .add-form input, .search-box input{width:99%;}
            .add-btn{width:100%;}
            table,th,td{font-size:.96rem;}
        }
        @media(max-width:450px){
            th,td{padding:6px 1px;}
            .modal-content{min-width:90vw;}
        }
    </style>
</head>
<body>
<div class="container">
    <h2>إدارة الموردين والديون</h2>
    <?php if(isset($_GET['deleted'])): ?>
        <div class="success-msg">تم حذف المورد وجميع فواتيره بنجاح.</div>
    <?php endif; ?>
    <div class="actions-bar">
        <form method="POST" class="add-form" autocomplete="off">
            <input type="text" name="new_supplier_name" placeholder="اسم المورد (المذخر)" required>
            <button type="submit" class="add-btn">
                <svg width="19" height="19" viewBox="0 0 20 20" fill="none">
                    <circle cx="10" cy="10" r="9" fill="#fff" stroke="#43a047" stroke-width="2"/>
                    <path d="M10 5v10M5 10h10" stroke="#43a047" stroke-width="2" stroke-linecap="round"/>
                </svg>
                إضافة
            </button>
        </form>
        <form method="GET" class="search-box" autocomplete="off">
            <input type="text" name="search" placeholder="ابحث عن مورد..." value="<?= htmlspecialchars($search) ?>">
        </form>
    </div>
    <table>
        <tr>
            <th>اسم المورد</th>
            <th>إجمالي الفواتير</th>
            <th>المدفوع</th>
            <th>المتبقي</th>
            <th>عمليات</th>
        </tr>
        <?php if (count($suppliers)): ?>
            <?php foreach ($suppliers as $s): ?>
                <tr>
                    <td><?= htmlspecialchars($s['supplier']) ?></td>
                    <td><?= number_format($s['total_invoice'],2) ?></td>
                    <td style="color:green;"><?= number_format($s['total_paid'],2) ?></td>
                    <td style="color:<?= $s['debt'] > 0 ? 'red' : 'green' ?>;"><?= number_format(max($s['debt'],0),2) ?></td>
                    <td>
                        <?php if($s['debt'] > 0): ?>
                            <button type="button" class="op-btn view-btn" onclick="openPayModal('<?= htmlspecialchars(addslashes($s['supplier'])) ?>', <?= number_format($s['debt'],2,'.','') ?>)">تسديد</button>
                        <?php endif; ?>
                        <a href="?del=<?= urlencode($s['supplier']) ?>" class="op-btn del-btn"
                           onclick="return confirm('سيتم حذف كل فواتير هذا المورد! تأكيد الحذف؟');">حذف</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr><td colspan="5" style="color:#888;">لا يوجد موردين حالياً.</td></tr>
        <?php endif; ?>
    </table>
</div>

<!-- مودال تسديد دين المورد -->
<div id="paySupplierModal" class="modal">
  <div class="modal-content" style="max-width:390px;">
    <form id="supplierPayForm" onsubmit="return submitSupplierPay(event)">
      <input type="hidden" id="supplierName" name="supplier">
      <div style="font-size:1.15rem;font-weight:bold;margin-bottom:12px;">
        تسديد دين للمورد <span id="supplierLabel" style="color:#1976d2"></span>
      </div>
      <div style="margin-bottom:8px;">
        <label>المتبقي حالياً:</label>
        <span style="color:#d32f2f;font-weight:bold;" id="supplierDebt"></span>
      </div>
      <div style="margin-bottom:9px;">
        <label>المبلغ المراد تسديده:</label>
        <input type="number" step="any" min="1" id="payAmount" name="pay_amount" required style="width:90px;">
      </div>
      <div style="margin-bottom:11px;">
        <label>ملاحظة (اختياري):</label>
        <input type="text" id="payNote" name="pay_note" placeholder="مثلاً دفع جزئي أو كامل" style="width:220px;">
      </div>
      <div id="payMsg" style="font-size:.99em;margin:5px 0 0 0;"></div>
      <div style="margin-top:11px;">
        <button type="submit" class="btn-edit">تسديد</button>
        <button type="button" class="btn-cancel" onclick="closePayModal()">إلغاء</button>
      </div>
    </form>
  </div>
</div>
<script>
function openPayModal(supplier, debt) {
    document.getElementById('paySupplierModal').classList.add('active');
    document.getElementById('supplierLabel').innerText = supplier;
    document.getElementById('supplierName').value = supplier;
    document.getElementById('supplierDebt').innerText = parseFloat(debt).toLocaleString(undefined, {minimumFractionDigits:2});
    document.getElementById('payAmount').max = debt;
    document.getElementById('payAmount').value = '';
    document.getElementById('payNote').value = '';
    document.getElementById('payMsg').innerText = '';
    setTimeout(() => document.getElementById('payAmount').focus(), 300);
}
function closePayModal() {
    document.getElementById('paySupplierModal').classList.remove('active');
}
function submitSupplierPay(event) {
    event.preventDefault();
    var supplier = document.getElementById('supplierName').value;
    var amount = parseFloat(document.getElementById('payAmount').value) || 0;
    var note = document.getElementById('payNote').value;
    var max = parseFloat(document.getElementById('payAmount').max) || 0;
    var msg = document.getElementById('payMsg');
    msg.innerText = '';
    if(amount <= 0 || amount > max){
        msg.innerText = 'يرجى إدخال مبلغ صحيح بين 1 والمبلغ المتبقي';
        msg.style.color = '#d32f2f';
        return false;
    }
    // AJAX
    var xhr = new XMLHttpRequest();
    xhr.open("POST", "pay_supplier_ajax.php", true);
    xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
    xhr.onreadystatechange = function() {
        if(xhr.readyState === 4) {
            if(xhr.status === 200) {
                try {
                    var resp = JSON.parse(xhr.responseText);
                    msg.innerText = resp.message;
                    msg.style.color = resp.success ? "#43a047" : "#d32f2f";
                    if(resp.success) setTimeout(()=>{location.reload();}, 1200);
                } catch(e){
                    msg.innerText = "حصل خطأ أثناء العملية!";
                    msg.style.color = "#d32f2f";
                }
            } else {
                msg.innerText = "تعذر الاتصال بالسيرفر";
                msg.style.color = "#d32f2f";
            }
        }
    };
    xhr.send("supplier=" + encodeURIComponent(supplier) + "&pay_amount=" + amount + "&pay_note=" + encodeURIComponent(note));
    return false;
}
</script>
</body>
</html>
