<?php
include('config.php'); // عدل المسار إذا وضعت الملف في مكان آخر

// إضافة منتج جديد
if (isset($_POST['add'])) {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $price_wholesale = floatval($_POST['price_wholesale']);
    $price_retail = floatval($_POST['price_retail']);
    $carton_qty = intval($_POST['carton_qty']);
    $stock = intval($_POST['stock']);

    $sql = "INSERT INTO products (name, price_wholesale, price_retail, carton_qty, stock)
            VALUES ('$name', '$price_wholesale', '$price_retail', '$carton_qty', '$stock')";
    mysqli_query($conn, $sql);
    header("Location: products.php");
    exit;
}

// حذف منتج
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($conn, "DELETE FROM products WHERE id=$id");
    header("Location: products.php");
    exit;
}

// جلب المنتجات
$res = mysqli_query($conn, "SELECT * FROM products ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة المنتجات</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background: #f9f9f9; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 800px; margin: 30px auto; background: #fff; border-radius: 16px; box-shadow: 0 4px 20px #eee; padding: 25px;}
        h2 {color: #1e88e5; margin-bottom: 22px;}
        table {width: 100%; border-collapse: collapse; margin-bottom: 30px;}
        th, td {padding: 8px 10px; border-bottom: 1px solid #eee; text-align: center;}
        th {background: #e3f2fd;}
        form input {padding: 4px 10px; border: 1px solid #bbb; border-radius: 7px;}
        .btn {padding: 4px 12px; border: none; background: #1e88e5; color: #fff; border-radius: 7px; cursor: pointer;}
        .btn-del {background: #f44336;}
    </style>
</head>
<body>
<div class="container">
    <h2>إدارة المنتجات</h2>

    <form method="POST" style="margin-bottom:18px;">
        <input type="text" name="name" placeholder="اسم المنتج" required>
        <input type="number" name="price_wholesale" step="0.01" placeholder="سعر الجملة" required>
        <input type="number" name="price_retail" step="0.01" placeholder="سعر المفرد" required>
        <input type="number" name="carton_qty" placeholder="عدد القطع بالكارتون" required>
        <input type="number" name="stock" placeholder="الكمية المتوفرة (بالقطعة)" required>
        <button type="submit" name="add" class="btn">إضافة</button>
    </form>

    <table>
        <tr>
            <th>#</th>
            <th>اسم المنتج</th>
            <th>جملة (كارتون)</th>
            <th>مفرد (قطعة)</th>
            <th>عدد بالكارتون</th>
            <th>المتوفر</th>
            <th>حذف</th>
        </tr>
        <?php while($row = mysqli_fetch_assoc($res)): ?>
        <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= $row['price_wholesale'] ?> د.ع</td>
            <td><?= $row['price_retail'] ?> د.ع</td>
            <td><?= $row['carton_qty'] ?></td>
            <td><?= $row['stock'] ?></td>
            <td>
                <a href="?delete=<?= $row['id'] ?>" onclick="return confirm('تأكيد الحذف؟')" class="btn btn-del">حذف</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>
</div>
</body>
</html>
