<?php
include('config.php');

// استقبال بيانات JSON
$data = json_decode(file_get_contents('php://input'), true);

// لمعالجة مشاكل الإصدارات القديمة
$bill      = isset($data['bill'])      ? $data['bill']      : array();
$sale_type = isset($data['sale_type']) ? $data['sale_type'] : 'retail';
$total     = isset($data['total'])     ? $data['total']     : 0;
$paid      = isset($data['paid'])      ? $data['paid']      : 0;

if (!$bill || !$total) {
    echo json_encode(array('success' => false));
    exit;
}

// إضافة الفاتورة (sales)
$sql = "INSERT INTO sales (total, paid, sale_type) VALUES (?, ?, ?)";
$stmt = mysqli_prepare($conn, $sql);
mysqli_stmt_bind_param($stmt, 'dds', $total, $paid, $sale_type);
mysqli_stmt_execute($stmt);
$sale_id = mysqli_insert_id($conn);

// إضافة تفاصيل الفاتورة (sales_items)
foreach ($bill as $item) {
    $product_id  = isset($item['id'])         ? intval($item['id'])         : 0;
    $qty         = isset($item['qty'])        ? intval($item['qty'])        : 0;
    $unit_price  = isset($item['unit_price']) ? floatval($item['unit_price']): 0;
    $total_item  = isset($item['total'])      ? floatval($item['total'])    : 0;
    $carton_qty  = isset($item['carton_qty']) ? intval($item['carton_qty']) : 1;
    $type        = isset($item['type'])       ? $item['type']               : 'retail';

    $sql2 = "INSERT INTO sales_items (sale_id, product_id, qty, unit_price, total)
            VALUES (?, ?, ?, ?, ?)";
    $stmt2 = mysqli_prepare($conn, $sql2);
    mysqli_stmt_bind_param($stmt2, 'iiidd', $sale_id, $product_id, $qty, $unit_price, $total_item);
    mysqli_stmt_execute($stmt2);

    // تحديث المخزون
    if ($type == 'wholesale') {
        // إذا بيع جملة: نقص عدد الكارتين * قطع بالكارتون
        $q = $qty * $carton_qty;
    } else {
        // إذا بيع مفرد: نقص بعدد القطع فقط
        $q = $qty;
    }
    mysqli_query($conn, "UPDATE products SET stock = stock - $q WHERE id = $product_id");
}

echo json_encode(array('success' => true, 'sale_id' => $sale_id));
exit;
?>
