<?php
include('config.php');

$supplier_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if (!$supplier_id) die('مورد غير معروف');

$info = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM suppliers WHERE id=$supplier_id"));
if (!$info) die('مورد غير موجود');

// تسجيل تسديد دين
if (isset($_POST['pay']) && floatval($_POST['amount']) > 0) {
    $amount = floatval($_POST['amount']);
    $notes  = isset($_POST['notes']) ? mysqli_real_escape_string($conn, trim($_POST['notes'])) : '';
    mysqli_query($conn, "INSERT INTO supplier_transactions (supplier_id, trans_type, amount, notes) VALUES ($supplier_id, 'payment', $amount, '$notes')");
    header("Location: supplier_details.php?id=$supplier_id&paid=1");
    exit;
}

// جلب كل العمليات
$res = mysqli_query($conn, "SELECT * FROM supplier_transactions WHERE supplier_id=$supplier_id ORDER BY created_at DESC");
$transactions = [];
while ($row = mysqli_fetch_assoc($res)) $transactions[] = $row;

// حساب الرصيد
$total_purchase = 0;
$total_payment  = 0;
foreach($transactions as $tr) {
    if ($tr['trans_type'] == 'purchase') $total_purchase += floatval($tr['amount']);
    if ($tr['trans_type'] == 'payment')  $total_payment  += floatval($tr['amount']);
}
$balance = $total_purchase - $total_payment;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تفاصيل مورد: <?= htmlspecialchars($info['name']); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {background: #f7fafd; font-family: 'Cairo', Arial, sans-serif; margin:0;}
        .container {max-width: 750px; margin: 32px auto 0; background: #fff; border-radius: 22px; box-shadow: 0 8px 36px #e0ebfa80; padding: 30px 15px 23px;}
        h2 {text-align:center;color:#1976d2;font-size:1.6rem;margin-bottom:14px;}
        .summary {text-align:center;font-size:1.13rem;margin-bottom:14px;}
        .summary .neg {color:#c90022;font-weight:bold;}
        .summary .pos {color:#1fa57e;font-weight:bold;}
        .tr-table {width:100%;border-collapse:collapse;margin-bottom:18px;}
        .tr-table th, .tr-table td {padding:8px 7px;border-bottom:1px solid #dbe7f3;font-size:1.05rem;}
        .tr-table th {background:#e8f0fe;}
        .tr-table td {background:#f9fbfd;}
        .tr-table td.purchase {color:#c90022;}
        .tr-table td.payment {color:#1fa57e;}
        .pay-form-box {background:#eaf6ff;padding:12px 12px 8px 12px;border-radius:13px;margin-bottom:18px;max-width:320px;margin-left:auto;margin-right:auto;}
        .pay-form-box input, .pay-form-box textarea {width:90%;margin-bottom:8px;padding:7px 10px;border-radius:7px;border:1px solid #dbe2e8;font-size:1.07rem;}
        .btn {padding:7px 16px;border-radius:7px;font-weight:600;font-size:1rem;border:0;cursor:pointer;background:#1976d2;color:#fff;}
        .btn:hover {background:#144e8b;}
        .toast {margin:0 auto 16px auto;text-align:center;padding:13px 5px;border-radius:9px;font-size:1.09rem;font-weight:600;background:#daf7e3;color:#2b7a5a;}
        @media (max-width: 600px) {
            .container {max-width:99vw;padding:7px;}
            .tr-table th, .tr-table td {font-size:0.93rem;}
            .pay-form-box input, .pay-form-box textarea {width:99%;}
        }
    </style>
</head>
<body>
<div class="container">
    <h2><i class="fa fa-user"></i> تفاصيل المورد: <?= htmlspecialchars($info['name']); ?></h2>
    <?php if (isset($_GET['paid'])): ?>
        <div class="toast"><i class="fa fa-check-circle"></i> تم تسجيل التسديد بنجاح!</div>
    <?php endif; ?>
    <div class="summary">
        <span>إجمالي الشراء: <span class="neg"><?= number_format($total_purchase,2); ?> د.ع</span></span> |
        <span>إجمالي التسديد: <span class="pos"><?= number_format($total_payment,2); ?> د.ع</span></span> |
        <span>الرصيد الحالي: 
            <span class="<?= $balance > 0 ? 'neg' : 'pos'; ?>">
                <?= number_format($balance,2); ?> د.ع
            </span>
        </span>
    </div>

    <!-- نموذج تسديد دين -->
    <div class="pay-form-box">
        <form method="post">
            <input type="number" name="amount" min="1" step="0.01" placeholder="مبلغ التسديد" required>
            <textarea name="notes" rows="1" placeholder="ملاحظات (اختياري)"></textarea>
            <button class="btn" name="pay"><i class="fa fa-hand-holding-usd"></i> تسديد دين</button>
        </form>
    </div>

    <table class="tr-table">
        <thead>
            <tr>
                <th>النوع</th>
                <th>المبلغ</th>
                <th>التاريخ</th>
                <th>ملاحظات</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach($transactions as $tr): ?>
            <tr>
                <td class="<?= $tr['trans_type']; ?>">
                    <?= $tr['trans_type']=='purchase' ? 'شراء (دين)' : 'تسديد' ?>
                </td>
                <td>
                    <?= number_format($tr['amount'],2); ?> د.ع
                </td>
                <td><?= htmlspecialchars($tr['created_at']); ?></td>
                <td><?= htmlspecialchars($tr['notes']); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <div style="text-align:center;margin-top:13px;">
        <a href="suppliers.php" style="color:#1976d2;font-weight:700;text-decoration:none;"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
    </div>
</div>
</body>
</html>
