<?php
session_start();
include 'db.php';

if (isset($_SESSION['admin_id'])) {
    header("Location: admin_dashboard.php");
    exit();
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = isset($_POST['username']) ? mysqli_real_escape_string($conn, $_POST['username']) : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    if ($username !== '' && $password !== '') {
        $pass_md5 = md5($password);
        $sql = "SELECT * FROM admin WHERE username='$username' AND password='$pass_md5' LIMIT 1";
        $res = mysqli_query($conn, $sql);

        if ($res && mysqli_num_rows($res) === 1) {
            $admin = mysqli_fetch_assoc($res);

            $_SESSION['admin_id']       = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];

            // ✅ تحديد صلاحية الأدمن حسب اليوزر
            $role = 'super'; // الافتراضي

            switch ($admin['username']) {
                case 'alawael0':
                    // فقط كارت أسئلة المدرسين
                    $role = 'questions_only';
                    break;

                case 'alawael1':
                    // عرض الواجبات + المادة الداخلة بالامتحان + إحصائية الواجبات
                    $role = 'homework_exam_stats';
                    break;

                case 'alawael2':
                    // تقييمات الطلبة + الإحصائيات + درجات الطلبة للمواد + الواجبات + إحصائية الواجبات
                    $role = 'eval_stats_grades';
                    break;

                case 'awael':   // اليوزر القديم
                case 'alawael': // اليوزر الجديد الكامل
                default:
                    // كامل الصلاحيات
                    $role = 'super';
                    break;
            }

            $_SESSION['admin_role'] = $role;

            header("Location: admin_dashboard.php");
            exit();
        } else {
            $error = "❌ اسم المستخدم أو كلمة المرور غير صحيحة.";
        }
    } else {
        $error = "⚠️ يرجى إدخال البيانات.";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>🔐 دخول الأدمن | ثانوية الأوائل الأهلية للبنين</title>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
:root{--radius:22px;}
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  display:flex;
  justify-content:center;
  align-items:center;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  position:relative;
  overflow-y:auto;
  padding:14px;
}
body::before{
  content:"";
  position:fixed;
  inset:-50%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.2),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.2),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.15),transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{to{transform:rotate(360deg) scale(1.08)}}

.container{
  width:92vw;
  max-width:420px;
  background:rgba(255,255,255,0.08);
  border-radius:25px;
  backdrop-filter:blur(18px);
  box-shadow:0 0 40px rgba(0,255,255,0.12);
  text-align:center;
  padding:32px 18px 26px;
  border:1px solid rgba(255,255,255,0.15);
  margin:auto;
}
.logo{
  width:110px;height:110px;margin:0 auto 14px;
  background:radial-gradient(circle,rgba(255,215,0,0.15),transparent 70%);
  border-radius:50%;
  display:flex;justify-content:center;align-items:center;
  animation:glow 3s ease-in-out infinite alternate;
}
.logo img{width:78px;height:78px;object-fit:contain}
@keyframes glow{0%{box-shadow:0 0 10px rgba(255,215,0,0.4)}100%{box-shadow:0 0 25px rgba(0,255,255,0.6)}}

h1{font-size:20px;margin-bottom:4px}
h2{font-size:13.5px;color:#00e6ff;margin-bottom:18px}

input{
  width:100%;
  padding:12px 10px;
  border:none;
  border-radius:12px;
  background:rgba(255,255,255,0.98);
  margin-bottom:12px;
  text-align:center;
  font-size:14px;
  outline:none;
  transition:.3s;
  color:#111;
}
input:focus{
  box-shadow:0 0 15px rgba(0,230,255,0.6);
  transform:scale(1.01);
}

button{
  width:100%;
  padding:11px;
  border:none;
  border-radius:12px;
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;
  font-weight:700;
  cursor:pointer;
  font-size:15px;
  transition:.25s;
}
button:hover{transform:scale(1.02);box-shadow:0 0 20px rgba(0,255,255,0.4)}

.error{
  background:rgba(255,0,0,0.25);
  border:1px solid rgba(255,100,100,0.4);
  margin-bottom:12px;
  padding:7px 10px;
  border-radius:10px;
  font-size:13px;
}

footer{margin-top:18px;font-size:12.5px;color:#ccc}
footer span{color:#00e6ff}

@media (max-width:360px){
  .container{
    width:98vw;
    padding:26px 12px 20px;
    border-radius:16px;
  }
  h1{font-size:18px}
  h2{font-size:12.5px}
  input,button{font-size:13.5px}
}
</style>
</head>
<body>

<div class="container">
  <div class="logo">
    <img src="bookk.png" alt="شعار الأدمن">
  </div>
  <h1>🔐 ثانوية الأوائل الأهلية للبنين</h1>
  <h2>تسجيل دخول الأدمن</h2>

  <?php if($error!=""): ?>
    <div class="error"><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></div>
  <?php endif; ?>

  <form method="post" autocomplete="off">
    <input type="text" name="username" placeholder="اسم المستخدم" required>
    <input type="password" name="password" placeholder="كلمة المرور" required>
    <button type="submit">دخول</button>
  </form>

  <footer>
    © <span><?php echo date("Y"); ?></span> جميع الحقوق محفوظة - <b>ثانوية الأوائل الأهلية</b>
  </footer>
</div>

</body>
</html>
