<?php
session_start();
include 'db.php';

/* ===========================================================
   ✅ صلاحيات الدخول
   - super               → awael / alawael (إدارة كاملة)
   - homework_exam_stats → alawael1 (واجبات + إحصائيات الامتحان)
   - eval_stats_grades   → alawael2 (تقييمات + درجات)
   - questions_only      → alawael0 (صفحة الأسئلة فقط)

   هذه الصفحة خاصة بـ:
   super (المدير العام) فقط
   =========================================================== */

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");

// جلب بيانات الأدمن وتحديد الـ role
$admin_username = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : '';
$admin_role     = isset($_SESSION['admin_role']) ? $_SESSION['admin_role'] : null;

if ($admin_role === null) {
    switch ($admin_username) {
        case 'alawael0':
            $admin_role = 'questions_only';
            break;
        case 'alawael1':
            $admin_role = 'homework_exam_stats';
            break;
        case 'alawael2':
            $admin_role = 'eval_stats_grades';
            break;
        case 'awael':
        case 'alawael':
        default:
            $admin_role = 'super';
            break;
    }
    $_SESSION['admin_role'] = $admin_role;
}

// ❌ منع أي حساب غير super من الدخول لهذه الصفحة
if ($admin_role !== 'super') {
    header("Location: admin_dashboard.php");
    exit();
}

// ====================
//  جلب المدرسين والمواد
// ====================
$teachers  = array();
$subjects  = array();

$q_teachers = mysqli_query($conn, "SELECT id, name, subject FROM teachers ORDER BY name ASC");
if ($q_teachers) {
    while ($row = mysqli_fetch_assoc($q_teachers)) {
        $teachers[] = $row;
        if (isset($row['subject']) && $row['subject'] != '') {
            if (!in_array($row['subject'], $subjects)) {
                $subjects[] = $row['subject'];
            }
        }
    }
}

sort($subjects); // ترتيب المواد أبجدياً

// ====================
//  متغيرات افتراضية
// ====================
$title = '';
$body  = '';
$category = '';
$priority = 'normal';

// ✅ تمت إزالة خيار التأكيد من الواجهة — ونحفظ دائماً 0
$require_confirm = 0;

$target_type = 'all';
$target_stage = '';
$target_subject = '';
$target_classes = '';
$target_teacher_ids = '';

// ✅ متغيرات الجدولة
$send_type     = 'now';  // now | schedule
$schedule_date = '';
$schedule_time = '';

// ====================
//  معالجة الإرسال
// ====================
$success_msg = '';
$error_msg   = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // استلام القيم
    $title    = isset($_POST['title'])   ? trim($_POST['title'])   : '';
    $body     = isset($_POST['body'])    ? trim($_POST['body'])    : '';
    $category = isset($_POST['category'])? trim($_POST['category']): '';
    $priority = isset($_POST['priority'])? trim($_POST['priority']): 'normal';

    // ❌ لا نقرأ require_confirm من POST — دائماً 0
    $require_confirm = 0;

    $target_type    = isset($_POST['target_type']) ? trim($_POST['target_type']) : 'all';
    $target_stage   = isset($_POST['target_stage']) ? trim($_POST['target_stage']) : '';
    $target_subject = isset($_POST['target_subject']) ? trim($_POST['target_subject']) : '';
    $target_classes = isset($_POST['target_classes']) ? trim($_POST['target_classes']) : '';

    // ✅ نوع الإرسال والجدولة
    $send_type     = isset($_POST['send_type']) ? $_POST['send_type'] : 'now';
    $schedule_date = isset($_POST['schedule_date']) ? trim($_POST['schedule_date']) : '';
    $schedule_time = isset($_POST['schedule_time']) ? trim($_POST['schedule_time']) : '';

    // المدرسين المحددين (في حالة target_type = teachers)
    $target_teacher_ids = '';
    if (isset($_POST['target_teachers']) && is_array($_POST['target_teachers']) && count($_POST['target_teachers']) > 0) {
        // فلترة القيم لتكون أرقام فقط
        $clean_ids = array();
        foreach ($_POST['target_teachers'] as $tid) {
            $tid = (int)$tid;
            if ($tid > 0) {
                $clean_ids[] = $tid;
            }
        }
        if (count($clean_ids) > 0) {
            $target_teacher_ids = implode(',', $clean_ids);
        }
    }

    // ✅ في حالة استهداف "مرحلة + شُعب" نخزن المرحلة من target_stage_sc
    //   ونحوّل الـ classes_arr إلى نص مثل: A,B,C
    if ($target_type === 'stage_class') {
        $target_stage = isset($_POST['target_stage_sc']) ? trim($_POST['target_stage_sc']) : '';
        if (isset($_POST['classes_arr']) && is_array($_POST['classes_arr'])) {
            $cls_arr = array();
            foreach ($_POST['classes_arr'] as $cl) {
                $cl = trim($cl);
                if ($cl !== '') {
                    $cls_arr[] = $cl;
                }
            }
            $target_classes = implode(',', $cls_arr);
        } else {
            $target_classes = '';
        }
    }

    // ✅ تحقق أساسي
    if ($title === '' || $body === '') {
        $error_msg = "يجب إدخال عنوان التبليغ ونص التبليغ.";
    }

    // ✅ تحقق من بيانات الجدولة
    if ($send_type === 'schedule') {
        if ($schedule_date === '' || $schedule_time === '') {
            if ($error_msg != '') $error_msg .= " ";
            $error_msg .= "عند اختيار الإرسال المجدول يجب تحديد التاريخ والوقت.";
        }
    }

    if ($error_msg === '') {
        // فلترة قبل الإدخال
        $title_db    = mysqli_real_escape_string($conn, $title);
        $body_db     = mysqli_real_escape_string($conn, $body);
        $category_db = mysqli_real_escape_string($conn, $category);
        $priority_db = mysqli_real_escape_string($conn, $priority);

        $target_type_db        = mysqli_real_escape_string($conn, $target_type);
        $target_stage_db       = mysqli_real_escape_string($conn, $target_stage);
        $target_subject_db     = mysqli_real_escape_string($conn, $target_subject);
        $target_classes_db     = mysqli_real_escape_string($conn, $target_classes);
        $target_teacher_ids_db = mysqli_real_escape_string($conn, $target_teacher_ids);

        // ✅ صلاحية التبليغ: حالياً نلغيها ونخزن NULL دائماً
        $valid_until_db = "NULL";

        // ✅ إعداد قيم الجدولة
        $is_scheduled     = 0;
        $scheduled_at_db  = "NULL";

        if ($send_type === 'schedule') {
            $scheduled_at = $schedule_date . ' ' . $schedule_time . ':00'; // مثال: 2025-11-23 09:30:00
            $is_scheduled = 1;
            $scheduled_at_db = "'" . mysqli_real_escape_string($conn, $scheduled_at) . "'";
        }

        $admin_id = isset($_SESSION['admin_id']) ? (int)$_SESSION['admin_id'] : 0;

        $sql_insert = "
        INSERT INTO admin_notifications
        (title, body, category, priority, require_confirm, target_type, target_stage, target_subject, target_classes, target_teacher_ids, created_by_admin_id, valid_until, is_scheduled, scheduled_at)
        VALUES
        (
            '$title_db',
            '$body_db',
            '$category_db',
            '$priority_db',
            ".(int)$require_confirm.",
            '$target_type_db',
            '$target_stage_db',
            '$target_subject_db',
            '$target_classes_db',
            '$target_teacher_ids_db',
            $admin_id,
            $valid_until_db,
            $is_scheduled,
            $scheduled_at_db
        )
        ";

        if (mysqli_query($conn, $sql_insert)) {
            $success_msg = "✅ تم حفظ التبليغ بنجاح.";
            // تفريغ الحقول بعد الحفظ
            $title = $body = $category = '';
            $priority = 'normal';
            $require_confirm = 0;
            $target_type = 'all';
            $target_stage = $target_subject = $target_classes = '';
            $target_teacher_ids = '';

            // إعادة تعيين بيانات الجدولة
            $send_type     = 'now';
            $schedule_date = '';
            $schedule_time = '';
        } else {
            $error_msg = "❌ حدث خطأ أثناء حفظ التبليغ: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📢 إنشاء تبليغ إداري جديد</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  flex-direction:column;
  overflow-x:hidden;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.18),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.14),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.18),transparent 60%);
  animation:nebula 28s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{
  0%{transform:rotate(0deg) scale(1);}
  100%{transform:rotate(360deg) scale(1.2);}
}

/* ====== الهيدر العلوي ====== */
header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:14px 18px;
  background:rgba(15,23,42,0.8);
  border-bottom:1px solid rgba(148,163,184,0.35);
  backdrop-filter:blur(14px);
}
.header-left{
  display:flex;
  align-items:center;
  gap:10px;
}
.logo-circle{
  width:38px;
  height:38px;
  border-radius:50%;
  background:radial-gradient(circle at 30% 20%,#e0f2fe,#38bdf8);
  display:flex;
  align-items:center;
  justify-content:center;
  font-size:20px;
  box-shadow:0 0 18px rgba(56,189,248,0.8);
}
.logo-text-main{font-size:15px;font-weight:700;}
.logo-text-sub{font-size:12px;color:#cbd5f5;}
.btn-header{
  background:linear-gradient(120deg,#00e6ff,#007bff);
  color:#fff;
  padding:7px 16px;
  border-radius:999px;
  text-decoration:none;
  font-size:13px;
  font-weight:600;
  box-shadow:0 0 14px rgba(59,130,246,0.7);
  transition:.25s;
}
.btn-header:hover{
  transform:translateY(-1px) scale(1.02);
  box-shadow:0 0 22px rgba(56,189,248,0.9);
}

/* ====== الحاوية الرئيسية ====== */
.main-wrap{
  width:100%;
  max-width:1100px;
  margin:25px auto 40px;
  padding:0 15px;
}

/* كارت فورم التبليغ */
.card{
  background:rgba(15,23,42,0.88);
  border-radius:18px;
  padding:24px 22px 28px;
  box-shadow:
    0 24px 60px rgba(15,23,42,0.9),
    0 0 0 1px rgba(148,163,184,0.35);
  border:1px solid rgba(148,163,184,0.45);
}
.card-header{
  display:flex;
  flex-direction:column;
  gap:6px;
  margin-bottom:18px;
  text-align:center;
}
.card-header h1{font-size:20px;}
.card-header .subtitle{font-size:13px;color:#cbd5f5;}

/* تنسيقات الفورم */
form{margin-top:5px;}
.form-row{margin-bottom:14px;}
label{
  display:block;
  margin-bottom:5px;
  font-weight:600;
  font-size:13px;
}
input[type="text"],
input[type="date"],
input[type="time"],
select,
textarea{
  width:100%;
  padding:8px 10px;
  border-radius:10px;
  border:1px solid rgba(148,163,184,0.6);
  font-size:13px;
  background:rgba(15,23,42,0.85);
  color:#e5e7eb;
  outline:none;
}
input[type="text"]:focus,
input[type="date"]:focus,
input[type="time"]:focus,
select:focus,
textarea:focus{
  border-color:#38bdf8;
  box-shadow:0 0 0 1px rgba(56,189,248,0.6);
}
textarea{min-height:120px;resize:vertical;}
small{color:#9ca3af;font-size:11px;display:block;margin-top:3px;}

.badge{
  display:inline-block;
  background:linear-gradient(120deg,#0ea5e9,#6366f1);
  color:#fff;
  padding:2px 8px;
  border-radius:999px;
  font-size:10px;
  margin-right:5px;
}

/* راديو وصناديق اختيار */
.radio-group,
.checkbox-group{
  display:flex;
  flex-wrap:wrap;
  gap:10px;
  margin-top:4px;
}
.radio-item,
.checkbox-item{
  display:flex;
  align-items:center;
  gap:5px;
  font-size:12px;
}
.radio-item input,
.checkbox-item input{margin:0;}

/* عناوين الأقسام داخل الكارت */
.section-title{
  margin:12px 0 6px;
  font-weight:700;
  font-size:14px;
  display:inline-flex;
  align-items:center;
  gap:6px;
}
.section-title::before{
  content:"";
  width:4px;
  height:18px;
  border-radius:999px;
  background:linear-gradient(180deg,#0ea5e9,#6366f1);
}

/* مربعات الاستهداف والجدولة */
.target-box{
  padding:10px;
  border-radius:12px;
  border:1px dashed rgba(148,163,184,0.7);
  margin-top:8px;
  background:rgba(15,23,42,0.85);
}

/* قائمة المدرسين */
.teacher-list{
  max-height:220px;
  overflow-y:auto;
  border:1px solid rgba(148,163,184,0.6);
  border-radius:12px;
  padding:8px;
  background:rgba(15,23,42,0.95);
  margin-top:5px;
}
.teacher-item{
  margin-bottom:4px;
  font-size:12px;
  color:#e5e7eb;
}

/* أزرار الأسفل */
.actions{margin-top:18px;text-align:center;}
button[type="submit"]{
  padding:9px 28px;
  background:linear-gradient(120deg,#22c55e,#16a34a);
  border:none;
  border-radius:999px;
  color:#fff;
  font-size:14px;
  cursor:pointer;
  font-weight:600;
  box-shadow:0 0 18px rgba(34,197,94,0.7);
  transition:.25s;
}
button[type="submit"]:hover{
  transform:translateY(-1px) scale(1.02);
  box-shadow:0 0 26px rgba(34,197,94,0.9);
}

/* رسائل النجاح والخطأ */
.alert{
  padding:9px 11px;
  border-radius:10px;
  margin-bottom:12px;
  font-size:13px;
  border:1px solid transparent;
}
.alert.success{
  background:rgba(22,163,74,0.12);
  color:#bbf7d0;
  border-color:rgba(34,197,94,0.6);
}
.alert.error{
  background:rgba(239,68,68,0.12);
  color:#fecaca;
  border-color:rgba(239,68,68,0.7);
}

/* ألوان الأولوية */
.priority-normal{color:#38bdf8;}
.priority-important{color:#fdba74;}
.priority-urgent{color:#fecaca;font-weight:700;}

/* ريسبونسيف */
@media(max-width:700px){
  header{flex-direction:column;align-items:flex-start;gap:8px;}
  .main-wrap{margin-top:18px;}
}
</style>
</head>
<body>

<header>
  <div class="header-left">
    <div class="logo-circle">🎓</div>
    <div>
      <div class="logo-text-main">ثانوية الأوائل الأهلية للبنين</div>
      <div class="logo-text-sub">نظام التبليغات الإدارية للكادر التدريسي</div>
    </div>
  </div>
  <a href="admin_dashboard.php" class="btn-header">↩ العودة إلى لوحة التحكم</a>
</header>

<div class="main-wrap">
  <div class="card">

    <div class="card-header">
      <h1>📢 إنشاء تبليغ إداري جديد</h1>
      <div class="subtitle">
        استخدم هذه الصفحة لإرسال تبليغات إدارية موجهة للكادر، مع تصنيفها وتحديد درجة أهميتها واستهدافها بدقة،
        مع إمكانية جدولة الإرسال في تاريخ ووقت محدّد.
      </div>
    </div>

    <?php if ($success_msg != ''): ?>
      <div class="alert success"><?php echo htmlspecialchars($success_msg, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>

    <?php if ($error_msg != ''): ?>
      <div class="alert error"><?php echo htmlspecialchars($error_msg, ENT_QUOTES, 'UTF-8'); ?></div>
    <?php endif; ?>

    <form method="post" action="">

      <!-- عنوان التبليغ -->
      <div class="form-row">
        <label>عنوان التبليغ <span class="badge">مطلوب</span></label>
        <input type="text" name="title" value="<?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?>" placeholder="مثال: تبليغ بخصوص امتحان نصف السنة">
      </div>

      <!-- نص التبليغ -->
      <div class="form-row">
        <label>نص التبليغ <span class="badge">مطلوب</span></label>
        <textarea name="body" placeholder="اكتب تفاصيل التبليغ الإداري هنا..."><?php echo htmlspecialchars($body, ENT_QUOTES, 'UTF-8'); ?></textarea>
      </div>

      <!-- نوع التبليغ -->
      <div class="form-row">
        <label>نوع التبليغ (التصنيف)</label>
        <select name="category">
          <option value="">— اختر نوع التبليغ —</option>
          <option value="امتحانات"          <?php if($category=='امتحانات') echo 'selected'; ?>>تبليغات الامتحانات</option>
          <option value="الحضور"            <?php if($category=='الحضور') echo 'selected'; ?>>تبليغات الحضور والانصراف</option>
          <option value="الدرجات"           <?php if($category=='الدرجات') echo 'selected'; ?>>تبليغات الدرجات والنتائج</option>
          <option value="اداري"             <?php if($category=='اداري') echo 'selected'; ?>>تبليغات إدارية عامة</option>
          <option value="عطل ودوام"         <?php if($category=='عطل ودوام') echo 'selected'; ?>>العطل والدوام الرسمي</option>
          <option value="اجتماعات"          <?php if($category=='اجتماعات') echo 'selected'; ?>>تبليغات الاجتماعات</option>
          <option value="النظام الالكتروني" <?php if($category=='النظام الالكتروني') echo 'selected'; ?>>تبليغات النظام الإلكتروني</option>
        </select>
      </div>

      <!-- أولوية التبليغ -->
      <div class="form-row">
        <label>أولوية التبليغ</label>
        <div class="radio-group">
          <label class="radio-item">
            <input type="radio" name="priority" value="normal" <?php if($priority=='normal') echo 'checked'; ?>>
            <span class="priority-normal">عادي</span>
          </label>
          <label class="radio-item">
            <input type="radio" name="priority" value="important" <?php if($priority=='important') echo 'checked'; ?>>
            <span class="priority-important">مهم</span>
          </label>
          <label class="radio-item">
            <input type="radio" name="priority" value="urgent" <?php if($priority=='urgent') echo 'checked'; ?>>
            <span class="priority-urgent">عاجل جداً</span>
          </label>
        </div>
      </div>

      <!-- ✅ وقت إرسال التبليغ (فوري أو مجدول) -->
      <div class="form-row">
        <label>وقت إرسال التبليغ</label>
        <div class="radio-group">
          <label class="radio-item">
            <input type="radio" name="send_type" value="now" <?php if($send_type=='now') echo 'checked'; ?> onclick="toggleScheduleBox()">
            <span>إرسال فوري بعد الحفظ</span>
          </label>
          <label class="radio-item">
            <input type="radio" name="send_type" value="schedule" <?php if($send_type=='schedule') echo 'checked'; ?> onclick="toggleScheduleBox()">
            <span>إرسال مجدول بتاريخ ووقت محدّد</span>
          </label>
        </div>

        <div id="schedule_box" class="target-box" style="display:<?php echo ($send_type=='schedule'?'block':'none'); ?>;">
          <label>التاريخ والوقت المجدولين</label>
          <div style="display:flex;gap:10px;flex-wrap:wrap;">
            <div style="flex:1;min-width:140px;">
              <small>📅 التاريخ</small>
              <input type="date" name="schedule_date" value="<?php echo htmlspecialchars($schedule_date, ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div style="flex:1;min-width:120px;">
              <small>⏰ الوقت</small>
              <input type="time" name="schedule_time" value="<?php echo htmlspecialchars($schedule_time, ENT_QUOTES, 'UTF-8'); ?>">
            </div>
          </div>
          <small>سيظهر هذا التبليغ للمدرّسين تلقائياً عند حلول هذا التاريخ والوقت.</small>
        </div>
      </div>

      <!-- استهداف التبليغ -->
      <div class="form-row">
        <div class="section-title">استهداف التبليغ (لمن يتم إرسال هذا التبليغ؟)</div>
        <select name="target_type" id="target_type" onchange="updateTargetFields()">
          <option value="all"        <?php if($target_type=='all') echo 'selected'; ?>>لكل الكادر التدريسي</option>
          <option value="stage"      <?php if($target_type=='stage') echo 'selected'; ?>>مدرّسو مرحلة معيّنة</option>
          <option value="subject"    <?php if($target_type=='subject') echo 'selected'; ?>>مدرّسو مادة معيّنة</option>
          <option value="stage_class"<?php if($target_type=='stage_class') echo 'selected'; ?>>مرحلة + شُعب محددة</option>
          <option value="teachers"   <?php if($target_type=='teachers') echo 'selected'; ?>>مدرّسون محددون بالاسم</option>
        </select>

        <!-- استهداف بالمرحلة -->
        <div id="box_stage" class="target-box" style="display:none;">
          <label>اختر المرحلة المستهدفة</label>
          <select name="target_stage">
            <option value="">— اختر المرحلة —</option>
            <option <?php if($target_stage=='أول متوسط')      echo 'selected'; ?>>أول متوسط</option>
            <option <?php if($target_stage=='الثاني المتوسط')  echo 'selected'; ?>>الثاني المتوسط</option>
            <option <?php if($target_stage=='الثالث المتوسط')  echo 'selected'; ?>>الثالث المتوسط</option>
            <option <?php if($target_stage=='الرابع العلمي')   echo 'selected'; ?>>الرابع العلمي</option>
            <option <?php if($target_stage=='الخامس العلمي')   echo 'selected'; ?>>الخامس العلمي</option>
            <option <?php if($target_stage=='السادس العلمي')   echo 'selected'; ?>>السادس العلمي</option>
          </select>
          <small>سيطبَّق لاحقاً في صفحة عرض التبليغات للمدرسين لتحديد من يظهر لهم هذا التبليغ.</small>
        </div>

        <!-- استهداف بالمادة -->
        <div id="box_subject" class="target-box" style="display:none;">
          <label>اختر المادة المستهدفة</label>
          <select name="target_subject">
            <option value="">— اختر المادة —</option>
            <?php foreach ($subjects as $sub): ?>
              <option value="<?php echo htmlspecialchars($sub, ENT_QUOTES, 'UTF-8'); ?>"
                <?php if($target_subject==$sub) echo 'selected'; ?>>
                <?php echo htmlspecialchars($sub, ENT_QUOTES, 'UTF-8'); ?>
              </option>
            <?php endforeach; ?>
          </select>
          <small>سيظهر هذا التبليغ لأساتذة هذه المادة فقط.</small>
        </div>

        <!-- استهداف مرحلة + شعب -->
        <div id="box_stage_class" class="target-box" style="display:none;">
          <label>اختر المرحلة</label>
          <select name="target_stage_sc">
            <option value="">— اختر المرحلة —</option>
            <option <?php if($target_stage=='أول متوسط')      echo 'selected'; ?>>أول متوسط</option>
            <option <?php if($target_stage=='الثاني المتوسط')  echo 'selected'; ?>>الثاني المتوسط</option>
            <option <?php if($target_stage=='الثالث المتوسط')  echo 'selected'; ?>>الثالث المتوسط</option>
            <option <?php if($target_stage=='الرابع العلمي')   echo 'selected'; ?>>الرابع العلمي</option>
            <option <?php if($target_stage=='الخامس العلمي')   echo 'selected'; ?>>الخامس العلمي</option>
            <option <?php if($target_stage=='السادس العلمي')   echo 'selected'; ?>>السادس العلمي</option>
          </select>

          <label style="margin-top:8px;">الشُعب المستهدفة</label>
          <div class="checkbox-group">
            <?php
            $classes_selected = array();
            if ($target_classes != '') {
                $classes_selected = explode(',', $target_classes);
            }
            $all_classes = array('A','B','C','D','E','F');
            foreach ($all_classes as $cl):
            ?>
            <label class="checkbox-item">
              <input type="checkbox" name="classes_arr[]" value="<?php echo $cl; ?>"
                <?php if(in_array($cl, $classes_selected)) echo 'checked'; ?>>
              <span><?php echo $cl; ?></span>
            </label>
            <?php endforeach; ?>
          </div>
          <small>سيتم تخزين الشُعب مثل: A,B,C داخل حقل target_classes.</small>
        </div>

        <!-- استهداف مدرّسين بالاسم -->
        <div id="box_teachers" class="target-box" style="display:none;">
          <label>اختر المدرسين المستهدفين</label>
          <div class="teacher-list">
            <?php
            $selected_teachers = array();
            if ($target_teacher_ids != '') {
                $selected_teachers = explode(',', $target_teacher_ids);
            }
            foreach ($teachers as $t):
                $tid = (int)$t['id'];
                $checked = in_array($tid, $selected_teachers) ? 'checked' : '';
            ?>
              <div class="teacher-item">
                <label>
                  <input type="checkbox" name="target_teachers[]" value="<?php echo $tid; ?>" <?php echo $checked; ?>>
                  <?php echo htmlspecialchars($t['name'], ENT_QUOTES, 'UTF-8'); ?>
                  <?php if($t['subject'] != ''): ?>
                    – <span style="color:#9ca3af;font-size:11px;"><?php echo htmlspecialchars($t['subject'], ENT_QUOTES, 'UTF-8'); ?></span>
                  <?php endif; ?>
                </label>
              </div>
            <?php endforeach; ?>
          </div>
          <small>يمكن تحديد مدرس أو أكثر لتوجيه التبليغ لهم فقط.</small>
        </div>

      </div>

      <div class="actions">
        <button type="submit">💾 حفظ التبليغ</button>
      </div>

    </form>
  </div>
</div>

<script>
// تحديث إظهار/إخفاء حقول الاستهداف حسب نوع الاستهداف
function updateTargetFields(){
  var v = document.getElementById('target_type').value;
  document.getElementById('box_stage').style.display        = (v === 'stage') ? 'block' : 'none';
  document.getElementById('box_subject').style.display      = (v === 'subject') ? 'block' : 'none';
  document.getElementById('box_stage_class').style.display  = (v === 'stage_class') ? 'block' : 'none';
  document.getElementById('box_teachers').style.display     = (v === 'teachers') ? 'block' : 'none';
}

// إظهار/إخفاء صندوق الجدولة
function toggleScheduleBox(){
  var radios = document.getElementsByName('send_type');
  var val = 'now';
  for(var i=0;i<radios.length;i++){
    if(radios[i].checked){
      val = radios[i].value;
      break;
    }
  }
  var box = document.getElementById('schedule_box');
  if (box) {
    box.style.display = (val === 'schedule') ? 'block' : 'none';
  }
}

// عند تحميل الصفحة أول مرة
updateTargetFields();
toggleScheduleBox();
</script>

</body>
</html>
