<?php
session_start();
include 'db.php';

// ✅ ضبط التوقيت حسب مدينة الموصل (آسيا/بغداد)
date_default_timezone_set('Asia/Baghdad');

// ✅ التحقق من تسجيل دخول الأدمن
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");

// ✅ جلب بيانات الأدمن من الجلسة
$admin_username = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : '';
$admin_role     = isset($_SESSION['admin_role']) ? $_SESSION['admin_role'] : null;

// ✅ لو ماكو role (جلسة قديمة) نحدده من اسم المستخدم
if ($admin_role === null) {
    switch ($admin_username) {
        case 'alawael0':
            $admin_role = 'questions_only';
            break;
        case 'alawael1':
            $admin_role = 'homework_exam_stats';
            break;
        case 'alawael2':
            $admin_role = 'eval_stats_grades';
            break;
        case 'awael':
        case 'alawael':
        default:
            $admin_role = 'super';
            break;
    }
    $_SESSION['admin_role'] = $admin_role;
}

// ✅ السماح فقط لـ super (تقدر تعدلها لو تحب تضيف صلاحيات ثانية)
if ($admin_role !== 'super') {
    header("Location: admin_dashboard.php");
    exit();
}

// دالة بسيطة لتأمين المخرجات
function esc($s) {
    return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

// دالة لتحديد نوع الجهاز من الـ User Agent
function device_type($ua) {
    $ua = strtolower($ua);
    if ($ua == '') return '';
    if (strpos($ua, 'android') !== false || strpos($ua, 'iphone') !== false || strpos($ua, 'mobile') !== false)
        return '📱 موبايل';
    if (strpos($ua, 'ipad') !== false || strpos($ua, 'tablet') !== false)
        return '📲 تابلت';
    return '💻 كمبيوتر';
}

// ✅ دالة لاستخراج اسم المتصفح من User-Agent
function detect_browser_name($ua) {
    $ua_l = strtolower($ua);
    if ($ua_l === '' || $ua_l === null) {
        return 'متصفح غير معروف';
    }

    // Edge
    if (strpos($ua_l, 'edg/') !== false) {
        return 'مايكروسوفت إيدج';
    }

    // Opera
    if (strpos($ua_l, 'opr/') !== false || strpos($ua_l, 'opera') !== false) {
        return 'أوبرا';
    }

    // Firefox
    if (strpos($ua_l, 'firefox/') !== false) {
        return 'موزيلا فايرفوكس';
    }

    // Chrome (بدون Edge أو Opera)
    if (strpos($ua_l, 'chrome/') !== false && strpos($ua_l, 'safari/') !== false
        && strpos($ua_l, 'edg/') === false && strpos($ua_l, 'opr/') === false) {
        return 'جوجل كروم';
    }

    // Safari فقط
    if (strpos($ua_l, 'safari/') !== false && strpos($ua_l, 'chrome/') === false) {
        return 'سفاري';
    }

    return 'متصفح غير معروف';
}

// ----------------------------------------------------
// ١) جلب قائمة المدرسين للفلاتر
// ----------------------------------------------------
$teachers = array();
$resT = mysqli_query($conn, "SELECT id, name, subject FROM teachers ORDER BY name ASC");
if ($resT) {
    while ($row = mysqli_fetch_assoc($resT)) {
        $teachers[] = $row;
    }
}

// ----------------------------------------------------
// ٢) قراءة الفلاتر من GET
// ----------------------------------------------------
$filter_teacher_id = isset($_GET['teacher_id']) ? (int)$_GET['teacher_id'] : 0;
$date_from         = isset($_GET['from']) ? trim($_GET['from']) : '';
$date_to           = isset($_GET['to'])   ? trim($_GET['to'])   : '';

// التحقق من تنسيق التاريخ (YYYY-MM-DD)
if ($date_from != '' && !preg_match('/^\d{4}-\d{2}-\d{2}$/', $date_from)) {
    $date_from = '';
}
if ($date_to != '' && !preg_match('/^\d{4}-\d{2}-\d{2}$/', $date_to)) {
    $date_to = '';
}

// ----------------------------------------------------
// ٣) جلب سجلات الدخول حسب الفلاتر
// ----------------------------------------------------
$where = "1=1";

if ($filter_teacher_id > 0) {
    $where .= " AND l.teacher_id = ".$filter_teacher_id;
}
if ($date_from != '') {
    $date_from_db = mysqli_real_escape_string($conn, $date_from);
    $where .= " AND DATE(l.login_time) >= '".$date_from_db."'";
}
if ($date_to != '') {
    $date_to_db = mysqli_real_escape_string($conn, $date_to);
    $where .= " AND DATE(l.login_time) <= '".$date_to_db."'";
}

$logs = array();
$total_logins = 0;
$teachers_set = array();

$sql_logs = "
    SELECT 
        l.*,
        t.stages,
        t.classes
    FROM teacher_login_log l
    LEFT JOIN teachers t ON t.id = l.teacher_id
    WHERE $where
    ORDER BY l.login_time DESC
    LIMIT 1000
";
$resL = mysqli_query($conn, $sql_logs);
if ($resL) {
    while ($row = mysqli_fetch_assoc($resL)) {
        $logs[] = $row;
        $total_logins++;
        $tid = (int)$row['teacher_id'];
        $teachers_set[$tid] = true;
    }
}

$total_teachers = count($teachers_set);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📅 سجلات دخول المدرّسين</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
    font-family:'Tajawal',sans-serif;
    background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
    color:#fff;
    min-height:100vh;
    padding:20px;
}
header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-bottom:15px;
}
header h1{
    font-size:22px;
}
header a{
    text-decoration:none;
    padding:7px 16px;
    border-radius:999px;
    background:linear-gradient(120deg,#00e6ff,#007bff);
    color:#fff;
    font-weight:600;
}
.filter-card{
    max-width:1200px;
    margin:0 auto 15px;
    background:#14172b;
    border-radius:14px;
    padding:12px 16px;
    box-shadow:0 10px 25px rgba(0,0,0,0.4);
}
.filter-row{
    display:flex;
    flex-wrap:wrap;
    gap:10px;
    align-items:flex-end;
}
.filter-group{
    flex:1 1 180px;
}
.filter-group label{
    display:block;
    margin-bottom:4px;
    font-size:13px;
}
.filter-group select,
.filter-group input{
    width:100%;
    padding:6px 8px;
    border-radius:8px;
    border:1px solid #444;
    background:#0f1120;
    color:#fff;
}
.btn{
    padding:8px 16px;
    border-radius:10px;
    border:none;
    cursor:pointer;
    font-weight:600;
    background:#2ecc71;
    color:#000;
}
.stats{
    max-width:1200px;
    margin:10px auto;
    display:flex;
    flex-wrap:wrap;
    gap:10px;
}
.stat-box{
    flex:1 1 200px;
    background:#14172b;
    border-radius:10px;
    padding:10px 12px;
    border:1px solid rgba(255,255,255,0.08);
}
.stat-label{
    font-size:13px;
    color:#cbd5f5;
    margin-bottom:4px;
}
.stat-value{
    font-size:18px;
    font-weight:700;
    color:#00e6ff;
}
.table-wrapper{
    max-width:1200px;
    margin:10px auto;
    background:#14172b;
    border-radius:14px;
    padding:10px;
    box-shadow:0 10px 25px rgba(0,0,0,0.4);
    overflow:auto;
}
table{
    width:100%;
    border-collapse:separate;
    border-spacing:0;
    min-width:800px;
}
th,td{
    border:1px solid #2b3050;
    padding:4px 6px;
    text-align:center;
    font-size:13px;
    white-space:nowrap;
}
thead th{
    background:#1f2440;
}
tr:nth-child(even) td{
    background:#101326;
}
tr:hover td{
    background:#1a1f38;
}
td.name-cell{
    text-align:right;
}
td.info-cell{
    font-size:12px;
    color:#cbd5f5;
}
@media(max-width:700px){
    body{padding:10px;}
    header{flex-direction:column;align-items:flex-start;gap:8px;}
}
</style>
</head>
<body>

<header>
    <h1>📅 سجلات دخول المدرّسين</h1>
    <a href="admin_dashboard.php">↩ العودة للوحة التحكم</a>
</header>

<div class="filter-card">
    <form method="get">
        <div class="filter-row">
            <div class="filter-group">
                <label>المدرّس</label>
                <select name="teacher_id">
                    <option value="0">جميع المدرّسين</option>
                    <?php foreach ($teachers as $t): ?>
                        <option value="<?php echo (int)$t['id']; ?>"
                            <?php echo ($filter_teacher_id == (int)$t['id'] ? 'selected' : ''); ?>>
                            <?php echo esc($t['name']); ?> — <?php echo esc($t['subject']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="filter-group">
                <label>من تاريخ</label>
                <input type="date" name="from" value="<?php echo esc($date_from); ?>">
            </div>
            <div class="filter-group">
                <label>إلى تاريخ</label>
                <input type="date" name="to" value="<?php echo esc($date_to); ?>">
            </div>
            <div class="filter-group" style="flex:0 0 auto;">
                <button type="submit" class="btn">عرض السجلات</button>
            </div>
        </div>
    </form>
</div>

<div class="stats">
    <div class="stat-box">
        <div class="stat-label">إجمالي عمليات تسجيل الدخول في الفترة</div>
        <div class="stat-value"><?php echo $total_logins; ?></div>
    </div>
    <div class="stat-box">
        <div class="stat-label">عدد المدرّسين الذين سجّلوا دخولاً</div>
        <div class="stat-value"><?php echo $total_teachers; ?></div>
    </div>
</div>

<div class="table-wrapper">
<?php if (empty($logs)): ?>
    <div style="text-align:center;padding:15px;">لا توجد سجلات دخول في المدى الزمني المحدد.</div>
<?php else: ?>
    <table>
        <thead>
        <tr>
            <th>ت</th>
            <th>اسم المدرّس</th>
            <th>المادة</th>
            <th>المراحل / الشعب</th>
            <th>تاريخ ووقت الدخول</th>
            <th>عنوان IP</th>
            <th>نوع الجهاز</th>
            <th>المتصفح (User-Agent)</th>
        </tr>
        </thead>
        <tbody>
        <?php
        $i = 1;
        foreach ($logs as $row):
            $dev_type  = device_type($row['user_agent']);

            // ✅ نعرض الوقت المخزَّن كما هو (بعد ما عالجناه عند الإدخال بتوقيت بغداد)
            $login_str = '';
            if (!empty($row['login_time'])) {
                $login_str = $row['login_time'];
            }

            $ua = $row['user_agent'];
            $browserName = detect_browser_name($ua);

            if (mb_strlen($ua) > 60) {
                $ua_display = mb_substr($ua, 0, 60) . '...';
            } else {
                $ua_display = $ua;
            }
        ?>
            <tr>
                <td><?php echo $i++; ?></td>
                <td class="name-cell"><?php echo esc($row['teacher_name']); ?></td>
                <td><?php echo esc($row['subject']); ?></td>
                <td class="info-cell">
                    <?php
                    $stages  = isset($row['stages'])  ? $row['stages']  : '';
                    $classes = isset($row['classes']) ? $row['classes'] : '';
                    if ($stages != '' || $classes != '') {
                        echo esc($stages);
                        if ($classes != '') {
                            echo ' — '.esc($classes);
                        }
                    }
                    ?>
                </td>
                <td><?php echo esc($login_str); ?></td>
                <td><?php echo esc($row['ip_address']); ?></td>
                <td><?php echo esc($dev_type); ?></td>
                <td class="info-cell">
                    <?php
                    echo esc($browserName);
                    if ($ua_display !== '') {
                        echo '<br><small>' . esc($ua_display) . '</small>';
                    }
                    ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>
</div>

</body>
</html>
