<?php
session_start();
include 'db.php';

// ✅ ترميز الاتصال
if (function_exists('mysqli_set_charset')) {
    mysqli_set_charset($conn, "utf8mb4");
}

// ✅ التحقق من تسجيل الدخول
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

// ✅ جلب بيانات المدرّس من الجلسة بأمان
$teacher_name    = isset($_SESSION['teacher_name']) ? $_SESSION['teacher_name'] : 'مدرّس';
$teacher_stages  = isset($_SESSION['teacher_stages']) ? $_SESSION['teacher_stages'] : '';
$teacher_classes = isset($_SESSION['teacher_classes']) ? $_SESSION['teacher_classes'] : '';

// ✅ تحليل المراحل والشعب بدقة
$stage_classes = array();

if ($teacher_classes != '') {
    // نقسم النص إلى أجزاء حسب الفواصل الرئيسية
    $parts = explode(',', $teacher_classes);
    $temp = '';
    foreach ($parts as $p) {
        $p = trim($p);
        // نعيد تجميع السطر إذا كان جزء تابع لما بعد النقطتين
        if (strpos($p, ':') !== false) {
            if ($temp !== '') {
                // نحفظ المؤقت السابق
                $pair = explode(':', $temp, 2);
                if (count($pair) == 2) {
                    $stage_classes[trim($pair[0])] = trim($pair[1]);
                }
            }
            $temp = $p;
        } else {
            $temp .= ',' . $p;
        }
    }
    // آخر عنصر
    if ($temp !== '') {
        $pair = explode(':', $temp, 2);
        if (count($pair) == 2) {
            $stage_classes[trim($pair[0])] = trim($pair[1]);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>🎓 لوحة تحكم المدرس | <?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
:root {
  --gradient-bg: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);
  --card-bg: rgba(255,255,255,0.3);
  --text-dark: #333;
  --glow: rgba(255,255,255,0.6);
}
body {
  font-family: 'Tajawal', sans-serif;
  background: var(--gradient-bg);
  min-height: 100vh;
  margin: 0;
  color: var(--text-dark);
  display: flex;
  align-items: center;
  justify-content: center;
  overflow-x: hidden;
}
.container {
  width: 90%;
  max-width: 950px;
  background: var(--card-bg);
  backdrop-filter: blur(20px);
  border-radius: 25px;
  box-shadow: 0 10px 50px rgba(0,0,0,0.1);
  padding: 50px;
  border: 1px solid var(--glow);
  text-align: center;
  animation: fadeIn 1s ease;
}
h2 {
  font-size: 32px;
  margin-bottom: 10px;
  background: linear-gradient(90deg, #0056b3, #00bcd4);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
}
p {
  color: #444;
  font-size: 17px;
  margin-bottom: 30px;
}
.stage-block {
  margin-bottom: 25px;
  padding: 25px;
  border-radius: 15px;
  background: rgba(255,255,255,0.6);
  border: 1px solid rgba(255,255,255,0.7);
  transition: all 0.3s ease;
}
.stage-block:hover {
  transform: translateY(-3px);
  background: rgba(255,255,255,0.85);
  box-shadow: 0 8px 25px rgba(0,123,255,0.15);
}
.stage-block strong {
  display: block;
  font-size: 20px;
  color: #ff7a00;
  margin-bottom: 10px;
}
a.class-link {
  display: inline-block;
  margin: 6px;
  padding: 12px 22px;
  border-radius: 10px;
  text-decoration: none;
  color: #fff;
  font-weight: 600;
  box-shadow: 0 4px 15px rgba(0,0,0,0.2);
  transition: all 0.3s ease;
}
a.class-link:hover {
  transform: translateY(-3px) scale(1.05);
  box-shadow: 0 6px 20px rgba(0,0,0,0.3);
}
.link-A { background: linear-gradient(90deg, #2196f3, #21cbf3); }
.link-B { background: linear-gradient(90deg, #4caf50, #81c784); }
.link-C { background: linear-gradient(90deg, #ff9800, #ffc107); }
.link-D { background: linear-gradient(90deg, #9c27b0, #ba68c8); }
.link-E { background: linear-gradient(90deg, #e91e63, #f06292); }
.link-F { background: linear-gradient(90deg, #009688, #4db6ac); }
.link-all { background: linear-gradient(90deg, #607d8b, #90a4ae); }

/* زر العودة للوحة الرئيسية */
.back-btn {
  display: inline-block;
  background: linear-gradient(90deg, #00c6ff, #0072ff);
  color: #fff;
  padding: 10px 22px;
  border-radius: 10px;
  text-decoration: none;
  font-weight: 600;
  margin-top: 10px;
  margin-bottom: 15px;
  transition: 0.3s;
}
.back-btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 20px rgba(0,114,255,0.3);
}

.logout-btn {
  display: inline-block;
  background: linear-gradient(90deg, #ff4b2b, #ff416c);
  color: #fff;
  padding: 14px 28px;
  border-radius: 12px;
  text-decoration: none;
  font-weight: bold;
  transition: all 0.3s ease;
  margin-top: 25px;
}
.logout-btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 8px 25px rgba(255,65,108,0.3);
}
@keyframes fadeIn {
  from { opacity: 0; transform: translateY(30px); }
  to { opacity: 1; transform: translateY(0); }
}
.empty-msg {
  background: rgba(255,255,255,0.7);
  border: 1px solid rgba(255,255,255,0.9);
  border-radius: 15px;
  padding: 20px;
  font-size: 15px;
  color: #333;
  margin-top: 10px;
}
</style>
</head>
<body>
<div class="container">
  <h2>👋 مرحباً أستاذ <?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?></h2>
  <p>المراحل والشعب التي تقوم بتدريسها:</p>

  <!-- زر العودة للوحة الرئيسية -->
  <a href="dashboard_teacher.php" class="back-btn">⬅️ العودة للوحة المدرّس</a>

  <?php if (!empty($stage_classes)): ?>
    <?php foreach ($stage_classes as $stage => $cls): ?>
      <div class="stage-block">
        <strong><?php echo htmlspecialchars($stage, ENT_QUOTES, 'UTF-8'); ?> :</strong>
        <?php
          $cls_clean = str_replace(['،', ' ,', ' , '], ',', $cls);
          if (strpos($cls_clean, 'جميع الشعب') !== false) {
              echo "<a class='class-link link-all' href='students.php?stage=" . urlencode($stage) . "&class=جميع الشعب'>جميع الشعب</a>";
          } else {
              $cls_array = preg_split('/\s*,\s*/', $cls_clean);
              foreach ($cls_array as $c) {
                  $c_trim = trim($c);
                  if ($c_trim != '') {
                      $colorClass = "link-" . strtoupper($c_trim);
                      echo "<a class='class-link $colorClass' href='students.php?stage=" . urlencode($stage) . "&class=" . urlencode($c_trim) . "'>شعبة " . htmlspecialchars($c_trim, ENT_QUOTES, 'UTF-8') . "</a> ";
                  }
              }
          }
        ?>
      </div>
    <?php endforeach; ?>
  <?php else: ?>
    <div class="empty-msg">
      ⚠️ لا توجد شعب مرتبطة بك حالياً. تأكد من الحقول <b>stages</b> و <b>classes</b> في جدول <b>teachers</b>.
    </div>
  <?php endif; ?>

  <a href="logout.php" class="logout-btn">🚪 تسجيل الخروج</a>
</div>
</body>
</html>
