<?php
session_start();
include 'db.php';

// ✅ التحقق من تسجيل دخول المدرّس
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");

// ✅ بيانات المدرّس من الجلسة
$teacher_id      = isset($_SESSION['teacher_id']) ? (int)$_SESSION['teacher_id'] : 0;
$teacher_name    = isset($_SESSION['teacher_name']) ? $_SESSION['teacher_name'] : 'مدرّس';
$teacher_subject = isset($_SESSION['teacher_subject']) ? $_SESSION['teacher_subject'] : '';

// ✅ نضبط التوقيت
date_default_timezone_set('Asia/Baghdad');

// =============== ⏱️ من هنا منطق الوقت ===============
// اليوم الحالي
$now     = time();
$today   = date('Y-m-d');

// ✅ يفتح 6 صباحاً
$open_ts  = strtotime($today . ' 06:00:00');
// ✅ يغلق 12 ظهراً
$close_ts = strtotime($today . ' 12:00:00');

// هل النظام مفتوح الآن؟
$is_homework_open = ($now >= $open_ts && $now < $close_ts);

// نحدد وقت العداد
if ($is_homework_open) {
    // عداد للإغلاق (يبين كم باقي للـ 12:00 ظهراً)
    $countdown_ts = $close_ts;
} else {
    // لو بعد 12:00 الظهر → يفتح باچر 6 الصبح
    if ($now >= $close_ts) {
        $tomorrow = date('Y-m-d', strtotime('+1 day'));
        $countdown_ts = strtotime($tomorrow . ' 06:00:00');
    } else {
        // لو قبل 6 الصبح → يفتح اليوم 6
        $countdown_ts = $open_ts;
    }
}

// نخليه بصيغة ISO عشان الجافاسكربت تقراه بسهولة (حتى لو حالياً ما نستخدم العداد)
$countdown_str = date('Y-m-d\TH:i:s', $countdown_ts);

// ==============================
// 🔎 تجهيز معلومات المدرّس للمطابقة (stages/classes)
// ==============================
$teacher_stages  = '';
$teacher_classes = '';
$qT = mysqli_query($conn, "SELECT name, subject, stages, classes FROM teachers WHERE id='".$teacher_id."' LIMIT 1");
if ($qT && mysqli_num_rows($qT) > 0) {
    $rowT = mysqli_fetch_assoc($qT);
    if ($teacher_name == 'مدرّس' && isset($rowT['name']) && $rowT['name'] != '') {
        $teacher_name = $rowT['name'];
        $_SESSION['teacher_name'] = $teacher_name;
    }
    if ($teacher_subject == '' && isset($rowT['subject']) && $rowT['subject'] != '') {
        $teacher_subject = $rowT['subject'];
        $_SESSION['teacher_subject'] = $teacher_subject;
    }
    $teacher_stages  = isset($rowT['stages'])  ? $rowT['stages']  : '';
    $teacher_classes = isset($rowT['classes']) ? $rowT['classes'] : '';
}

// ==============================
// 🧠 نفس دوال المطابقة المستخدمة بصفحة التبليغات
// ==============================
function norm_stage($s) {
    $s = trim($s);
    $s = str_replace(array('الأ','ال',' '), array('ا','', ''), $s);
    return $s;
}
function teacher_has_stage($teacher_stages, $target_stage) {
    if ($target_stage == '' || $teacher_stages == '') return false;
    $target = norm_stage($target_stage);
    $parts = preg_split('/[,،\/\-]+/u', $teacher_stages);
    if (!$parts || count($parts) == 0) $parts = array($teacher_stages);
    foreach ($parts as $p) {
        $p = trim($p);
        if ($p === '') continue;
        if (norm_stage($p) === $target) return true;
    }
    if (strpos($teacher_stages, $target_stage) !== false) return true;
    return false;
}
function teacher_has_any_class($teacher_classes, $target_classes) {
    if ($target_classes == '' || $teacher_classes == '') return true;
    $list = explode(',', $target_classes);
    foreach ($list as $c) {
        $c = trim($c);
        if ($c === '') continue;
        if (strpos($teacher_classes, $c) !== false) return true;
    }
    return false;
}
function notification_matches_teacher($row, $teacher_id, $teacher_subject, $teacher_stages, $teacher_classes) {
    $target_type    = isset($row['target_type']) ? $row['target_type'] : 'all';
    $target_stage   = isset($row['target_stage']) ? $row['target_stage'] : '';
    $target_subject = isset($row['target_subject']) ? $row['target_subject'] : '';
    $target_classes = isset($row['target_classes']) ? $row['target_classes'] : '';
    $target_ids_str = isset($row['target_teacher_ids']) ? $row['target_teacher_ids'] : '';

    switch ($target_type) {
        case 'all': default: return true;
        case 'subject':
            if ($target_subject == '' || $teacher_subject == '') return false;
            return trim($target_subject) === trim($teacher_subject);
        case 'stage':
            return teacher_has_stage($teacher_stages, $target_stage);
        case 'stage_class':
            if (!teacher_has_stage($teacher_stages, $target_stage)) return false;
            return teacher_has_any_class($teacher_classes, $target_classes);
        case 'teachers':
            if ($target_ids_str == '') return false;
            foreach (explode(',', $target_ids_str) as $id) {
                if ((int)trim($id) === (int)$teacher_id) return true;
            }
            return false;
    }
}

// ==============================
// 🔔 احتساب عدد التبليغات غير المقروءة لعرضها على الكارت
// ==============================
$unread_count = 0;

// نجيب كل التبليغات الفعّالة والمجدولة ضمن الوقت الحالي
$now_db = mysqli_real_escape_string($conn, date('Y-m-d H:i:s'));
$sql_notifs = "
SELECT n.*
FROM admin_notifications n
WHERE 
  (n.valid_until IS NULL OR n.valid_until = '0000-00-00' OR n.valid_until >= CURDATE())
  AND (
       n.is_scheduled = 0
       OR (n.is_scheduled = 1 AND n.scheduled_at IS NOT NULL AND n.scheduled_at <= '".$now_db."')
  )
ORDER BY n.created_at DESC
";
$notif_rows = array();
$qN = mysqli_query($conn, $sql_notifs);
if ($qN) {
    while ($r = mysqli_fetch_assoc($qN)) {
        if (notification_matches_teacher($r, $teacher_id, $teacher_subject, $teacher_stages, $teacher_classes)) {
            $notif_rows[] = $r;
        }
    }
}

// لو ماكو تبليغات، يبقى العداد صفر
if (count($notif_rows) > 0) {
    // نجهّز IDs للاستعلام دفعة وحدة عن حالات القراءة
    $ids = array();
    foreach ($notif_rows as $r) { $ids[] = (int)$r['id']; }
    $ids = array_unique($ids);

    $reads = array();
    $in = implode(',', $ids);
    $qr = mysqli_query($conn, "SELECT notification_id, is_read, is_confirmed FROM admin_notification_reads WHERE teacher_id=".$teacher_id." AND notification_id IN (".$in.")");
    if ($qr) {
        while ($rr = mysqli_fetch_assoc($qr)) {
            $nid = (int)$rr['notification_id'];
            $reads[$nid] = array(
                'is_read'      => isset($rr['is_read']) ? (int)$rr['is_read'] : 0,
                'is_confirmed' => isset($rr['is_confirmed']) ? (int)$rr['is_confirmed'] : 0
            );
        }
    }

    // غير مقروء = لا يوجد سجل قراءة، أو is_read = 0
    foreach ($notif_rows as $r) {
        $nid = (int)$r['id'];
        if (!isset($reads[$nid]) || (int)$reads[$nid]['is_read'] === 0) {
            $unread_count++;
        }
        // ⚠️ إن أردت احتساب "بانتظار التأكيد" ضمن العداد أيضاً:
        // if ((int)$r['require_confirm'] === 1 && (!isset($reads[$nid]) || (int)$reads[$nid]['is_confirmed'] === 0)) { $unread_count++; }
        // (لكن يفضّل حينها فصل عدّاد خاص للأمور التي تنتظر التأكيد)
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📘 لوحة تحكم المدرّس</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  flex-direction:column;
  overflow-x:hidden;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.2),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.2),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.15),transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{0%{transform:rotate(0deg) scale(1)}100%{transform:rotate(360deg) scale(1.2)}}

header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:18px 25px;
  background:rgba(255,255,255,0.07);
  border-bottom:1px solid rgba(255,255,255,0.12);
  backdrop-filter:blur(10px);
  box-shadow:0 2px 12px rgba(0,255,255,0.1);
  position:sticky;
  top:0;
  z-index:10;
}
header .left{display:flex;align-items:center;gap:12px}
header img{height:45px;border-radius:50%;box-shadow:0 0 10px rgba(0,255,255,0.3)}
header h1{font-size:20px;font-weight:600;color:#fff;margin:0}
header .user{font-size:14px;color:#0ff;opacity:0.85}
header .btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;padding:9px 18px;border-radius:10px;
  text-decoration:none;font-weight:bold;transition:0.3s;
}
header .btn:hover{transform:scale(1.05);box-shadow:0 0 15px rgba(0,255,255,0.4)}

.intro{
  text-align:center;
  margin:40px auto 20px;
  padding:15px 10px;
  max-width:900px;
  position:relative;
  z-index:2;
  opacity:0;
  animation:fadeIn 1.2s ease-in-out forwards;
}
.intro h2{
  font-size:26px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.4);
  margin-bottom:10px;
}
.intro p{
  color:#ddd;
  font-size:16px;
  line-height:1.7;
}
.intro .sub{
  color:#aaa;
  font-size:14px;
  margin-top:8px;
}
@keyframes fadeIn{
  from{opacity:0;transform:translateY(20px)}
  to{opacity:1;transform:translateY(0)}
}

main{
  flex:1;
  width:100%;
  max-width:1200px;
  margin:20px auto 50px;
  padding:0 20px;
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(260px,1fr));
  gap:25px;
  animation:fadeIn 1.4s ease-in-out forwards;
}

.card-link{ text-decoration:none; color:inherit; }
.card{
  background:rgba(255,255,255,0.08);
  border-radius:22px;
  padding:25px 20px;
  text-align:center;
  border:1px solid rgba(255,255,255,0.12);
  box-shadow:0 0 20px rgba(0,255,255,0.08);
  transition:0.4s;
  position:relative;
  overflow:hidden;
  cursor:pointer;
}
.card::before{
  content:"";
  position:absolute;
  top:-100%;left:0;width:100%;height:100%;
  background:linear-gradient(180deg,rgba(255,255,255,0.2),transparent);
  transition:0.6s;
}
.card:hover::before{top:0}
.card:hover{
  transform:translateY(-6px);
  box-shadow:0 0 30px rgba(0,255,255,0.3);
  background:rgba(255,255,255,0.12);
}
.icon{
  font-size:40px;
  margin-bottom:14px;
  color:#00e6ff;
  text-shadow:0 0 15px rgba(0,255,255,0.7);
}
.card h3{font-size:18px;margin-bottom:10px}
.card p{color:#ccc;font-size:14px;margin-bottom:5px;min-height:40px}

.card.disabled{
  background:rgba(255,255,255,0.03);
  border:1px dashed rgba(255,255,255,0.15);
  cursor:not-allowed;
}
.card.disabled:hover{
  transform:none;
  box-shadow:none;
  background:rgba(255,255,255,0.04);
}

/* ✅ شارة الوقت */
.timer-badge{
  position:absolute;
  top:12px;
  right:12px;
  background:rgba(0,0,0,0.35);
  border:1px solid rgba(0,230,255,0.4);
  padding:4px 10px;
  border-radius:999px;
  font-size:11px;
  color:#fff;
}
.timer-badge.off{
  background:rgba(255,0,74,0.35);
  border:1px solid rgba(255,0,74,0.6);
}

/* ✅ شارة عدد التبليغات غير المقروءة */
.card-notifs{ position:relative; }
.notif-badge{
  position:absolute;
  top:12px;
  left:12px; /* تقدر تبدلها إلى right حسب رغبتك */
  min-width:26px;
  height:26px;
  padding:0 7px;
  display:flex;
  align-items:center;
  justify-content:center;
  border-radius:999px;
  font-size:13px;
  font-weight:700;
  color:#fff;
  background:linear-gradient(135deg,#ef4444,#f97316);
  box-shadow:0 8px 20px rgba(249,115,22,0.45), inset 0 0 8px rgba(255,255,255,0.25);
  animation:pulse 1.8s infinite;
  border:1px solid rgba(255,255,255,0.25);
}
@keyframes pulse{
  0%{transform:scale(1); box-shadow:0 0 0 0 rgba(249,115,22,0.55)}
  70%{transform:scale(1.06); box-shadow:0 0 0 12px rgba(249,115,22,0)}
  100%{transform:scale(1); box-shadow:0 0 0 0 rgba(249,115,22,0)}
}

footer{
  text-align:center;
  padding:15px;
  font-size:13px;
  color:#aaa;
  background:rgba(255,255,255,0.04);
  backdrop-filter:blur(8px);
  border-top:1px solid rgba(255,255,255,0.08);
}
footer span{color:#00e6ff}

@media (max-width:600px){
  header{flex-direction:column;gap:8px;text-align:center}
  header .left{flex-direction:column;gap:6px}
  main{margin:20px auto;padding:0 15px;gap:20px}
}
</style>
</head>
<body>

<header>
  <div class="left">
    <img src="logo.png" alt="logo">
    <div>
      <h1>لوحة تحكم المدرّس</h1>
      <div class="user">مرحباً، <?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?><?php
        if ($teacher_subject != '') {
            echo " — " . htmlspecialchars($teacher_subject, ENT_QUOTES, 'UTF-8');
        }
      ?></div>
    </div>
  </div>
  <a href="logout.php" class="btn">تسجيل خروج</a>
</header>

<section class="intro">
  <h2>👨‍🏫 لوحة المدرّس</h2>
  <p>من هنا تدخل لكل أنظمة المدرسة المرتبطة باسمك.</p>
  <p class="sub">اختر النظام المطلوب 👇</p>
</section>

<main>

  <!-- 1) نظام درجات الطلبة -->
  <a href="dashboard.php" class="card-link">
    <div class="card">
      <div class="icon">📚</div>
      <h3>نظام درجات الطلبة</h3>
      <p>إدخال ومراجعة الدرجات حسب المادة والمرحلة.</p>
    </div>
  </a>

  <!-- ✅ 2) كارت التبليغات الإدارية (Badge لغير المقروء) -->
  <a href="teacher_notifications.php" class="card-link">
    <div class="card card-notifs">
      <?php if ((int)$unread_count > 0): ?>
        <div class="notif-badge" title="تبليغات غير مقروءة"><?php echo (int)$unread_count; ?></div>
      <?php endif; ?>
      <div class="icon">📢</div>
      <h3>التبليغات الإدارية</h3>
      <p>استلام تبليغات الإدارة العامة والموجّهة لك.</p>
    </div>
  </a>

  <!-- ✅ 3) إرسال الواجبات — يعمل من 6 صباحاً إلى 12 ظهراً -->
  <?php if ($is_homework_open): ?>
    <!-- النظام مفتوح: الكارت قابل للنقر -->
    <a href="homework.php" class="card-link">
      <div class="card">
        <div class="timer-badge">مفتوح حتى 12:00 ظهراً</div>
        <div class="icon">📝</div>
        <h3>إرسال الواجبات</h3>
        <p>النظام مفتوح الآن لإرسال الواجبات اليومية.</p>
      </div>
    </a>
  <?php else: ?>
    <!-- النظام مغلق: الكارت معطّل -->
    <div class="card disabled">
      <div class="timer-badge off">
        <?php if ($now < $open_ts): ?>
          يفتح اليوم الساعة 6:00 صباحاً
        <?php else: ?>
          أُغلق اليوم — يفتح غداً الساعة 6:00 صباحاً
        <?php endif; ?>
      </div>
      <div class="icon">📝</div>
      <h3>إرسال الواجبات</h3>
      <p>متاح يومياً من 6:00 صباحاً حتى 12:00 ظهراً.</p>
    </div>
  <?php endif; ?>

  <!-- ✅ كارت رفع الأسئلة -->
  <a href="upload_questions.php" class="card-link">
    <div class="card">
      <div class="icon">📤</div>
      <h3>رفع الأسئلة</h3>
      <p>رفع PDF أو Word أو صورة لأسئلة الأشهر والفصول.</p>
    </div>
  </a>

  <!-- ✅ كارت المادة الداخلة بالامتحان -->
  <a href="exam_topics.php" class="card-link">
    <div class="card">
      <div class="icon">📄</div>
      <h3>المادة الداخلة بالامتحان</h3>
      <p>إرسال المادة الداخلة بالامتحان.</p>
    </div>
  </a>

  <!-- 5) المكتبة المدرسية -->
  <a href="https://mosul.pw/alawael/" class="card-link" target="_blank" rel="noopener">
    <div class="card">
      <div class="icon">📖</div>
      <h3>المكتبة المدرسية</h3>
      <p>كتب ومصادر للمدرّس والطالب.</p>
    </div>
  </a>

</main>

<footer>
  © <span><?php echo date("Y"); ?></span> جميع الحقوق محفوظة — <b>ثانوية الأوائل الأهلية للبنين</b>
</footer>

</body>
</html>  