<?php
session_start();
include 'db.php';

// ✅ التحقق من تسجيل دخول المدرّس
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

$teacher_id    = $_SESSION['teacher_id'];
$teacher_name  = isset($_SESSION['teacher_name']) ? $_SESSION['teacher_name'] : 'مدرّس';
$teacher_subj  = isset($_SESSION['teacher_subject']) ? $_SESSION['teacher_subject'] : '';

// ✅ نحاول نجيب المراحل اللي يدرّسها المدرّس من جدول teachers
$stages_arr  = array();
$teacher_sql = mysqli_query($conn, "SELECT stages FROM teachers WHERE id=".(int)$teacher_id." LIMIT 1");
if ($teacher_sql && mysqli_num_rows($teacher_sql) > 0) {
    $trow = mysqli_fetch_assoc($teacher_sql);

    if (isset($trow['stages']) && $trow['stages'] != '') {
        $parts = explode(',', $trow['stages']);
        foreach ($parts as $p) {
            $p = trim($p);
            if ($p != '') $stages_arr[] = $p;
        }
    }
}

// لو ما لقينا مراحل للمدرس، نجيب من جدول الطلبة
if (count($stages_arr) == 0) {
    $qst = mysqli_query($conn, "SELECT DISTINCT stage FROM students ORDER BY stage ASC");
    if ($qst) {
        while ($r = mysqli_fetch_assoc($qst)) {
            $stages_arr[] = $r['stage'];
        }
    }
}

date_default_timezone_set('Asia/Baghdad');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📄 إرسال المادة الداخلة بالامتحان</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  justify-content:center;
  align-items:flex-start;
  padding:30px 10px 40px;
}
.container{
  width:100%;
  max-width:900px;
  background:rgba(255,255,255,0.04);
  border:1px solid rgba(255,255,255,0.1);
  border-radius:18px;
  padding:22px 18px 28px;
  backdrop-filter:blur(5px);
  box-shadow:0 0 25px rgba(0,0,0,0.35);
  position:relative;
}
.back-btn{
  position:absolute;
  top:18px;
  left:18px;
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;
  text-decoration:none;
  padding:6px 14px;
  border-radius:999px;
  font-size:13px;
  font-weight:600;
  transition:0.3s;
}
.back-btn:hover{
  transform:translateY(-2px);
  box-shadow:0 4px 12px rgba(0,230,255,0.25);
}
h1{
  font-size:22px;
  margin-bottom:5px;
  color:#00e6ff;
}
.desc{
  color:#ccc;
  margin-bottom:18px;
  font-size:14px;
}
.badge{
  background:rgba(0,230,255,0.12);
  border:1px solid rgba(0,230,255,0.4);
  padding:3px 10px;
  border-radius:999px;
  font-size:12px;
  display:inline-block;
  margin-bottom:10px;
}
.form-group{margin-bottom:14px;}
label{display:block;margin-bottom:5px;font-weight:600;}
select,textarea,input[type="text"]{
  width:100%;
  padding:9px 10px;
  border-radius:12px;
  border:1px solid rgba(255,255,255,0.15);
  background:rgba(0,0,0,0.35);
  color:#fff;
  font-family:'Tajawal',sans-serif;
}
textarea{min-height:120px;resize:vertical;}
.row{display:flex;gap:12px;flex-wrap:wrap;}
.col{flex:1 1 230px;}
.btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  border:none;
  padding:10px 20px;
  border-radius:12px;
  color:#fff;
  font-weight:700;
  cursor:pointer;
  transition:0.3s;
  margin-top:10px;
}
.btn:hover{transform:translateY(-2px);box-shadow:0 5px 15px rgba(0,230,255,0.2);}
small{color:#aaa;}
#month_wrapper{display:none;}
@media (max-width:600px){
  .back-btn{position:static;display:inline-block;margin-bottom:12px;}
}
</style>
</head>
<body>

<div class="container">
  <a href="dashboard_teacher.php" class="back-btn">⬅ العودة للوحة المدرّس</a>

  <div class="badge">
    المدرّس: <?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?>
    <?php if ($teacher_subj != '') echo " — " . htmlspecialchars($teacher_subj, ENT_QUOTES, 'UTF-8'); ?>
  </div>
  <h1>📄 إرسال المادة الداخلة بالامتحان</h1>
  <p class="desc">اختر المرحلة ونوع الامتحان، ثم اكتب المواضيع الداخلة. (لا حاجة لاختيار شعبة)</p>

  <form action="save_exam_topics.php" method="post">
    <input type="hidden" name="teacher_id" value="<?php echo (int)$teacher_id; ?>">
    <input type="hidden" name="teacher_name" value="<?php echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="teacher_subject" value="<?php echo htmlspecialchars($teacher_subj, ENT_QUOTES, 'UTF-8'); ?>">
    <input type="hidden" name="class" value="جميع الشعب">

    <div class="row">
      <div class="col">
        <div class="form-group">
          <label for="stage">المرحلة / الصف</label>
          <select name="stage" id="stage" required>
            <option value="">اختر المرحلة</option>
            <?php
            if (count($stages_arr) > 0) {
                foreach ($stages_arr as $st) {
                    echo '<option value="'.htmlspecialchars($st, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($st, ENT_QUOTES, 'UTF-8').'</option>';
                }
            }
            ?>
          </select>
        </div>
      </div>

      <div class="col">
        <div class="form-group">
          <label for="exam_type">نوع الامتحان</label>
          <select name="exam_type" id="exam_type" required>
            <option value="">اختر نوع الامتحان</option>
            <option value="الفصل الأول">الفصل الأول</option>
            <option value="نصف السنة">نصف السنة</option>
            <option value="الفصل الثاني">الفصل الثاني</option>
            <option value="نهاية السنة">نهاية السنة</option>
          </select>
        </div>
      </div>

      <div class="col" id="month_wrapper">
        <div class="form-group">
          <label for="exam_month">الشهر</label>
          <select name="exam_month" id="exam_month">
            <option value="">اختر الشهر</option>
            <option value="الشهر الأول">الشهر الأول</option>
            <option value="الشهر الثاني">الشهر الثاني</option>
            <option value="الشهر الثالث">الشهر الثالث</option>
          </select>
        </div>
      </div>
    </div>

    <div class="form-group">
      <label for="topics">المادة الداخلة / المواضيع</label>
      <textarea name="topics" id="topics" placeholder="مثال: الوحدة الثالثة + القطعة (My Family) + القواعد من صفحة 33 إلى 37" required></textarea>
    </div>

    <button type="submit" class="btn">📤 إرسال</button>
  </form>
</div>

<script>
// إظهار اختيار الشهر فقط للفصل الأول والثاني
var examTypeSelect = document.getElementById('exam_type');
var monthWrapper   = document.getElementById('month_wrapper');
var examMonth      = document.getElementById('exam_month');

examTypeSelect.addEventListener('change', function(){
  var v = this.value;
  if (v === 'الفصل الأول' || v === 'الفصل الثاني') {
    monthWrapper.style.display = 'block';
  } else {
    monthWrapper.style.display = 'none';
    examMonth.value = '';
  }
});
</script>

</body>
</html>
