<?php
session_start();
include 'db.php';

if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");

$teacher_id = (int)$_SESSION['teacher_id'];

/* ==============================
   جلب بيانات المدرّس
   ============================== */
$teacher_q = mysqli_query(
    $conn,
    "SELECT name, subject, stages, classes FROM teachers WHERE id='".$teacher_id."' LIMIT 1"
);
if (!$teacher_q || mysqli_num_rows($teacher_q) == 0) {
    die("<div style='margin:50px auto;text-align:center;font-family:Cairo;color:red;'>❌ لا يمكن جلب بياناتك من جدول المدرسين. تأكد أن الإدارة أدخلتك في (إدارة المدرسين).</div>");
}

$teacher_row     = mysqli_fetch_assoc($teacher_q);
$teacher_name    = isset($teacher_row['name'])    ? $teacher_row['name']    : 'مدرّس';
$teacher_subject = isset($teacher_row['subject']) ? $teacher_row['subject'] : 'غير محدد';
$stages_raw      = isset($teacher_row['stages'])  ? $teacher_row['stages']  : '';
$classes_raw     = isset($teacher_row['classes']) ? $teacher_row['classes'] : '';

/* ==============================
   مراحل المدرّس
   ============================== */
$teacher_stages_arr = explode(',', $stages_raw);
$teacher_stages = array();
foreach ($teacher_stages_arr as $stg) {
    $stg = trim($stg);
    if ($stg !== '') {
        $teacher_stages[] = $stg;
    }
}

/* ==============================
   إنشاء الجدول لو مش موجود
   ============================== */
mysqli_query($conn, "
CREATE TABLE IF NOT EXISTS `question_files` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` INT(11) NOT NULL,
  `subject` VARCHAR(150) DEFAULT NULL,
  `stage` VARCHAR(100) NOT NULL,
  `class` VARCHAR(100) NOT NULL,
  `semester` VARCHAR(50) NOT NULL,
  `exam_type` VARCHAR(50) DEFAULT '',
  `file_name` VARCHAR(255) NOT NULL,
  `file_path` VARCHAR(255) NOT NULL,
  `uploaded_at` DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX (`teacher_id`),
  INDEX (`stage`),
  INDEX (`class`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

/* ===========
   تأكد من وجود العمود exam_model، لو ما موجود أضِفه
   =========== */
$col_check = mysqli_query($conn, "SHOW COLUMNS FROM `question_files` LIKE 'exam_model'");
if ($col_check && mysqli_num_rows($col_check) == 0) {
    // نضيفه بعد exam_type
    mysqli_query($conn, "ALTER TABLE `question_files` ADD COLUMN `exam_model` VARCHAR(50) DEFAULT '' AFTER `exam_type`");
}

$msg = '';

/* ==============================
   معالجة الرفع
   ============================== */
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $stage      = isset($_POST['stage']) ? trim($_POST['stage']) : '';
    $class      = 'جميع الشعب'; // حسب طلبك
    $semester   = isset($_POST['semester']) ? trim($_POST['semester']) : '';
    $exam_type  = isset($_POST['exam_type']) ? trim($_POST['exam_type']) : '';
    $exam_model = isset($_POST['exam_model']) ? trim($_POST['exam_model']) : '';

    // الفصول اللي ما تحتاج شهر/يومي
    $no_month_needed = in_array($semester, array('نصف السنة','آخر السنة','اخير السنة'), true);

    if ($stage == '' || !in_array($stage, $teacher_stages, true)) {
        $msg = "<div class='alert alert-danger'>❌ المرحلة المختارة غير مرتبطة بك.</div>";
    } elseif ($semester == '') {
        $msg = "<div class='alert alert-danger'>❌ الرجاء اختيار الفصل.</div>";
    } elseif (!$no_month_needed && $exam_type == '') {
        $msg = "<div class='alert alert-danger'>❌ الرجاء اختيار الشهر / اليومي.</div>";
    } elseif ($exam_model == '') {
        $msg = "<div class='alert alert-danger'>❌ الرجاء اختيار نموذج الأسئلة.</div>";
    } elseif (!isset($_FILES['question_file']) || $_FILES['question_file']['error'] !== UPLOAD_ERR_OK) {
        $msg = "<div class='alert alert-danger'>❌ الرجاء اختيار ملف للأسئلة.</div>";
    } else {

        $allowed_ext = array('pdf','doc','docx','jpg','jpeg','png');
        $orig_name   = $_FILES['question_file']['name'];
        $tmp_name    = $_FILES['question_file']['tmp_name'];
        $ext         = strtolower(pathinfo($orig_name, PATHINFO_EXTENSION));

        if (!in_array($ext, $allowed_ext)) {
            $msg = "<div class='alert alert-danger'>❌ صيغة الملف غير مسموحة. المسموح: PDF, DOC, DOCX, JPG, PNG.</div>";
        } else {
            $upload_dir = __DIR__ . '/uploads/questions';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }

            $new_name  = 'q_'.$teacher_id.'_'.time().'_'.rand(1000,9999).'.'.$ext;
            $full_path = $upload_dir . '/' . $new_name;

            if (move_uploaded_file($tmp_name, $full_path)) {

                $relative_path = 'uploads/questions/' . $new_name;

                $stage_esc     = mysqli_real_escape_string($conn, $stage);
                $class_esc     = mysqli_real_escape_string($conn, $class);
                $semester_esc  = mysqli_real_escape_string($conn, $semester);
                $exam_type_save = $no_month_needed ? '' : $exam_type;
                $exam_type_esc  = mysqli_real_escape_string($conn, $exam_type_save);
                $exam_model_esc = mysqli_real_escape_string($conn, $exam_model);
                $subject_esc    = mysqli_real_escape_string($conn, $teacher_subject);
                $file_name_esc  = mysqli_real_escape_string($conn, $orig_name);
                $file_path_esc  = mysqli_real_escape_string($conn, $relative_path);

                // ندخل
                $ins_sql = "
                    INSERT INTO question_files
                    (teacher_id, subject, stage, class, semester, exam_type, exam_model, file_name, file_path, uploaded_at)
                    VALUES
                    ('".$teacher_id."', '".$subject_esc."', '".$stage_esc."', '".$class_esc."', '".$semester_esc."', '".$exam_type_esc."', '".$exam_model_esc."', '".$file_name_esc."', '".$file_path_esc."', NOW())
                ";

                if (mysqli_query($conn, $ins_sql)) {
                    $msg = "<div class='alert alert-success'>✅ تم رفع الأسئلة وحفظها بنجاح.</div>";
                } else {
                    // لو صار خطأ ثاني نعرضه
                    $msg = "<div class='alert alert-danger'>❌ خطأ في حفظ السجل داخل قاعدة البيانات: ".htmlspecialchars(mysqli_error($conn), ENT_QUOTES, 'UTF-8')."</div>";
                }

            } else {
                $msg = "<div class='alert alert-danger'>❌ حدث خطأ أثناء رفع الملف.</div>";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>رفع أسئلة الامتحانات | ثانوية الأوائل</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
  display:flex;
  flex-direction:column;
  overflow-x:hidden;
}
body::before{
  content:"";
  position:fixed;
  top:-50%;
  left:-50%;
  width:200%;
  height:200%;
  background:
    radial-gradient(circle at 30% 30%,rgba(0,255,255,0.18),transparent 70%),
    radial-gradient(circle at 70% 70%,rgba(255,215,0,0.18),transparent 80%),
    radial-gradient(circle at 50% 100%,rgba(138,43,226,0.10),transparent 60%);
  animation:nebula 25s linear infinite alternate;
  filter:blur(90px);
  z-index:-1;
}
@keyframes nebula{0%{transform:rotate(0deg) scale(1)}100%{transform:rotate(360deg) scale(1.2)}}
header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:16px 20px;
  background:rgba(255,255,255,0.05);
  border-bottom:1px solid rgba(255,255,255,0.1);
  backdrop-filter:blur(12px);
}
header .left{
  display:flex;
  gap:12px;
  align-items:center;
}
header img{
  height:45px;
  border-radius:12px;
  box-shadow:0 0 10px rgba(0,255,255,0.4);
}
header h1{
  font-size:18px;
  margin:0;
}
header .subtitle{
  font-size:12px;
  color:#00e6ff;
}
header .btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;
  text-decoration:none;
  padding:7px 16px;
  border-radius:10px;
  font-weight:600;
  transition:0.3s;
  white-space:nowrap;
}
header .btn:hover{
  transform:scale(1.03);
}
.main-wrap{
  width:100%;
  max-width:950px;
  margin:25px auto 45px;
  padding:0 16px;
}
.top-card{
  background:rgba(255,255,255,0.04);
  border:1px solid rgba(255,255,255,0.05);
  border-radius:16px;
  padding:15px 16px;
  margin-bottom:18px;
  box-shadow:0 10px 25px rgba(0,0,0,0.12);
}
.top-card h2{
  font-size:20px;
  margin-bottom:4px;
  color:#00e6ff;
}
.top-card p{
  font-size:13px;
  color:#ddd;
}
.alert{
  margin-bottom:15px;
  padding:10px 12px;
  border-radius:12px;
  font-size:13px;
  line-height:1.5;
}
.alert-success{background:rgba(0,255,135,0.08);border:1px solid rgba(0,255,135,0.4);}
.alert-danger{background:rgba(255,0,74,0.1);border:1px solid rgba(255,0,74,0.45);}

.form-card{
  background:rgba(255,255,255,0.03);
  border:1px solid rgba(255,255,255,0.03);
  border-radius:16px;
  padding:18px 16px 16px;
  box-shadow:0 0 12px rgba(0,0,0,0.18);
}
.form-group{margin-bottom:14px;}
label{display:block;font-weight:600;margin-bottom:5px;font-size:13px;}
select,
input[type=file]{
  width:100%;
  background:rgba(0,0,0,0.25);
  border:1px solid rgba(255,255,255,0.08);
  border-radius:10px;
  padding:7px 8px;
  color:#fff;
  font-family:'Tajawal',sans-serif;
  font-size:13px;
}
input[type=file]{
  background:rgba(0,0,0,0.05);
  border-style:dashed;
  cursor:pointer;
}
.note-line{font-size:11px;color:#ffdca1;margin-bottom:8px;}
.btn-submit{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  border:none;
  border-radius:12px;
  padding:10px 28px;
  color:#fff;
  font-weight:700;
  cursor:pointer;
  transition:0.3s;
}
.btn-submit:hover{
  transform:translateY(-1px);
  box-shadow:0 0 20px rgba(0,255,255,0.25);
}
.footer{
  text-align:center;
  font-size:12px;
  color:#aaa;
  padding:14px 10px 25px;
  background:rgba(255,255,255,0.01);
}
@media (max-width:600px){
  header{flex-wrap:wrap;gap:10px}
  .main-wrap{padding:0 10px;}
  select,input[type=file]{font-size:12px;}
  .btn-submit{width:100%;text-align:center}
}
</style>
</head>
<body>

<header>
  <div class="left">
    <img src="logo.png" alt="logo">
    <div>
      <h1>رفع أسئلة الامتحانات</h1>
      <div class="subtitle">
        <?php
          echo htmlspecialchars($teacher_name, ENT_QUOTES, 'UTF-8');
          if ($teacher_subject != '' && $teacher_subject != 'غير محدد') {
              echo " — " . htmlspecialchars($teacher_subject, ENT_QUOTES, 'UTF-8');
          }
        ?>
      </div>
    </div>
  </div>
  <a href="dashboard_teacher.php" class="btn">↩ العودة للوحة</a>
</header>

<div class="main-wrap">
  <div class="top-card">
    <h2>رفع الأسئلة حسب المرحلة</h2>
    <p>اختر المرحلة التي أنت مكلّف بها فقط، ثم اختر الفصل. إذا كان الفصل (نصف السنة) أو (آخر السنة) فلن تحتاج لاختيار الشهر/اليومي.</p>
  </div>

  <?php
    if ($msg != '') echo $msg;
  ?>

  <div class="form-card">
    <form method="post" enctype="multipart/form-data">
      <div class="form-group">
        <label for="stage">المرحلة</label>
        <select name="stage" id="stage" required>
          <option value="">-- اختر المرحلة --</option>
          <?php
          if (!empty($teacher_stages)) {
              foreach ($teacher_stages as $stg) {
                  echo '<option value="'.htmlspecialchars($stg, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($stg, ENT_QUOTES, 'UTF-8').'</option>';
              }
          }
          ?>
        </select>
      </div>

      <div class="form-group">
        <label for="semester">الفصل</label>
        <select name="semester" id="semester" required>
          <option value="">-- اختر الفصل --</option>
          <option value="ف1">الفصل الأول (ف1)</option>
          <option value="ف2">الفصل الثاني (ف2)</option>
          <option value="نصف السنة">نصف السنة</option>
          <option value="آخر السنة">آخر السنة</option>
        </select>
      </div>

      <div class="form-group" id="exam_type_block">
        <label for="exam_type">الشهر / اليومي</label>
        <select name="exam_type" id="exam_type">
          <option value="">-- اختر نوع الأسئلة --</option>
          <option value="ش1">الشهر الأول (ش1)</option>
          <option value="ش2">الشهر الثاني (ش2)</option>
          <option value="ش3">الشهر الثالث (ش3)</option>
          <option value="اليومي">اليومي</option>
        </select>
      </div>

      <div class="form-group">
        <label for="exam_model">نموذج الأسئلة</label>
        <select name="exam_model" id="exam_model" required>
          <option value="">-- اختر نموذج الأسئلة --</option>
          <option value="A">نموذج A</option>
          <option value="B">نموذج B</option>
          <option value="مؤجلين">مؤجلين</option>
        </select>
      </div>

      <div class="form-group">
        <label for="question_file">ملف الاسئلة يجب ان يكون pdf</label>
        <input type="file" name="question_file" id="question_file" required>
        <div class="note-line">الصيغ المسموحة:pdf</div>
      </div>

      <button type="submit" class="btn-submit">📤 رفع الأسئلة</button>
    </form>
  </div>

  <div style="text-align:center;margin-top:18px;">
    <a href="view_questions.php" style="color:#00e6ff;text-decoration:none;font-size:13px;">📁 عرض الأسئلة المرفوعة</a>
  </div>
</div>

<div class="footer">
  © <?php echo date("Y"); ?> جميع الحقوق محفوظة — ثانوية الأوائل الأهلية للبنين
</div>

<script>
// إظهار/إخفاء الشهر/اليومي حسب الفصل
var semesterSelect = document.getElementById('semester');
var examTypeBlock  = document.getElementById('exam_type_block');
var examTypeSelect = document.getElementById('exam_type');

semesterSelect.onchange = function () {
    var v = this.value;
    if (v === 'نصف السنة' || v === 'آخر السنة' || v === 'اخير السنة') {
        examTypeBlock.style.display = 'none';
        examTypeSelect.value = '';
    } else {
        examTypeBlock.style.display = 'block';
    }
};
</script>

</body>
</html>
