<?php
// بدء الجلسة إذا لم تكن بدأت
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// تعريف الثوابت
if (!defined('SITEURL'))     define('SITEURL', 'https://mosul.pw/onlinefood-order/');
if (!defined('LOCALHOST'))   define('LOCALHOST', 'premium129');
if (!defined('DB_USERNAME')) define('DB_USERNAME', 'mosuclaz');
if (!defined('DB_PASSWORD')) define('DB_PASSWORD', 'CgQqC9g4msfD');
if (!defined('DB_NAME'))     define('DB_NAME', 'mosuclaz_onlinefoodorder');

// الاتصال بقاعدة البيانات
$conn = mysqli_connect(LOCALHOST, DB_USERNAME, DB_PASSWORD, DB_NAME);
if (!$conn) {
    die("فشل الاتصال بقاعدة البيانات: " . mysqli_connect_error());
}
mysqli_set_charset($conn, "utf8mb4");

// تفعيل عرض الأخطاء أثناء التطوير فقط (يمكن حذفها بعد التجربة)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// تنفيذ التصفير عند الطلب
if (isset($_POST['reset_all']) && isset($_POST['reset_password'])) {
    $reset_password = trim($_POST['reset_password']);
    if ($reset_password === '000') {
        // تصفير الطلبات والمصروفات
        mysqli_query($conn, "TRUNCATE TABLE tbl_order");
        mysqli_query($conn, "TRUNCATE TABLE tbl_expenses");
        echo "<div style='color:red; font-weight:bold;'>تم تصفير جميع الحسابات والطلبات والمصروفات بنجاح!</div>";
        // إعادة تحميل الصفحة بعد 2 ثانية
        echo '<meta http-equiv="refresh" content="2;url='.$_SERVER['REQUEST_URI'].'">';
    } else {
        echo "<div style='color:red; font-weight:bold;'>كلمة المرور غير صحيحة! التصفير غير مسموح.</div>";
    }
}

// التعامل مع الفترات
$period = isset($_GET['period']) ? $_GET['period'] : 'today';
$custom_date = isset($_GET['custom_date']) ? $_GET['custom_date'] : '';
$filter_sql = "";

switch($period) {
    case 'today':
        $filter_sql = "DATE(order_date) = CURDATE()";
        $expense_filter = "DATE(expense_date) = CURDATE()";
        break;
    case 'week':
        $filter_sql = "YEARWEEK(order_date, 1) = YEARWEEK(CURDATE(), 1)";
        $expense_filter = "YEARWEEK(expense_date, 1) = YEARWEEK(CURDATE(), 1)";
        break;
    case 'month':
        $filter_sql = "YEAR(order_date) = YEAR(CURDATE()) AND MONTH(order_date) = MONTH(CURDATE())";
        $expense_filter = "YEAR(expense_date) = YEAR(CURDATE()) AND MONTH(expense_date) = MONTH(CURDATE())";
        break;
    case 'year':
        $filter_sql = "YEAR(order_date) = YEAR(CURDATE())";
        $expense_filter = "YEAR(expense_date) = YEAR(CURDATE())";
        break;
    case 'custom':
        if ($custom_date) {
            $filter_sql = "DATE(order_date) = '" . mysqli_real_escape_string($conn, $custom_date) . "'";
            $expense_filter = "DATE(expense_date) = '" . mysqli_real_escape_string($conn, $custom_date) . "'";
        } else {
            $filter_sql = "1"; // بدون تصفية
            $expense_filter = "1";
        }
        break;
    default:
        $filter_sql = "DATE(order_date) = CURDATE()";
        $expense_filter = "DATE(expense_date) = CURDATE()";
}

// دوال الإحصائيات
function get_count($conn, $type, $filter_sql) {
    if ($type == 'delivery') {
        $type_sql = "order_type='delivery'";
    } else {
        $type_sql = "order_type='dinein'";
    }
    $query = "SELECT COUNT(*) as c FROM tbl_order WHERE $type_sql AND $filter_sql";
    $res = mysqli_query($conn, $query);
    if (!$res) { die("خطأ في استعلام الطلبات: " . mysqli_error($conn)); }
    $row = mysqli_fetch_assoc($res);
    return $row ? $row['c'] : 0;
}
function get_sum($conn, $filter_sql) {
    $query = "SELECT SUM(total) as s FROM tbl_order WHERE $filter_sql";
    $res = mysqli_query($conn, $query);
    if (!$res) { die("خطأ في استعلام الإيرادات: " . mysqli_error($conn)); }
    $row = mysqli_fetch_assoc($res);
    return $row && $row['s'] ? $row['s'] : 0;
}
function get_expenses($conn, $expense_filter) {
    $query = "SELECT SUM(amount) as s FROM tbl_expenses WHERE $expense_filter";
    $res = mysqli_query($conn, $query);
    if (!$res) { die("خطأ في استعلام المصروفات: " . mysqli_error($conn)); }
    $row = mysqli_fetch_assoc($res);
    return $row && $row['s'] ? $row['s'] : 0;
}

// إضافة مصروف جديد
if(isset($_POST['add_expense'])) {
    $name = mysqli_real_escape_string($conn, $_POST['expense_name']);
    $amount = floatval($_POST['amount']);
    $type = mysqli_real_escape_string($conn, $_POST['expense_type']);
    mysqli_query($conn, "INSERT INTO tbl_expenses (expense_name, amount, expense_type) VALUES ('$name', '$amount', '$type')");
    echo "<div style='color:green'>تمت إضافة المصروف بنجاح!</div>";
    // إعادة تحميل حتى تظهر في الإحصائيات فورًا
    echo '<meta http-equiv="refresh" content="1;url='.$_SERVER['REQUEST_URI'].'">';
}

// القيم المطلوبة
$table_orders = get_count($conn, 'table', $filter_sql);
$delivery_orders = get_count($conn, 'delivery', $filter_sql);
$total_income = get_sum($conn, $filter_sql);
$total_expenses = get_expenses($conn, $expense_filter);
$net_profit = $total_income - $total_expenses;
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جرد وإحصائيات الكاشير</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 1050px; margin: 32px auto 24px; background: #fff; border-radius: 20px; box-shadow: 0 5px 30px #dbe7f380; padding: 32px 18px;}
        h2 {text-align:center; color:#008050;}
        .stats-cards { display: flex; gap: 15px; margin-bottom:22px; flex-wrap:wrap;}
        .stats-card { background:#f7f8fa; border-radius:13px; padding:17px 22px; box-shadow:0 1px 9px #dbe7f366; min-width:150px;}
        .stats-card span { display:block; color:#008050; font-size:1.2rem; font-weight:bold;}
        .stats-card label { color:#444; font-size:0.97rem;}
        .section {margin-bottom:26px;}
        table {width:100%; border-collapse:collapse; margin-top:16px;}
        th,td {padding:7px 3px; border-bottom:1px solid #eee;}
        th {background:#eaf4f0;}
        tr:hover {background:#f5f8fa;}
        form {margin-bottom:15px;}
        input, select, button {font-family:'Cairo',Arial,sans-serif;font-size:1rem;padding:7px 10px;margin:2px 4px;}
        button {background:#008050;color:#fff;border:none;border-radius:7px;cursor:pointer;}
        button:hover {background:#005f3b;}
        @media(max-width:900px){ .stats-cards{flex-direction:column;}}
    </style>
</head>
<body>
<div class="container">
    <h2>إحصائيات وجرد الكاشير</h2>

    <div class="section">
        <form method="GET" style="display:flex;gap:10px;align-items:center;flex-wrap:wrap;">
            <label>اختر الفترة:</label>
            <select name="period" onchange="this.form.submit()">
                <option value="today" <?php if($period=='today') echo 'selected'; ?>>اليوم</option>
                <option value="week" <?php if($period=='week') echo 'selected'; ?>>الأسبوع</option>
                <option value="month" <?php if($period=='month') echo 'selected'; ?>>الشهر</option>
                <option value="year" <?php if($period=='year') echo 'selected'; ?>>السنة</option>
                <option value="custom" <?php if($period=='custom') echo 'selected'; ?>>تاريخ محدد</option>
            </select>
            <input type="date" name="custom_date" value="<?php echo htmlspecialchars($custom_date); ?>" style="min-width:120px;">
            <button type="submit">عرض</button>
        </form>
    </div>

    <div class="stats-cards">
        <div class="stats-card"><span><?php echo $table_orders; ?></span><label>طلبات الطاولات</label></div>
        <div class="stats-card"><span><?php echo $delivery_orders; ?></span><label>طلبات الدليفري</label></div>
        <div class="stats-card"><span><?php echo number_format($total_income,2); ?></span><label>إجمالي الإيرادات (د.ع)</label></div>
        <div class="stats-card"><span><?php echo number_format($total_expenses,2); ?></span><label>إجمالي المصروفات (د.ع)</label></div>
        <div class="stats-card"><span><?php echo number_format($net_profit,2); ?></span><label>الصافي (د.ع)</label></div>
    </div>

    <div class="section">
        <h3>إضافة مصروف جديد</h3>
        <form method="POST" style="display:flex;gap:7px;flex-wrap:wrap;">
            <input type="text" name="expense_name" placeholder="اسم المصروف" required>
            <input type="number" step="0.01" name="amount" placeholder="المبلغ" required>
            <input type="text" name="expense_type" placeholder="نوع المصروف أو وصف" required>
            <button type="submit" name="add_expense">إضافة</button>
        </form>
    </div>

    <div class="section">
        <h3>جدول المصروفات الأخيرة</h3>
        <table>
            <tr><th>الاسم</th><th>المبلغ (د.ع)</th><th>النوع/الوصف</th><th>التاريخ</th></tr>
            <?php
            $res = mysqli_query($conn, "SELECT * FROM tbl_expenses ORDER BY expense_date DESC LIMIT 20");
            if (!$res) { echo '<tr><td colspan="4" style="color:red;">خطأ في جلب المصروفات: '.mysqli_error($conn).'</td></tr>'; }
            else {
                while($row = mysqli_fetch_assoc($res)){
                    echo "<tr>
                    <td>".htmlspecialchars($row['expense_name'])."</td>
                    <td>".number_format($row['amount'],2)."</td>
                    <td>".htmlspecialchars($row['expense_type'])."</td>
                    <td>".$row['expense_date']."</td>
                    </tr>";
                }
            }
            ?>
        </table>
    </div>

    <!-- زر التصفير -->
    <div style="margin-top:30px; text-align:center;">
        <button type="button" onclick="document.getElementById('resetModal').style.display='block'" style="background:#d00;color:#fff;font-size:1.1rem;padding:12px 30px;border-radius:13px;cursor:pointer;">تصفير جميع الحسابات</button>
    </div>

    <!-- نافذة إدخال كلمة المرور -->
    <div id="resetModal" style="display:none;position:fixed;top:0;left:0;width:100vw;height:100vh;background:#000a;z-index:9999;">
        <div style="background:#fff;padding:28px 22px;max-width:340px;margin:120px auto;border-radius:17px;text-align:center;box-shadow:0 0 25px #0005;">
            <form method="POST" onsubmit="return confirm('هل أنت متأكد أنك تريد تصفير جميع الحسابات؟ هذا الإجراء لا يمكن التراجع عنه!');">
                <h3 style="color:#b00;">تأكيد التصفير</h3>
                <input type="password" name="reset_password" placeholder="كلمة المرور" style="font-size:1.2rem;padding:8px 18px;border-radius:9px;margin:14px 0;" required>
                <br>
                <button type="submit" name="reset_all" style="background:#d00;color:#fff;padding:7px 26px;border-radius:7px;">تصفير الكل</button>
                <br><br>
                <button type="button" onclick="closeModal()" style="padding:6px 22px;border-radius:7px;background:#ccc;">إلغاء</button>
            </form>
        </div>
    </div>
    <script>
        function closeModal() {
            document.getElementById('resetModal').style.display = 'none';
        }
        document.getElementById('resetModal').addEventListener('click', function(e) {
            if (e.target === this) closeModal();
        });
    </script>
</div>
</body>
</html>
