<?php
include('config/constants.php');

// جلب كل الطلبات في المطبخ مع تفاصيل الطلب، مع إضافة order_type
$sql = "SELECT ko.id AS kitchen_order_id, tbo.customer_name, tbo.food, tbo.qty, tbo.status, tbo.order_type
        FROM kitchen_orders ko
        JOIN tbl_order tbo ON ko.order_id = tbo.id
        WHERE tbo.status != 'Delivered' AND tbo.status != 'Cancelled'
        ORDER BY tbo.customer_name+0 ASC, ko.created_at ASC";
$res = mysqli_query($conn, $sql);

// تجميع الطلبات لكل طاولة أو زبون دليفري
$tables = [];
while($row = mysqli_fetch_assoc($res)) {
    $table = $row['customer_name'];
    $kitchen_order_id = $row['kitchen_order_id'];
    $order_type = isset($row['order_type']) ? $row['order_type'] : 'dinein'; // احتياطي

    if(!isset($tables[$table])) {
        $tables[$table] = [
            'kitchen_order_ids' => [],
            'orders' => [],
            'order_type' => $order_type,
        ];
    }
    $tables[$table]['kitchen_order_ids'][] = $kitchen_order_id;
    $tables[$table]['orders'][] = htmlspecialchars($row['food']).' × '.htmlspecialchars($row['qty']);
}

if(count($tables) == 0) {
    echo "<div style='grid-column:1/-1;text-align:center;padding:30px 0;font-size:20px;color:#888;'>لا توجد طلبات حالياً في المطبخ.</div>";
} else {
    foreach($tables as $table => $data) {
        $kitchen_order_ids = implode(',', $data['kitchen_order_ids']); // IDs مفصولة بفاصلة
        echo "<div class='kitchen-card' onclick=\"markAsDone('".$kitchen_order_ids."')\">";

        // إذا الطلب دليفري، أظهر شارة دليفري باللون الأحمر
        if ($data['order_type'] == 'delivery') {
            echo "<div class='delivery-label'>دليفري</div>";
            echo "<div class='table-num' style='font-size:19px'>".htmlspecialchars($table)."</div>";
        } else {
            // طلب طاولة
            echo "<div class='table-num'>طاولة ".htmlspecialchars($table)."</div>";
        }

        echo "<span class='order-status'>جاري التجهيز</span>";
        echo "<ul class='order-list'>";
        foreach($data['orders'] as $item) {
            echo "<li>$item</li>";
        }
        echo "</ul>";
        echo "<span class='preparing-label'>جاري التجهيز</span>";
        echo "</div>";
    }
}
?>

<!-- أضف هذا في ملف CSS الخارجي أو داخل <style> في kitchen.php -->
<style>
.delivery-label {
    color: #fff;
    background: #e53935;
    border-radius: 6px;
    padding: 3px 12px;
    font-size: 16px;
    margin-bottom: 5px;
    display: inline-block;
    font-weight: bold;
    letter-spacing: 1px;
}
</style>
