<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

function log_debug($msg) {
    $date = date("Y-m-d H:i:s");
    file_put_contents("debug.txt", "[$date] $msg\n", FILE_APPEND);
}

include('config/constants.php');

$table_number = isset($_POST['table_number']) ? (int)$_POST['table_number'] : 0;
$device_token = isset($_POST['device_token']) ? mysqli_real_escape_string($conn, $_POST['device_token']) : '';

if(!$table_number || !$device_token){
    log_debug("Missing data: table_number=$table_number | device_token=$device_token");
    echo json_encode(['success'=>false, 'message'=>'بيانات غير مكتملة.']);
    exit;
}

$today = date('Y-m-d');
$sql = "SELECT COUNT(*) AS cnt FROM tbl_waiter_requests WHERE device_token='$device_token' AND DATE(request_time) = '$today'";
$res = mysqli_query($conn, $sql);
if(!$res){
    log_debug("SQL Error: " . mysqli_error($conn) . " | Query: $sql");
    echo json_encode(['success'=>false, 'message'=>'خطأ في الاستعلام الأول.']);
    exit;
}
$row = mysqli_fetch_assoc($res);

if($row['cnt'] >= 2){
    log_debug("Exceeded limit: device_token=$device_token | table=$table_number | count={$row['cnt']}");
    echo json_encode(['success'=>false, 'message'=>'لا يمكنك طلب النادل أكثر من مرتين في اليوم.']);
    exit;
}

// تحقق إذا هناك طلب جاري لنفس الطاولة لم ينتهِ بعد
$sql2 = "SELECT id FROM tbl_waiter_requests WHERE table_number=$table_number AND status='waiting'";
$res2 = mysqli_query($conn, $sql2);
if(!$res2){
    log_debug("SQL Error: " . mysqli_error($conn) . " | Query: $sql2");
    echo json_encode(['success'=>false, 'message'=>'خطأ في الاستعلام الثاني.']);
    exit;
}
if(mysqli_num_rows($res2) > 0){
    log_debug("Request already waiting: table=$table_number | device_token=$device_token");
    echo json_encode(['success'=>false, 'message'=>'تم بالفعل إرسال طلب للنادل، يرجى الانتظار.']);
    exit;
}

// أضف الطلب
$sql3 = "INSERT INTO tbl_waiter_requests (table_number, device_token, request_time) VALUES ($table_number, '$device_token', NOW())";
$res3 = mysqli_query($conn, $sql3);
if($res3){
    log_debug("Request sent: table=$table_number | device_token=$device_token");
    echo json_encode(['success'=>true, 'message'=>'تم إرسال طلب النادل بنجاح. يرجى الانتظار!']);
}else{
    log_debug("SQL Insert Error: " . mysqli_error($conn) . " | Query: $sql3 | device_token: $device_token | table: $table_number");
    echo json_encode(['success'=>false, 'message'=>'حدث خطأ أثناء إرسال الطلب.']);
}
exit;
