<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success'=>false, 'message'=>'الدخول مرفوض']); exit;
}
include('../config.php');

if (empty($_POST['purchase_id']) || empty($_POST['qty'])) {
    echo json_encode(['success'=>false, 'message'=>'بيانات غير مكتملة']); exit;
}

$purchase_id = intval($_POST['purchase_id']);
$return_qty = intval($_POST['qty']);
$reason = isset($_POST['reason']) ? mysqli_real_escape_string($conn, $_POST['reason']) : '';
$user_id = $_SESSION['user_id'];

// جلب العملية الأصلية للتحقق
$purchase = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM purchases WHERE id=$purchase_id"));
if (!$purchase) {
    echo json_encode(['success'=>false, 'message'=>'لم يتم العثور على عملية الشراء']); exit;
}
if ($return_qty < 1 || $return_qty > $purchase['quantity']) {
    echo json_encode(['success'=>false, 'message'=>'الكمية غير صحيحة']); exit;
}

// تسجيل المرتجع في purchase_returns
mysqli_query($conn, "INSERT INTO purchase_returns (purchase_id, user_id, supplier_name, return_date, reason)
    VALUES ($purchase_id, $user_id, '".mysqli_real_escape_string($conn, $purchase['supplier'])."', NOW(), '$reason')");
$return_id = mysqli_insert_id($conn);

// تفاصيل المرتجع
mysqli_query($conn, "INSERT INTO purchase_return_items (purchase_return_id, product_id, quantity, price)
    VALUES ($return_id, {$purchase['medicine_id']}, $return_qty, {$purchase['cost_price']})");

// خصم الكمية من المخزون
mysqli_query($conn, "UPDATE medicines SET quantity = quantity - $return_qty WHERE id = {$purchase['medicine_id']}");

// تحديث الكمية المتبقية في العملية
mysqli_query($conn, "UPDATE purchases SET quantity = quantity - $return_qty WHERE id = $purchase_id");

echo json_encode(['success'=>true, 'message'=>'تم تنفيذ مرتجع المورد بنجاح!']);
