<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    http_response_code(403); exit;
}
include('../config.php');

if (!isset($_GET['supplier']) || $_GET['supplier'] == '') {
    echo json_encode([]); exit;
}

$supplier = mysqli_real_escape_string($conn, $_GET['supplier']);
$res = mysqli_query($conn, "SELECT p.id, p.medicine_id, p.quantity, p.cost_price, p.purchase_date, m.name AS medicine_name
    FROM purchases p
    JOIN medicines m ON p.medicine_id = m.id
    WHERE p.supplier = '$supplier'
    ORDER BY p.purchase_date DESC");

$purchases = [];
while ($row = mysqli_fetch_assoc($res)) {
    $purchases[] = [
        'id' => $row['id'],
        'medicine_name' => $row['medicine_name'],
        'medicine_id' => $row['medicine_id'],
        'quantity' => $row['quantity'],
        'cost_price' => $row['cost_price'],
        'purchase_date' => $row['purchase_date'],
    ];
}
header('Content-Type: application/json; charset=utf-8');
echo json_encode($purchases);
