<?php
session_start();
include('config.php');
if (!isset($_SESSION['user_id'])) header('Location: login.php');

// البحث
$filter = '';
if (!empty($_GET['search'])) {
    $q = mysqli_real_escape_string($conn, $_GET['search']);
    $filter = "WHERE medicine_name LIKE '%$q%' OR company_name LIKE '%$q%' OR rep_name LIKE '%$q%'";
}

$res = mysqli_query($conn, "SELECT * FROM medicine_reps $filter ORDER BY offer_date DESC, id DESC");

// حذف عرض
if (isset($_GET['del']) && is_numeric($_GET['del'])) {
    $id = intval($_GET['del']);
    mysqli_query($conn, "DELETE FROM medicine_reps WHERE id=$id");
    header("Location: all_rep_offers.php?deleted=1");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جميع عروض المندوبين</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {background:#f7fbfd; font-family:'Cairo',Arial,sans-serif;}
        .container {max-width:1150px;margin:36px auto;}
        h2 {color:#1976d2; text-align:center;}
        /* أزرار موحدة */
        .m-btn {
            display: inline-flex;
            align-items: center;
            gap: 3px;
            padding: 8px 15px;
            border: 1.5px solid #b6cced;
            border-radius: 8px;
            font-weight: bold;
            font-size: 1.06rem;
            text-decoration: none;
            cursor: pointer;
            transition: background .13s, box-shadow .15s, color .13s, border .13s;
            box-shadow: 0 1px 7px #e3eefd1c;
            margin: 2px 2px 2px 0;
            min-width: 38px;
        }
        .m-btn svg {vertical-align: middle;}
        .m-btn.info   {background:linear-gradient(90deg,#e5f7ff 80%,#f3fbff 100%);color:#0288d1;border-color:#a4e0fa;}
        .m-btn.info:hover {background:linear-gradient(90deg,#cbefff 80%,#e2f6ff 100%);color:#015378;}
        .m-btn.del   {background:linear-gradient(90deg,#ffebee 80%,#fff3f7 100%);color:#d32f2f;border-color:#fdc6c6;}
        .m-btn.del:hover {background:linear-gradient(90deg,#ffdadf 80%,#ffe6ec 100%);color:#900707;}
        .m-btn.search {
            background: linear-gradient(90deg,#f3faee 80%,#f7fbfd 100%);
            color: #43a047;
            border-color: #a4e0fa;
        }
        .m-btn.search:hover {
            background: linear-gradient(90deg,#e3f7e7 80%,#eaf5f2 100%);
            color: #21892f;
        }
        .search-bar {max-width:400px;margin:16px auto 30px auto;display:flex;gap:8px;}
        .search-bar input {flex:1;padding:9px 10px;border-radius:8px;border:1px solid #b6cced;font-size:1.1rem;}
        table {width:100%;border-collapse:collapse;background:#fff;box-shadow:0 6px 18px #dde7fc61;}
        th,td {padding:10px;text-align:center;border-bottom:1px solid #eaeaea;}
        th {background:#eaf1fb;}
        tr:hover {background:#f1f8ff;}
        .actions a {margin:0 4px;}
        .badge {background:#ffd500;color:#222;padding:2px 11px;border-radius:11px;font-weight:bold;}
        .success-msg {color:#43a047;text-align:center;}
        /* تحسين مظهر النافذة */
        .offer-modal {
            display: none;
            position: fixed;
            top: 0; left: 0;
            width: 100vw; height: 100vh;
            background: #222a3de0;
            z-index: 9999;
            align-items: center; justify-content: center;
            animation: fadeInBg .3s;
        }
        @keyframes fadeInBg {from{opacity:0;} to{opacity:1;}}
        .offer-modal-content {
            background: #fff;
            border-radius: 22px;
            max-width: 400px;
            margin: 65px auto;
            position: relative;
            box-shadow: 0 12px 40px #93e4fa35;
            padding: 38px 22px 28px 22px;
            animation: fadeInPop .33s;
            min-width: 270px;
        }
        @keyframes fadeInPop {
            0% {opacity:0;transform:scale(0.8);}
            85% {transform:scale(1.04);}
            100% {opacity:1;transform:scale(1);}
        }
        .offer-icon {
            display:flex;align-items:center;justify-content:center;
            background: linear-gradient(135deg, #e6f7ff 80%, #d4fbf2 100%);
            border-radius: 14px;
            width: 52px; height: 52px;
            margin: -38px auto 10px auto;
            box-shadow: 0 2px 13px #b8e3ff14;
        }
        .offer-modal-content h3 {
            color: #1976d2;
            text-align: center;
            font-weight: bold;
            margin-top: 7px;
            margin-bottom: 13px;
        }
        .offer-details-list {
            padding: 0 4px;
        }
        .offer-details-list .label {
            color: #0890c2;
            font-weight: 600;
            margin-left: 6px;
            display: inline-block;
            min-width: 88px;
        }
        .offer-details-list div {
            margin-bottom: 9px;
            font-size: 1.08rem;
            color: #222;
        }
        .offer-modal-content .close-btn {
            background: #1976d2;
            color: #fff;
            padding: 7px 25px;
            border-radius: 9px;
            margin: 10px auto 0 auto;
            cursor: pointer;
            display:block;
            border:none;
            font-size:1.09rem;
            font-weight:600;
            box-shadow:0 2px 18px #9fd7ff23;
        }
        .offer-rep-badge {
            font-size: .97rem;
            color: #fff;
            background: #13b4c6;
            padding: 1px 10px 2px 10px;
            border-radius: 8px;
            margin-right: 5px;
            font-weight: 700;
            letter-spacing: 1.1px;
        }
        @media (max-width:800px){ .container{max-width:99vw;} table,th,td{font-size:.98rem;}}
        @media (max-width:430px){
            .offer-modal-content {max-width:98vw;padding:17px 2px 17px 2px;}
        }
    </style>
    <script>
        function showDetails(id){
            var modal = document.getElementById('modal-'+id);
            modal.style.display = 'flex';
        }
        function closeModal(id){
            document.getElementById('modal-'+id).style.display = 'none';
        }
        function confirmDelete(url){
            if(confirm('هل أنت متأكد من حذف العرض؟')){window.location = url;}
        }
        // لإغلاق النافذة عند الضغط خارجها
        window.onclick = function(e){
            document.querySelectorAll('.offer-modal').forEach(function(modal){
                if(e.target === modal){ modal.style.display = 'none'; }
            });
        }
    </script>
</head>
<body>
<div class="container">
    <h2>جميع عروض المندوبين</h2>
    <?php if(isset($_GET['deleted'])): ?>
        <div class="success-msg">تم حذف العرض بنجاح.</div>
    <?php endif; ?>
    <form method="get" class="search-bar">
        <input type="text" name="search" placeholder="بحث باسم الدواء أو الشركة أو المندوب..." value="<?= isset($_GET['search']) ? htmlspecialchars($_GET['search']) : '' ?>">
        <button type="submit" class="m-btn search">
            <svg width="16" height="16" viewBox="0 0 20 20"><circle cx="9" cy="9" r="6" stroke="#43a047" stroke-width="1.7" fill="none"/><path d="M15 15l-3-3" stroke="#43a047" stroke-width="1.7" stroke-linecap="round"/></svg>
            بحث
        </button>
    </form>
    <table>
        <tr>
            <th>#</th>
            <th>اسم الدواء</th>
            <th>الشركة</th>
            <th>نوع الدواء</th>
            <th>الكمية</th>
            <th>اسم المندوب</th>
            <th>تاريخ العرض</th>
            <th>إجراءات</th>
        </tr>
        <?php if($res && mysqli_num_rows($res)>0): $i=1; while($row = mysqli_fetch_assoc($res)): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($row['medicine_name']) ?></td>
                <td><?= htmlspecialchars($row['company_name']) ?></td>
                <td>
                    <?= htmlspecialchars($row['medicine_type']) ?>
                    <?php if($row['medicine_type']=='أخرى' && $row['custom_type']): ?>
                        <span class="badge"><?= htmlspecialchars($row['custom_type']) ?></span>
                    <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($row['quantity']) ?></td>
                <td><?= htmlspecialchars($row['rep_name']) ?></td>
                <td><?= htmlspecialchars($row['offer_date']) ?></td>
                <td class="actions">
                    <a href="javascript:void(0);" onclick="showDetails(<?= $row['id'] ?>)" class="m-btn info" title="عرض التفاصيل">
                        <svg width="17" height="17" viewBox="0 0 20 20"><circle cx="10" cy="10" r="8" stroke="#0288d1" stroke-width="1.5" fill="none"/><path d="M10 6v2m0 2v4" stroke="#0288d1" stroke-width="1.5" stroke-linecap="round"/></svg>
                        تفاصيل
                    </a>
                    <a href="javascript:void(0);" class="m-btn del" onclick="confirmDelete('?del=<?= $row['id'] ?>')" title="حذف">
                        <svg width="16" height="16" viewBox="0 0 20 20"><path d="M6 8v6M10 8v6m4-6v6M4 6h12" stroke="#d32f2f" stroke-width="1.2" stroke-linecap="round"/><rect x="5" y="6" width="10" height="10" rx="2" fill="none" stroke="#d32f2f" stroke-width="1"/></svg>
                        حذف
                    </a>
                </td>
            </tr>
            <!-- نافذة التفاصيل المحسنة -->
            <div id="modal-<?= $row['id'] ?>" class="offer-modal">
                <div class="offer-modal-content">
                    <div class="offer-icon">
                        <!-- أيقونة كبسولة صيدلية -->
                        <svg width="36" height="36" viewBox="0 0 48 48" fill="none">
                            <rect x="9" y="18" width="30" height="12" rx="6" fill="#f5fafd"/>
                            <rect x="17" y="16" width="14" height="16" rx="7" fill="#13c6a3"/>
                            <rect x="24" y="16" width="7" height="16" rx="3.5" fill="#fff"/>
                            <circle cx="24" cy="24" r="5" fill="#fff" opacity=".28"/>
                        </svg>
                    </div>
                    <h3>تفاصيل العرض</h3>
                    <div class="offer-details-list">
                        <div><span class="label">اسم الدواء:</span> <?= htmlspecialchars($row['medicine_name']) ?></div>
                        <div><span class="label">الشركة:</span> <?= htmlspecialchars($row['company_name']) ?></div>
                        <div><span class="label">نوع الدواء:</span> <?= htmlspecialchars($row['medicine_type']) ?>
                            <?php if($row['medicine_type']=='أخرى' && $row['custom_type']): ?>
                                <span class="badge"><?= htmlspecialchars($row['custom_type']) ?></span>
                            <?php endif; ?>
                        </div>
                        <div><span class="label">الكمية:</span> <?= htmlspecialchars($row['quantity']) ?></div>
                        <div><span class="label">مندوب:</span> <?= htmlspecialchars($row['rep_name']) ?>
                            <span class="offer-rep-badge"><?= htmlspecialchars($row['rep_number']) ?></span>
                        </div>
                        <div><span class="label">العرض:</span> <?= htmlspecialchars($row['offer']) ?></div>
                        <div><span class="label">تاريخ العرض:</span> <?= htmlspecialchars($row['offer_date']) ?></div>
                        <div><span class="label">ملاحظات:</span> <?= htmlspecialchars($row['notes']) ?: '---' ?></div>
                    </div>
                    <button onclick="closeModal(<?= $row['id'] ?>)" class="close-btn">إغلاق</button>
                </div>
            </div>
        <?php endwhile; else: ?>
            <tr>
                <td colspan="8" style="color:#888;">لا توجد عروض حالياً.</td>
            </tr>
        <?php endif; ?>
    </table>
</div>
</body>
</html>
