<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
// --- استخراج بيانات المبيعات الأسبوعية ---
$conn = mysqli_connect('localhost', 'mosuclaz', 'CgQqC9g4msfD', 'mosuclaz_pharmacy_db');
mysqli_set_charset($conn, "utf8mb4");
$sales_labels = [];
$sales_values = [];
for ($i = 6; $i >= 0; $i--) {
    $day = date('Y-m-d', strtotime("-$i days"));
    $sales_labels[] = date('d/m', strtotime($day)); // اليوم/الشهر
    $sql = "SELECT SUM(total) as sum_sales FROM sales WHERE DATE(sale_date)='$day'";
    $result = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($result);
    $sales_values[] = $row['sum_sales'] ? (float)$row['sum_sales'] : 0;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم نظام الصيدلية الذكي</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: linear-gradient(120deg, #e7efff 0%, #e0e9f6 100%);
            min-height: 100vh;
            font-family: 'Cairo', Arial, sans-serif;
            margin: 0;
        }
        /* رسالة الترحيب */
        .welcome-overlay {
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(232, 250, 240, 0.95);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 5000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.7s;
            font-family: 'Cairo', Arial, sans-serif;
        }
        .welcome-overlay.show {
            opacity: 1;
            pointer-events: all;
        }
        .welcome-msg {
            text-align: center;
            background: #fff;
            border-radius: 28px;
            padding: 48px 34px 38px 34px;
            box-shadow: 0 10px 45px #bbffe0b9;
            font-size: 2.1rem;
            color: #19844d;
            font-weight: bold;
            letter-spacing: 1px;
            position: relative;
            animation: welcomePop 1.1s cubic-bezier(.25,1.6,.38,1.09);
        }
        .welcome-msg span {
            display: block;
            font-size: 1.2rem;
            color: #1976d2;
            font-weight: 700;
            margin-top: 16px;
        }
        @keyframes welcomePop {
            0%   {transform: scale(0.6); opacity: 0;}
            70%  {transform: scale(1.09);}
            100% {transform: scale(1); opacity: 1;}
        }
        .dash-container {
            max-width: 1080px;
            margin: 60px auto 0;
            background: #fff;
            border-radius: 28px;
            box-shadow: 0 9px 38px #dbe7f366;
            padding: 48px 30px 40px 30px;
            display: flex;
            flex-direction: column;
            align-items: center;
            opacity: 1;
            transition: opacity 0.5s;
            position: relative;
        }
        .dash-container.hide { opacity: 0.12; pointer-events: none;}
        h1 {
            color: #1976d2;
            font-size: 2.3rem;
            margin-bottom: 38px;
            font-weight: 900;
            letter-spacing: 1.1px;
            text-shadow: 0 1px 10px #dbe7f355;
        }
        .chart-fab {
            position: absolute;
            top: 34px;
            right: 40px;
            z-index: 1001;
            background: linear-gradient(130deg,#43a047 15%,#1976d2 85%);
            color: #fff;
            border: none;
            border-radius: 50%;
            width: 64px;
            height: 64px;
            box-shadow: 0 4px 24px #1976d26b;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2.2rem;
            cursor: pointer;
            transition: transform .16s, box-shadow .16s, background .22s;
            outline: none;
        }
        .chart-fab:hover {
            transform: scale(1.11) rotate(-7deg);
            background: linear-gradient(120deg,#1976d2 45%,#43a047 100%);
            box-shadow: 0 12px 32px #1976d2b9;
        }
        .dashboard-chart-modal {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(30,44,77,0.29);
            align-items: center;
            justify-content: center;
            z-index: 99999;
        }
        .dashboard-chart-modal.active {
            display: flex;
        }
        .dashboard-chart-box {
            background: #fff;
            border-radius: 32px;
            box-shadow: 0 8px 64px #1976d245;
            padding: 40px 22px 28px 22px;
            max-width: 520px;
            width: 95vw;
            max-height: 93vh;
            position: relative;
            animation: chartpop .44s cubic-bezier(.31,1.8,.41,1.07);
        }
        @keyframes chartpop {
            0% { transform: scale(.8) translateY(40px); opacity:0; }
            100% { transform: scale(1) translateY(0); opacity:1;}
        }
        .close-chart-btn {
            position: absolute;
            left: 21px;
            top: 21px;
            background: #f7f7fa;
            border: none;
            color: #1976d2;
            border-radius: 50%;
            width: 38px;
            height: 38px;
            font-size: 1.22rem;
            cursor: pointer;
            font-weight: bold;
            box-shadow: 0 1px 8px #1976d228;
            transition: background 0.2s, color .2s;
        }
        .close-chart-btn:hover {
            background: #1976d2;
            color: #fff;
        }
        .dashboard-chart-title {
            text-align: center;
            font-size: 1.29rem;
            color: #1976d2;
            font-weight: bold;
            margin-bottom: 7px;
        }
        .dashboard-chart-desc {
            text-align: center;
            font-size: 1.1rem;
            color: #43a047;
            margin-bottom: 18px;
            font-weight: bold;
        }
        .dash-links {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(230px, 1fr));
            gap: 32px;
            width: 100%;
        }
        .dash-card {
            background: linear-gradient(130deg,#f3f8ff 48%,#f5fafd 100%);
            border-radius: 18px;
            box-shadow: 0 2px 14px #1976d214;
            padding: 37px 16px 30px 16px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: box-shadow 0.15s, transform 0.13s;
            cursor: pointer;
            position: relative;
            text-align: center;
            user-select: none;
            min-height: 180px;
            border: none;
        }
        .dash-card:hover {
            box-shadow: 0 8px 28px #1976d249;
            transform: translateY(-7px) scale(1.04);
        }
        .dash-card .card-icon {
            font-size: 2.9rem;
            width: 74px;
            height: 74px;
            color: #1976d2;
            background: #e9f1ff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 14px;
            box-shadow: 0 3px 12px #1976d219;
            transition: background 0.14s, color 0.18s, transform 0.33s cubic-bezier(.41,1.8,.41,1.09);
        }
        .dash-card:hover .card-icon {
            color: #fff;
            background: linear-gradient(120deg, #1976d2 60%, #43a047 120%);
            transform: scale(1.17) rotate(-5deg);
        }
        .protected-card::after {
            content: "🔒";
            position: absolute;
            left: 15px;
            top: 13px;
            font-size: 1.14rem;
            color: #e65100;
        }
        .dash-card span {
            font-size: 1.18rem;
            font-weight: bold;
            color: #252b38;
            margin-bottom: 8px;
        }
        .dash-card .enter-link {
            margin-top: 12px;
            display: inline-block;
            padding: 9px 26px;
            border-radius: 8px;
            background: #1976d2;
            color: #fff;
            font-weight: 700;
            font-size: 1.05rem;
            text-decoration: none;
            transition: background 0.14s;
            box-shadow: 0 2px 8px #1976d221;
        }
        .dash-card .enter-link:hover {
            background: #1353a6;
        }
        @media (max-width: 600px) {
            .chart-fab { right: 12px; top: 14px; width: 48px; height: 48px; font-size: 1.3rem;}
            .dashboard-chart-box { padding: 10px 0 9px 0; border-radius: 17px;}
            .dash-container {padding: 13px;}
            .dash-links {gap: 14px;}
            .dash-card {padding: 20px 4px 14px 4px; min-height:128px;}
            h1 {font-size: 1.3rem;}
        }
        /* نافذة كلمة المرور */
        .pw-modal {
            display: none;
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(34,44,67,0.18);
            align-items: center; justify-content: center;
            z-index: 5100;
        }
        .pw-modal.active {display: flex;}
        .pw-modal-content {
            background: #fff;
            border-radius: 18px;
            padding: 34px 19px 20px 19px;
            min-width: 270px;
            box-shadow: 0 7px 38px #1976d257;
            display: flex; flex-direction: column; align-items: center;
        }
        .pw-modal input {
            margin-top: 8px;
            padding: 9px 10px;
            border-radius: 7px;
            border: 1.1px solid #b8bdd1;
            font-size: 1.18rem;
            width: 160px;
            text-align: center;
            margin-bottom: 16px;
        }
        .pw-modal button {
            padding: 7px 28px;
            border-radius: 8px;
            background: #1976d2;
            color: #fff;
            font-weight: 700;
            border: none;
            font-size: 1.04rem;
            margin-bottom: 5px;
            margin-left: 7px;
        }
        .pw-modal .close-btn {
            background: #eee; color: #222; font-weight: bold; padding: 4px 18px; margin-bottom: 0;
            margin-top: 8px; border-radius: 6px; border: 1px solid #bbb;
        }
        .pw-modal .err-msg {color: #be001e; margin-bottom: 4px; font-size: 1rem;}
        /* رسالة النسخ */
        #copyMsg {
            display: none;
            position: fixed;
            top: 34px;
            left: 50%;
            transform: translateX(-50%);
            background: #1976d2;
            color: #fff;
            padding: 12px 28px;
            border-radius: 9px;
            font-size: 1.15em;
            z-index: 6000;
            box-shadow: 0 2px 18px #1976d279;
            opacity: 0.98;
        }
    </style>
</head>
<body>
    <!-- رسالة ترحيب متحركة -->
    <div class="welcome-overlay" id="welcomeOverlay">
        <div class="welcome-msg">
            أهلاً بك في <br>
            <span>نظام الصيدلية الذكي</span>
        </div>
    </div>
    <div class="dash-container hide" id="dashMain">
        <!-- زر المخطط البياني -->
        <button class="chart-fab" title="عرض المخطط البياني" onclick="showChartModal()">
            <i class="fas fa-chart-bar"></i>
        </button>
        <h1><i class="fa fa-home"></i> لوحة تحكم نظام الصيدلية الذكي</h1>
        <div class="dash-links">
            <div class="dash-card cashier" onclick="window.location='cashier.php'">
                <div class="card-icon"><i class="fas fa-cash-register"></i></div>
                <span>الكاشير</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card sales" onclick="window.location='sales_report.php'">
                <div class="card-icon"><i class="fas fa-chart-line"></i></div>
                <span>تقارير المبيعات</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card meds" onclick="window.location='medicines.php'">
                <div class="card-icon"><i class="fas fa-pills"></i></div>
                <span>إدارة الأدوية</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card supplier protected-card" onclick="pwShow('suppliers.php')">
                <div class="card-icon"><i class="fas fa-truck-loading"></i></div>
                <span>ديون الموردين</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card customer protected-card" onclick="pwShow('https://mosul.pw/pharmacy/debtors.php')">
                <div class="card-icon"><i class="fas fa-user-clock"></i></div>
                <span>ديون الزبائن</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card rep protected-card" onclick="pwShow('https://mosul.pw/shop/all_offers.php')">
                <div class="card-icon"><i class="fas fa-hand-holding-usd"></i></div>
                <span>عروض المندوبين</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card reference" onclick="window.location='https://mosul.pw/pharmacy/purchase_return.php'">
                <div class="card-icon"><i class="fas fa-book-medical"></i></div>
                <span>المرجع للمذاخر</span>
                <div class="enter-link">دخول</div>
            </div>
            <div class="dash-card link" onclick="copyRepOfferLink()">
                <div class="card-icon"><i class="fas fa-link"></i></div>
                <span>انسخ رابط المندوب</span>
                <div class="enter-link">نسخ الرابط</div>
            </div>
        </div>
    </div>
    <!-- نافذة المخطط البياني -->
    <div class="dashboard-chart-modal" id="chartModal">
        <div class="dashboard-chart-box">
            <button class="close-chart-btn" onclick="closeChartModal()" title="إغلاق"><i class="fas fa-times"></i></button>
            <div class="dashboard-chart-title">
                إحصائيات المبيعات اليومية
            </div>
            <div class="dashboard-chart-desc">
                مبيعات الأيام السبعة الأخيرة (دينار)
            </div>
            <canvas id="salesChart" height="210"></canvas>
        </div>
    </div>
    <!-- نافذة كلمة المرور -->
    <div class="pw-modal" id="pwModal">
        <div class="pw-modal-content">
            <span style="font-weight:bold;font-size:1.13rem;">ادخل كلمة المرور للمتابعة</span>
            <input type="password" id="pwInput" placeholder="كلمة المرور" onkeydown="if(event.key==='Enter'){pwCheck();}">
            <div id="pwError" class="err-msg" style="display:none;"></div>
            <div style="display:flex;justify-content:center;gap:7px;">
                <button onclick="pwCheck()">تأكيد</button>
                <button class="close-btn" onclick="pwHide()">إغلاق</button>
            </div>
        </div>
    </div>
    <!-- رسالة النسخ -->
    <div id="copyMsg">تم نسخ الرابط!</div>
    <script>
        // الرسالة الترحيبية
        window.onload = function(){
            var welcome = document.getElementById('welcomeOverlay');
            var main    = document.getElementById('dashMain');
            welcome.classList.add('show');
            setTimeout(function(){
                welcome.classList.remove('show');
                welcome.style.display = 'none';
                main.classList.remove('hide');
            }, 2100);
        };

        // كود الحماية للباسورد
        let pwModal      = document.getElementById('pwModal');
        let pwInput      = document.getElementById('pwInput');
        let pwError      = document.getElementById('pwError');
        let pwRedirectTo = '';

        function pwShow(link){
            pwRedirectTo = link;
            pwModal.classList.add('active');
            pwError.style.display = 'none';
            pwInput.value = '';
            setTimeout(function(){pwInput.focus();}, 150);
        }
        function pwHide(){
            pwModal.classList.remove('active');
            pwInput.value = '';
            pwError.style.display = 'none';
        }
        function pwCheck(){
            let pw = pwInput.value.trim();
            if (pw === '1997') {
                window.location = pwRedirectTo;
            } else {
                pwError.innerText = "كلمة المرور غير صحيحة!";
                pwError.style.display = 'block';
                pwInput.value = '';
                pwInput.focus();
            }
        }

        // نسخ رابط المندوب
        function copyRepOfferLink() {
            var link = "https://mosul.pw/shop/rep_offers.php";
            if (navigator.clipboard) {
                navigator.clipboard.writeText(link).then(function() {
                    showCopyMsg();
                }, function() {
                    fallbackCopyTextToClipboard(link);
                });
            } else {
                fallbackCopyTextToClipboard(link);
            }
        }
        function fallbackCopyTextToClipboard(text) {
            var textArea = document.createElement("textarea");
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();
            try {
                var successful = document.execCommand('copy');
                showCopyMsg();
            } catch (err) {}
            document.body.removeChild(textArea);
        }
        function showCopyMsg() {
            var el = document.getElementById("copyMsg");
            el.style.display = 'block';
            setTimeout(function(){ el.style.display = 'none'; }, 1600);
        }

        // نافذة المخطط البياني
        function showChartModal() {
            document.getElementById('chartModal').classList.add('active');
            setTimeout(drawSalesChart, 80); // تأخير صغير لرسم الشارت بعد الظهور
        }
        function closeChartModal() {
            document.getElementById('chartModal').classList.remove('active');
        }

        // رسم الشارت عند الفتح فقط
        var salesChartInstance = null;
        function drawSalesChart() {
            var labels = <?= json_encode($sales_labels) ?>;
            var salesData = <?= json_encode($sales_values) ?>;
            var ctx = document.getElementById('salesChart').getContext('2d');
            if (salesChartInstance) salesChartInstance.destroy();

            salesChartInstance = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: 'المبيعات اليومية',
                        data: salesData,
                        borderWidth: 3,
                        backgroundColor: function(context) {
                            const gradient = context.chart.ctx.createLinearGradient(0, 0, 0, 240);
                            gradient.addColorStop(0, '#1976d2');
                            gradient.addColorStop(1, '#43a047');
                            return gradient;
                        },
                        borderColor: '#1976d2',
                        hoverBackgroundColor: '#43a047',
                        borderRadius: 13,
                        maxBarThickness: 38,
                    }]
                },
                options: {
                    responsive: true,
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return " " + context.parsed.y + " دينار";
                                }
                            }
                        },
                        datalabels: {
                            display: true,
                            color: "#1976d2",
                            anchor: "end",
                            align: "start",
                            font: { weight: "bold", size: 14 },
                            formatter: function(value) { return value > 0 ? value : ""; }
                        }
                    },
                    scales: {
                        x: { title: { display: true, text: 'اليوم', font: {size:15} } },
                        y: { title: { display: true, text: 'المبيعات', font: {size:15} }, beginAtZero:true }
                    }
                },
                plugins: [ChartDataLabels]
            });
        }
    </script>
    <!-- Chart.js مع DataLabels plugin لإظهار الأرقام فوق الأعمدة -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2"></script>
</body>
</html>
