<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include('config.php');

// البحث
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$where = '';
if ($search != '') {
    $search_sql = mysqli_real_escape_string($conn, $search);
    $where = "WHERE name LIKE '%$search_sql%' OR barcode LIKE '%$search_sql%'";
}

$sql = "SELECT * FROM medicines $where ORDER BY id DESC";
$res = mysqli_query($conn, $sql);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إدارة الأدوية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif;}
        .container {max-width: 1100px; margin: 40px auto;}
        h1 {text-align: center; color: #1976d2;}
        .actions {margin-bottom: 20px; text-align: left;}
        /* زر إضافة دواء */
        .n-btn {
            display: inline-flex;
            align-items: center;
            gap: 7px;
            padding: 9px 21px;
            background: linear-gradient(90deg,#e2fbea 80%,#f4fefd 100%);
            color: #089058;
            border: 1.7px solid #7ad9a4;
            border-radius: 10px;
            font-weight: bold;
            font-size: 1.09rem;
            text-decoration: none;
            cursor: pointer;
            transition: background .18s, box-shadow .18s, color .13s, border .13s;
            box-shadow: 0 2px 8px #e3eefd3d;
            margin: 3px 2px 0 0;
            min-width: 40px;
        }
        .n-btn svg {
            vertical-align: middle;
            margin-bottom: 1px;
        }
        .n-btn:hover {
            background: linear-gradient(90deg,#c7f7d6 80%,#e9faf2 100%);
            color:#056138;
            border-color: #089058;
            box-shadow: 0 8px 30px #08905823;
            text-decoration: none;
        }
        /* أزرار العمليات */
        .m-btn {
            display: inline-flex;
            align-items: center;
            gap: 3px;
            padding: 6px 13px;
            border: 1.4px solid #b6cced;
            border-radius: 7px;
            font-weight: bold;
            font-size: .98rem;
            text-decoration: none;
            cursor: pointer;
            transition: background .13s, box-shadow .15s, color .13s, border .13s;
            box-shadow: 0 1px 7px #e3eefd1c;
            margin: 2px;
        }
        .m-btn svg {vertical-align: middle;}
        .m-btn.edit  {background:linear-gradient(90deg,#f4f1fe 80%,#eaf1fb 100%);color:#883ec9;border-color:#be9fff;}
        .m-btn.edit:hover {background:linear-gradient(90deg,#ebe1fc 80%,#f2e9fe 100%);color:#6400ad;}
        .m-btn.del   {background:linear-gradient(90deg,#ffebee 80%,#fff3f7 100%);color:#d32f2f;border-color:#fdc6c6;}
        .m-btn.del:hover {background:linear-gradient(90deg,#ffdadf 80%,#ffe6ec 100%);color:#900707;}
        .m-btn.buy   {background:linear-gradient(90deg,#e5f7ff 80%,#f3fbff 100%);color:#0288d1;border-color:#a4e0fa;}
        .m-btn.buy:hover {background:linear-gradient(90deg,#cbefff 80%,#e2f6ff 100%);color:#015378;}
        /* زر بحث */
        .m-btn.search {
            background: linear-gradient(90deg,#f3faee 80%,#f7fbfd 100%);
            color: #43a047;
            border-color: #a4e0fa;
        }
        .m-btn.search:hover {
            background: linear-gradient(90deg,#e3f7e7 80%,#eaf5f2 100%);
            color: #21892f;
        }
        /* زر الباركود */
        .m-btn.barcode {
            background: linear-gradient(90deg,#fffde4 80%,#fefae2 100%);
            color: #d4a607;
            border-color: #ffe066;
        }
        .m-btn.barcode:hover {
            background: linear-gradient(90deg,#fff8bc 80%,#fff7b0 100%);
            color: #a87b05;
        }
        /* باقي تنسيقات الجدول */
        .search-box {margin-bottom: 20px; text-align: right; position:relative;}
        input[type="text"] {padding: 8px; border-radius: 5px; border: 1px solid #bbb; font-size:1rem;}
        table {width: 100%; border-collapse: collapse; background: #fff;}
        th, td {padding: 10px; text-align: center; border-bottom: 1px solid #e3e3e3;}
        th {background: #eaf1fb;}
        tr:hover {background: #f6fbff;}
        #search-reader {display:none;position:absolute;top:48px;right:0;left:0;z-index:10;background:#fff;border-radius:14px;box-shadow:0 4px 24px #cde9f366;}
        @media(max-width: 650px){
            .container{padding:2px;}
            th,td{padding:5px;font-size:.98rem;}
            .n-btn{padding:7px 10px;font-size:.96rem;}
            .m-btn{padding:5px 7px;font-size:.94rem;}
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إدارة الأدوية</h1>
        <div class="actions">
            <a href="medicine_add.php" class="n-btn">
                <svg width="19" height="19" viewBox="0 0 20 20"><path d="M10 4v12M4 10h12" stroke="#089058" stroke-width="2" stroke-linecap="round"/></svg>
                إضافة دواء جديد
            </a>
        </div>
        <!-- نموذج البحث مع زر الباركود -->
        <form method="get" class="search-box" autocomplete="off">
            <input type="text" id="search-input" name="search" placeholder="بحث بالاسم أو الباركود" value="<?= htmlspecialchars($search) ?>">
            <button type="button" class="m-btn barcode" id="barcode-scan-btn" title="بحث بالباركود">
                <svg width="17" height="17" viewBox="0 0 20 20"><rect x="2.5" y="5" width="15" height="10" rx="3" fill="none" stroke="#d4a607" stroke-width="1.4"/><rect x="7" y="8" width="2" height="4" rx="1" fill="#d4a607"/><rect x="11" y="8" width="2" height="4" rx="1" fill="#d4a607"/></svg>
                باركود
            </button>
            <button type="submit" class="m-btn search" style="margin-right:2px;">
                <svg width="16" height="16" viewBox="0 0 20 20"><circle cx="9" cy="9" r="6" stroke="#43a047" stroke-width="1.7" fill="none"/><path d="M15 15l-3-3" stroke="#43a047" stroke-width="1.7" stroke-linecap="round"/></svg>
                بحث
            </button>
            <div id="search-reader"></div>
        </form>
        <table>
            <tr>
                <th>الباركود</th>
                <th>اسم الدواء</th>
                <th>التصنيف</th>
                <th>السعر</th>
                <th>الكمية</th>
                <th>تاريخ الانتهاء</th>
                <th>خيارات</th>
            </tr>
            <?php if ($res && mysqli_num_rows($res) > 0): ?>
                <?php while($row = mysqli_fetch_assoc($res)): ?>
                <tr>
                    <td><?= htmlspecialchars($row['barcode']) ?></td>
                    <td><?= htmlspecialchars($row['name']) ?></td>
                    <td><?= htmlspecialchars($row['category']) ?></td>
                    <td><?= htmlspecialchars($row['price']) ?></td>
                    <td><?= htmlspecialchars($row['quantity']) ?></td>
                    <td><?= htmlspecialchars($row['expiry_date']) ?></td>
                    <td>
                        <a href="medicine_edit.php?id=<?= $row['id'] ?>" class="m-btn edit" title="تعديل">
                            <svg width="16" height="16" viewBox="0 0 20 20"><path d="M4 13.5V16h2.5l7.08-7.08a1.5 1.5 0 0 0-2.12-2.12L4 13.5zm11.29-7.79a1 1 0 0 1 0 1.41l-1.5 1.5a1 1 0 1 1-1.41-1.41l1.5-1.5a1 1 0 0 1 1.41 0z" fill="#883ec9"/></svg>
                            تعديل
                        </a>
                        <a href="medicine_delete.php?id=<?= $row['id'] ?>" class="m-btn del" onclick="return confirm('تأكيد الحذف؟');" title="حذف">
                            <svg width="16" height="16" viewBox="0 0 20 20"><path d="M6 8v6M10 8v6m4-6v6M4 6h12" stroke="#d32f2f" stroke-width="1.2" stroke-linecap="round"/><rect x="5" y="6" width="10" height="10" rx="2" fill="none" stroke="#d32f2f" stroke-width="1"/></svg>
                            حذف
                        </a>
                        <!-- إذا عندك زر شراء أو إضافة كمية أو طباعة ضع زر مشابه هنا -->
                    </td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7">لا توجد أدوية حالياً.</td>
                </tr>
            <?php endif; ?>
        </table>
    </div>

    <!-- سكربت تشغيل الكاميرا والبحث -->
    <script>
    const barcodeBtn = document.getElementById('barcode-scan-btn');
    const readerDiv = document.getElementById('search-reader');
    const searchInput = document.getElementById('search-input');
    let scannerOn2 = false;
    let html5QrCode2;

    barcodeBtn.onclick = function () {
        if (!scannerOn2) {
            readerDiv.style.display = 'block';
            barcodeBtn.textContent = 'إيقاف الكاميرا';
            scannerOn2 = true;
            html5QrCode2 = new Html5Qrcode("search-reader");
            html5QrCode2.start(
                { facingMode: "environment" },
                { fps: 10, qrbox: { width: 250, height: 80 } },
                barcode => {
                    searchInput.value = barcode;
                    html5QrCode2.stop().then(() => {
                        readerDiv.style.display = 'none';
                        barcodeBtn.textContent = 'باركود';
                        scannerOn2 = false;
                        // أرسل الفورم مباشرة للبحث
                        searchInput.form.submit();
                    });
                },
                errorMessage => {
                    // تجاهل الأخطاء الطفيفة
                }
            );
        } else {
            html5QrCode2.stop().then(() => {
                readerDiv.style.display = 'none';
                barcodeBtn.textContent = 'باركود';
                scannerOn2 = false;
            });
        }
    };
    </script>
</body>
</html>
