<?php
session_start();
include('config.php');
if (!isset($_SESSION['user_id'])) header('Location: login.php');

$error = '';
$success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $medicine_name = trim($_POST['medicine_name']);
    $company_name  = trim($_POST['company_name']);
    $medicine_type = trim($_POST['medicine_type']);
    $custom_type   = trim($_POST['custom_type']);
    $quantity      = intval($_POST['quantity']);
    $rep_number    = trim($_POST['rep_number']);
    $rep_name      = trim($_POST['rep_name']);
    $offer         = trim($_POST['offer']);
    $offer_date    = $_POST['offer_date'];
    $notes         = trim($_POST['notes']);

    if ($medicine_name && $company_name && $medicine_type && $quantity > 0 && $rep_number && $rep_name && $offer) {
        $type_to_save = ($medicine_type === 'أخرى' && $custom_type) ? $custom_type : $medicine_type;
        $stmt = $conn->prepare("INSERT INTO medicine_reps
            (medicine_name, company_name, medicine_type, custom_type, quantity, rep_number, rep_name, offer, notes, offer_date)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param('ssssisssss', $medicine_name, $company_name, $medicine_type, $custom_type, $quantity, $rep_number, $rep_name, $offer, $notes, $offer_date);
        $stmt->execute();
        $success = "تم تسجيل العرض بنجاح.";
    } else {
        $error = "يرجى تعبئة جميع الحقول الضرورية!";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة عرض مندوب للصيدلية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body {font-family:'Cairo',Arial,sans-serif;background:#f7fbfd;}
        .box {max-width:440px;margin:40px auto;background:#fff;border-radius:18px;box-shadow:0 4px 18px #dde7fc78;padding:28px;}
        label {font-weight:bold;}
        input,select,textarea {width:100%;margin-bottom:15px;padding:9px;border-radius:7px;border:1px solid #b4c8ed;font-size:1rem;}
        .btn {background:#1976d2;color:#fff;border:none;border-radius:9px;padding:12px;width:100%;font-weight:bold;cursor:pointer;}
        .msg {text-align:center;}
        .msg.success{color:#43a047;}
        .msg.error{color:#d32f2f;}
        #custom-type-row {display:none;}
    </style>
    <script>
        function showCustomType(sel){
            document.getElementById('custom-type-row').style.display = (sel.value === 'أخرى') ? 'block' : 'none';
        }
    </script>
</head>
<body>
<div class="box">
    <h2 style="text-align:center;color:#1976d2;">تسجيل عرض/توزيع مندوب</h2>
    <?php if($success): ?><div class="msg success"><?= $success ?></div><?php endif; ?>
    <?php if($error): ?><div class="msg error"><?= $error ?></div><?php endif; ?>
    <form method="post">
        <label>اسم الدواء</label>
        <input type="text" name="medicine_name" required>
        
        <label>اسم الشركة</label>
        <input type="text" name="company_name" required>

        <label>نوع الدواء</label>
        <select name="medicine_type" required onchange="showCustomType(this)">
            <option value="">اختر النوع...</option>
            <option>كبسول</option>
            <option>حب</option>
            <option>شراب</option>
            <option>تحميلة</option>
            <option>إبرة</option>
            <option>أخرى</option>
        </select>
        <div id="custom-type-row">
            <label>اذكر نوع الدواء</label>
            <input type="text" name="custom_type">
        </div>
        
        <label>الكمية</label>
        <input type="number" name="quantity" required min="1">
        
        <label>رقم المندوب</label>
        <input type="text" name="rep_number" required>
        
        <label>اسم المندوب</label>
        <input type="text" name="rep_name" required>
        
        <label>العرض المقدم من قبل المندوب</label>
        <input type="text" name="offer" required>
        
        <label>تاريخ العرض/التوزيع</label>
        <input type="date" name="offer_date" value="<?= date('Y-m-d') ?>" required>
        
        <label>ملاحظات (اختياري)</label>
        <textarea name="notes" rows="2"></textarea>
        <button type="submit" class="btn">تسجيل العرض</button>
    </form>
</div>
</body>
</html>
