<?php
include('config.php');
$offers = mysqli_query($conn, "SELECT * FROM offers ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جميع عروض المندوبين</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600;800&display=swap" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <style>
        body { font-family: 'Cairo', Arial, sans-serif; background: #eef4fa; }
        .container { max-width: 1000px; margin: 40px auto; background: #fff; border-radius: 26px; box-shadow: 0 8px 32px #dbe7f380; padding: 36px 24px; }
        h2 { text-align: center; color: #1769aa; font-weight: 800; margin-bottom: 30px; letter-spacing: 1px; }
        table { width: 100%; border-collapse: collapse; margin-top: 14px; background: #f9fcff; border-radius: 12px; overflow: hidden; }
        th, td { padding: 15px 10px; border-bottom: 1px solid #e0eaf5; text-align: center; font-size: 1.15rem; }
        th { background: #1769aa; color: #fff; font-weight: bold; }
        tr:last-child td { border-bottom: none; }
        .btn-details, .btn-delete {
            background: linear-gradient(90deg, #2196f3 60%, #1769aa 100%);
            color: #fff;
            border: none;
            padding: 7px 22px;
            border-radius: 9px;
            font-size: 1.05em;
            cursor: pointer;
            transition: 0.2s;
            margin-left: 6px;
            box-shadow: 0 2px 8px #b3cbe84a;
        }
        .btn-delete {
            background: linear-gradient(90deg, #f44336 60%, #ab1b1b 100%);
        }
        .btn-details:hover { background: #1976d2; }
        .btn-delete:hover { background: #d32f2f; }
        /* Modal (نافذة التفاصيل) */
        .modal { display: none; position: fixed; z-index: 99; left: 0; top: 0; width: 100%; height: 100%; background: rgba(24,29,56,0.12); }
        .modal-content { background: #fff; margin: 90px auto; padding: 32px; border-radius: 20px; width: 400px; max-width: 95%; box-shadow: 0 10px 40px #cfd8dc50; position: relative; }
        .close { position: absolute; top: 14px; left: 22px; font-size: 28px; color: #1976d2; font-weight: bold; cursor: pointer; }
        .modal-content h3 { margin-bottom: 20px; color: #1769aa;}
        .modal-content p { margin: 9px 0; font-size: 1.03em; color: #222;}
        /* رسالة نجاح الحذف */
        .deleted-msg { background: #b6e1c2; color: #195b26; border-radius: 9px; padding: 10px 0; text-align: center; margin-bottom: 18px; font-weight: bold; font-size: 1.12em; }
        @media(max-width: 650px){
            .container {padding: 7px 3px;}
            th, td { font-size: .95rem;}
        }
    </style>
    <script>
        function showDetails(id) {
            $('#modal_'+id).fadeIn(200);
        }
        function closeModal(id) {
            $('#modal_'+id).fadeOut(200);
        }

        function deleteOffer(id, rowId) {
            if(confirm('هل أنت متأكد من حذف هذا العرض؟')) {
                $.ajax({
                    url: 'delete_offer.php',
                    type: 'POST',
                    data: { offer_id: id },
                    success: function(response) {
                        if(response.trim() === 'deleted') {
                            $('#row_'+rowId).fadeOut(300, function() { $(this).remove(); });
                            $('#deleted_msg').show().delay(1500).fadeOut();
                        } else {
                            alert('حدث خطأ أثناء الحذف');
                        }
                    }
                });
            }
        }
    </script>
</head>
<body>
<div class="container">
    <h2>جميع عروض المندوبين</h2>
    <div id="deleted_msg" class="deleted-msg" style="display:none;">تم حذف العرض بنجاح!</div>
    <table>
        <tr>
            <th>المندوب</th>
            <th>الشركة</th>
            <th>اسم المنتج</th>
            <th>السعر</th>
            <th>الخيارات</th>
        </tr>
        <?php $rowId = 0; while ($row = mysqli_fetch_assoc($offers)) { $rowId++; ?>
        <tr id="row_<?=$rowId?>">
            <td><?= htmlspecialchars($row['rep_name']) ?></td>
            <td><?= htmlspecialchars($row['company']) ?></td>
            <td><?= htmlspecialchars($row['product_name']) ?></td>
            <td><?= htmlspecialchars($row['price']) ?></td>
            <td>
                <button class="btn-details" onclick="showDetails(<?= $row['id'] ?>)">تفاصيل</button>
                <button class="btn-delete" onclick="deleteOffer(<?= $row['id'] ?>, <?=$rowId?>)">حذف</button>
                <!-- Modal Details -->
                <div id="modal_<?= $row['id'] ?>" class="modal">
                    <div class="modal-content">
                        <span class="close" onclick="closeModal(<?= $row['id'] ?>)">&times;</span>
                        <h3><?= htmlspecialchars($row['product_name']) ?></h3>
                        <p><b>المندوب:</b> <?= htmlspecialchars($row['rep_name']) ?></p>
                        <p><b>الهاتف:</b> <?= htmlspecialchars($row['phone']) ?></p>
                        <p><b>الشركة:</b> <?= htmlspecialchars($row['company']) ?></p>
                        <p><b>السعر:</b> <?= htmlspecialchars($row['price']) ?></p>
                        <p><b>ملاحظات/عرض:</b> <?= nl2br(htmlspecialchars($row['notes'])) ?></p>
                    </div>
                </div>
            </td>
        </tr>
        <?php } ?>
    </table>
</div>
</body>
</html>
