<?php
include('config.php');

// جلب المنتجات من قاعدة البيانات مع أسعار البيع
$products = [];
$res = mysqli_query($conn, "SELECT * FROM products");
while ($row = mysqli_fetch_assoc($res)) $products[] = $row;

// معالجة عملية البيع
$msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['product_id'], $_POST['pack_type'], $_POST['qty'], $_POST['sell_price'])) {
    $product_id = intval($_POST['product_id']);
    $pack_type  = $_POST['pack_type'];
    $qty        = intval($_POST['qty']);
    $sell_price = floatval($_POST['sell_price']);
    $total      = $qty * $sell_price;

    // جلب معلومات المنتج والمخزون
    $prod_res = mysqli_query($conn, "SELECT stock, cartons_available, carton_qty FROM products WHERE id=$product_id");
    $prod_row = mysqli_fetch_assoc($prod_res);

    $enough = false;
    if ($pack_type === 'carton') {
        if ($prod_row['cartons_available'] >= $qty) $enough = true;
    } else {
        if ($prod_row['stock'] >= $qty) $enough = true;
    }

    if (!$enough) {
        $msg = "<div class='toast toast-error'>المخزون غير كافٍ!</div>";
    } else {
        // 1. تسجيل الفاتورة في جدول sales
        $now = date('Y-m-d H:i:s');
        $sale_type = $pack_type === 'carton' ? 'wholesale' : 'retail';
        mysqli_query($conn, "INSERT INTO sales (total, paid, sale_type, created_at) VALUES ($total, $total, '$sale_type', '$now')");
        $sale_id = mysqli_insert_id($conn);

        // 2. تسجيل تفاصيل البيع في جدول sales_items
        mysqli_query($conn, "INSERT INTO sales_items (sale_id, product_id, qty, unit_price, total, sale_type, pack_type) 
                             VALUES ($sale_id, $product_id, $qty, $sell_price, $total, '$sale_type', '$pack_type')");

        // 3. خصم المخزون
        if ($pack_type === 'carton') {
            $pcs = $qty * $prod_row['carton_qty'];
            mysqli_query($conn, "UPDATE products SET cartons_available = cartons_available - $qty, stock = stock - $pcs WHERE id = $product_id");
        } else {
            mysqli_query($conn, "UPDATE products SET stock = stock - $qty WHERE id = $product_id");
        }
        $msg = "<div class='toast toast-success'>تمت عملية البيع وتسجيلها بنجاح.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>الكاشير - بيع منتج</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    <style>
        body {background: linear-gradient(135deg, #e8f0fe 0%, #f4fcfa 100%);font-family: 'Cairo', Arial, sans-serif;margin: 0;}
        .container {max-width: 950px;margin: 32px auto 0 auto;background: #fff;border-radius: 32px;box-shadow: 0 7px 28px #a8baf340;padding: 30px 18px 22px 18px;position: relative;transition: box-shadow 0.2s;}
        .header {text-align: center;margin-bottom: 17px;}
        .header h2 {color: #1976d2;font-size: 2.1rem;margin: 0 0 8px 0;letter-spacing: 0.7px;}
        .header .sub {color: #888;font-size: 1.05rem;margin-top: 3px;}
        .barcode-section {max-width: 650px;margin: 0 auto 18px auto;padding: 8px 0;}
        .barcode-box {background: linear-gradient(90deg,#1572d1 70%,#25c3a2 100%);border-radius: 13px;padding: 18px 18px 10px 18px;margin-bottom: 2px;display:flex;flex-direction:column;align-items:center;}
        .barcode-icon {font-size: 2.6rem;color: #1976d2;margin-bottom: 4px;text-align:center;}
        .barcode-row {display:flex;align-items:center;gap:5px;width:100%;justify-content:center;}
        #barcodeInput {font-size: 1.4rem;padding: 13px 19px;border:1.5px solid #c1e0fc;border-radius: 9px;width: 300px;text-align:center;background: #eef5fd;}
        .barcode-btn {background: #1572d1;border: none;color: #fff;font-size: 1.35rem;padding: 13px 16px 13px 16px;border-radius: 8px;cursor:pointer;transition: background 0.17s;}
        .barcode-btn:hover {background:#0a5ea8;}
        #barcodeMsg {color:#d71c1c;font-weight:600;margin:4px 0 9px 0;text-align:center;}
        .camera-actions {display:flex;gap:10px;margin: 13px 0;}
        .camera-actions button {flex:1;}
        #barcodeCamera {display:none;width: 100%;max-width:410px;margin:0 auto;border-radius:12px;overflow:hidden;}
        .camera-btn {padding:13px 0;background:linear-gradient(90deg,#1572d1 60%,#25c3a2 100%);border:none;color:#fff;font-weight:700;border-radius:8px;cursor:pointer;font-size:1.11rem;transition:0.17s;}
        .camera-btn:disabled {opacity:0.5;cursor:not-allowed;}
        .camera-btn.red {background: #d72929;}
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(190px, 1fr));
            gap: 22px;
            margin-bottom: 35px;
        }
        .product-card {
            background: #f7fafd;
            border-radius: 18px;
            box-shadow: 0 3px 18px #1976d215;
            padding: 19px 10px 13px 10px;
            text-align: center;
            cursor: pointer;
            border: 2.5px solid transparent;
            transition: border 0.16s, transform 0.09s;
            position: relative;
        }
        .product-card.selected,
        .product-card:hover {
            border: 2.5px solid #1976d2;
            box-shadow: 0 7px 22px #1976d215;
            transform: scale(1.03);
        }
        .product-img {
            font-size: 2.7rem;
            color: #32c49d;
            margin-bottom: 11px;
        }
        .product-name {
            font-size: 1.22rem;
            font-weight: bold;
            color: #222;
            margin-bottom: 6px;
        }
        .product-stats {
            font-size: 1rem;
            color: #1976d2;
            margin-bottom: 7px;
        }
        .product-prices {
            font-size: 0.98rem;
            color: #5d6c7b;
            margin-bottom: 2px;
            display: flex;
            flex-direction: column;
            gap: 1px;
        }
        /* --- نموذج البيع الاحترافي --- */
        .sell-form-section {
            max-width: 400px;
            margin: 24px auto 0 auto;
            background: #f4fafd;
            border-radius: 22px;
            box-shadow: 0 2px 14px #7be2c63c;
            padding: 30px 21px 20px 21px;
            direction: rtl;
            transition: box-shadow 0.16s;
        }
        #selected_product_name {
            display: block;
            color: #1976d2;
            font-size: 1.32rem;
            font-weight: bold;
            letter-spacing: 1px;
            margin-bottom: 13px;
            text-align: center;
        }
        .radio-group {
            display: flex;
            justify-content: center;
            gap: 30px;
            margin-bottom: 16px;
            margin-top: 0;
        }
        .radio-group label {
            font-size: 1.1rem;
            color: #1976d2;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 6px;
        }
        .radio-group input[type="radio"] {
            accent-color: #1976d2;
            width: 21px;
            height: 21px;
        }
        .sell-form label {
            display: block;
            font-size: 1.03rem;
            font-weight: bold;
            color: #135882;
            margin-bottom: 6px;
            margin-top: 5px;
        }
        .input-icon {
            position: relative;
            margin-bottom: 18px;
        }
        .input-icon input {
            width: 100%;
            padding: 12px 40px 12px 12px;
            border-radius: 9px;
            border: 1.2px solid #b9e0f2;
            font-size: 1.14rem;
            background: #e9f7fb;
            transition: border 0.14s;
            outline: none;
        }
        .input-icon input:focus {
            border: 1.5px solid #1976d2;
            background: #f5fcff;
        }
        .input-icon .fa {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            color: #17b3a0;
            font-size: 1.17rem;
            opacity: 0.83;
        }
        /* تحسين شكل الكمية */
        .qty-group {
            display: flex;
            align-items: center;
            gap: 0;
            border: 1.2px solid #b9e0f2;
            border-radius: 9px;
            background: #e9f7fb;
            margin-bottom: 18px;
            padding: 0;
        }
        .qty-group input[type="number"] {
            border: none !important;
            background: transparent !important;
            width: 70px;
            text-align: center;
            font-size: 1.18rem;
            padding: 13px 0 !important;
            outline: none;
            box-shadow: none;
        }
        .qty-btn {
            background: none;
            border: none;
            color: #1976d2;
            font-size: 1.32rem;
            padding: 0 13px;
            height: 44px;
            cursor: pointer;
            transition: color 0.14s;
            user-select: none;
        }
        .qty-btn:hover { color: #1ac2a6;}
        /* حقل المجموع الكلي */
        #total_sell {
            background:#e8faef !important;
            color:#179157 !important;
            font-weight:bold;
            text-align:center;
            border:0 !important;
            font-size:1.25rem !important;
            letter-spacing: 1.5px;
        }
        #stock_info {
            color: #109276;
            font-size: 1.09rem;
            margin: 6px 0 14px 0;
            text-align: left;
            padding-left: 4px;
        }
        .sell-form button[type="submit"] {
            width: 100%;
            background: linear-gradient(91deg, #1976d2 78%, #20bb98 100%);
            color: #fff;
            border: 0;
            padding: 14px 0;
            border-radius: 11px;
            font-size: 1.18rem;
            font-weight: bold;
            box-shadow: 0 2px 14px #1976d255;
            margin-top: 8px;
            margin-bottom: 4px;
            cursor: pointer;
            transition: background 0.16s, transform 0.08s;
        }
        .sell-form button[type="submit"]:hover {
            background: linear-gradient(91deg, #1353a6 78%, #11937a 100%);
            transform: translateY(-2px) scale(1.016);
        }
        .toast {display: block;width: 100%;margin: 0 auto 14px auto;text-align: center;padding: 13px 5px;border-radius: 11px;font-size: 1.13rem;font-weight: 600;position: relative;animation: fadein 0.9s;}
        .toast-success { background: #daf7e3; color: #2b7a5a; border:1.5px solid #2ccaa55e;}
        .toast-error   { background: #fff2f0; color: #ce2b2b; border:1.5px solid #ce2b2b3b;}
        @keyframes fadein {from { opacity: 0; transform: translateY(-18px);}to   { opacity: 1; transform: none;}}
        @media (max-width: 1050px) {.container { max-width: 99vw;}}
        @media (max-width: 700px) {.container { padding: 10px 2px 8px 2px;}.products-grid{gap:10px;}}
        @media (max-width: 500px) {.product-name { font-size: 1.03rem; } .header h2 { font-size: 1.2rem; } }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <h2><i class="fa fa-cash-register"></i> الكاشير</h2>
        <div class="sub">بيع المنتجات بسرعة وسهولة</div>
    </div>
    <div class="barcode-section">
        <div class="barcode-box">
            <div class="barcode-icon"><i class="fa fa-barcode"></i></div>
            <div class="barcode-row">
                <button id="barcodeSearchBtn" class="barcode-btn"><i class="fa fa-search"></i></button>
                <input id="barcodeInput" placeholder="أدخل الباركود أو امسح بالكاميرا" autocomplete="off">
            </div>
            <div id="barcodeMsg"></div>
        </div>
        <div class="camera-actions">
            <button type="button" class="camera-btn" id="startCameraBtn"><i class="fa fa-camera"></i> تشغيل الكاميرا للباركود</button>
            <button type="button" class="camera-btn red" id="stopCameraBtn" style="display:none;"><i class="fa fa-times"></i> إيقاف الكاميرا!</button>
        </div>
        <div id="barcodeCamera"></div>
    </div>
    <?php if ($msg) echo $msg; ?>

    <div class="products-grid" id="productsGrid">
        <!-- المنتجات تظهر هنا -->
    </div>

    <!-- نموذج البيع (يظهر بعد اختيار المنتج) -->
    <div id="sellFormSection" class="sell-form-section" style="display:none;">
        <form method="post" class="sell-form" autocomplete="off" id="sellForm">
            <input type="hidden" name="product_id" id="selected_product_id">
            <span id="selected_product_name"></span>
            <div class="radio-group">
                <label>
                    <input type="radio" name="pack_type" value="carton" checked onchange="updateSellForm();"> كارتون
                </label>
                <label>
                    <input type="radio" name="pack_type" value="piece" onchange="updateSellForm();"> قطع
                </label>
            </div>

            <label>الكمية</label>
            <div class="input-icon qty-group">
                <button type="button" class="qty-btn" onclick="changeQty(-1)"><i class="fa fa-minus"></i></button>
                <input type="number" name="qty" min="1" value="1" required id="qty_input" oninput="calcTotalSell()" />
                <button type="button" class="qty-btn" onclick="changeQty(1)"><i class="fa fa-plus"></i></button>
                <i class="fa fa-sort-numeric-up"></i>
            </div>

            <label>سعر البيع</label>
            <div class="input-icon">
                <input type="number" id="sell_price" name="sell_price" min="0" step="0.01" value="0" required oninput="calcTotalSell()" />
                <i class="fa fa-dollar-sign"></i>
            </div>

            <label>المجموع الكلي</label>
            <div class="input-icon">
                <input type="text" id="total_sell" name="total_sell" readonly />
                <i class="fa fa-calculator"></i>
            </div>

            <div id="stock_info" class="stock-info"></div>
            <button type="submit"><i class="fa fa-cart-plus"></i> تنفيذ البيع</button>
        </form>
    </div>
</div>

<script>
    var productsData = <?php echo json_encode($products, JSON_UNESCAPED_UNICODE); ?>;
    var selectedId = null;

    function renderProductsGrid() {
        var grid = document.getElementById('productsGrid');
        grid.innerHTML = '';
        productsData.forEach(function(p){
            var card = document.createElement('div');
            card.className = 'product-card' + (selectedId == p.id ? ' selected' : '');
            card.setAttribute('data-id', p.id);
            card.onclick = function(){ selectProduct(p.id); };

            card.innerHTML =
                `<div class="product-img"><i class="fa fa-box-open"></i></div>
                 <div class="product-name">${p.name}</div>
                 <div class="product-stats">
                    <span><i class="fa fa-cubes"></i> ${p.cartons_available} كارتون</span> | 
                    <span><i class="fa fa-cube"></i> ${p.stock} قطعة</span>
                 </div>
                 <div class="product-prices">
                    <span>سعر الكارتون: <b>${p.carton_sell_price}</b></span>
                    <span>سعر القطعة: <b>${p.piece_sell_price}</b></span>
                 </div>`;
            grid.appendChild(card);
        });
    }

    function selectProduct(id) {
        selectedId = id;
        document.querySelectorAll('.product-card').forEach(function(card){
            card.classList.remove('selected');
        });
        var selectedCard = document.querySelector('.product-card[data-id="'+id+'"]');
        if(selectedCard) selectedCard.classList.add('selected');
        var prod = productsData.find(function(p){ return p.id == id; });
        if(!prod) return;
        document.getElementById('sellFormSection').style.display = 'block';
        document.getElementById('selected_product_id').value = id;
        document.getElementById('selected_product_name').innerText = prod.name;
        document.getElementById('qty_input').value = 1;
        document.querySelector('input[name="pack_type"][value="carton"]').checked = true;
        updateSellForm();
        window.scrollTo({top: document.getElementById('sellFormSection').offsetTop-60, behavior: 'smooth'});
        calcTotalSell();
    }

    function updateSellForm() {
        if(selectedId == null) return;
        var prod = productsData.find(function(p){ return p.id == selectedId; });
        if(!prod) return;
        var packType = document.querySelector('input[name="pack_type"]:checked').value;
        var priceInput = document.getElementById('sell_price');
        var stockInfo = document.getElementById('stock_info');
        if(packType === 'carton') {
            priceInput.value = prod.carton_sell_price || 0;
            stockInfo.innerHTML = '<i class="fa fa-cubes"></i> عدد الكراتين المتاحة: <b>' + (prod.cartons_available || 0) + '</b>';
        } else {
            priceInput.value = prod.piece_sell_price || 0;
            stockInfo.innerHTML = '<i class="fa fa-cube"></i> عدد القطع المتاحة: <b>' + (prod.stock || 0) + '</b>';
        }
        calcTotalSell();
    }

    function calcTotalSell() {
        var qty = parseFloat(document.getElementById('qty_input').value) || 0;
        var price = parseFloat(document.getElementById('sell_price').value) || 0;
        document.getElementById('total_sell').value = (qty * price).toFixed(2);
    }

    function changeQty(val) {
        var input = document.getElementById('qty_input');
        var v = parseInt(input.value) || 1;
        v += val;
        if (v < 1) v = 1;
        input.value = v;
        calcTotalSell();
    }
    document.getElementById('qty_input').addEventListener('input', calcTotalSell);
    document.getElementById('sell_price').addEventListener('input', calcTotalSell);

    // بحث المنتج بالباركود عبر إدخال يدوي أو زر البحث أو Enter
    function fetchBarcodeProduct(barcode) {
        if(!barcode) return;
        var xhr = new XMLHttpRequest();
        xhr.open('GET', 'find_product_by_barcode.php?barcode=' + encodeURIComponent(barcode), true);
        xhr.onload = function(){
            try {
                var data = JSON.parse(xhr.responseText);
                if(data.found) {
                    selectProduct(data.product_id);
                    document.getElementById('barcodeMsg').innerText = '';
                } else {
                    document.getElementById('barcodeMsg').innerText = 'المنتج غير موجود أو الباركود خطأ';
                }
            } catch(e) {
                document.getElementById('barcodeMsg').innerText = 'حدث خطأ في جلب البيانات';
            }
            document.getElementById('barcodeInput').value = '';
            document.getElementById('barcodeInput').focus();
        };
        xhr.onerror = function() {
            document.getElementById('barcodeMsg').innerText = 'تعذر الاتصال بالخادم';
        };
        xhr.send();
    }

    // عند الضغط على زر البحث أو إنتر
    document.getElementById('barcodeSearchBtn').onclick = function(e){
        e.preventDefault();
        var val = document.getElementById('barcodeInput').value.trim();
        fetchBarcodeProduct(val);
    };
    document.getElementById('barcodeInput').addEventListener('keydown', function(e){
        if(e.key === 'Enter'){
            e.preventDefault();
            var val = this.value.trim();
            fetchBarcodeProduct(val);
        }
    });

    // الكاميرا - html5-qrcode
    var cameraStarted = false;
    var html5QrcodeScanner = null;
    var cameraEl = document.getElementById("barcodeCamera");
    var startBtn = document.getElementById("startCameraBtn");
    var stopBtn = document.getElementById("stopCameraBtn");

    function stopCamera() {
        if(html5QrcodeScanner) {
            html5QrcodeScanner.stop().then(function(){
                cameraEl.style.display = "none";
                stopBtn.style.display = "none";
                startBtn.disabled = false;
                cameraStarted = false;
            }).catch(function(){});
        }
    }

    startBtn.onclick = function() {
        if(cameraStarted) return;
        if (!window.Html5Qrcode) {
            alert('الكاميرا غير مدعومة في هذا المتصفح!');
            return;
        }
        cameraEl.style.display = "block";
        stopBtn.style.display = "inline-block";
        startBtn.disabled = true;
        html5QrcodeScanner = new Html5Qrcode("barcodeCamera");
        html5QrcodeScanner.start(
            { facingMode: "environment" },
            { fps: 10, qrbox: 230 },
            function (decodedText, decodedResult) {
                document.getElementById('barcodeInput').value = decodedText;
                fetchBarcodeProduct(decodedText);
                stopCamera();
            },
            function (errorMessage) {
                // تجاهل الأخطاء
            }
        ).then(()=>{ cameraStarted = true; }).catch(()=> {
            cameraEl.style.display = "none";
            stopBtn.style.display = "none";
            startBtn.disabled = false;
            cameraStarted = false;
            alert('فشل في تشغيل الكاميرا');
        });
    };

    stopBtn.onclick = stopCamera;

    // تحديث المنتجات تلقائيا كل 5 ثواني
    function fetchProductsData() {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', 'fetch_products.php', true);
        xhr.onload = function() {
            if (xhr.status === 200) {
                productsData = JSON.parse(xhr.responseText);
                renderProductsGrid();
                if (selectedId) {
                    var prod = productsData.find(function(p){ return p.id == selectedId; });
                    if (prod) {
                        document.getElementById('selected_product_name').innerText = prod.name;
                        updateSellForm();
                    } else {
                        document.getElementById('sellFormSection').style.display = 'none';
                        selectedId = null;
                    }
                }
            }
        };
        xhr.send();
    }
    setInterval(fetchProductsData, 5000);

    renderProductsGrid();
</script>
</body>
</html>
