<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة التحكم الرئيسية</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free/css/all.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            background: linear-gradient(120deg, #e7efff 0%, #e0e9f6 100%);
            min-height: 100vh;
            font-family: 'Cairo', Arial, sans-serif;
            margin: 0;
        }
        .welcome-overlay {
            position: fixed;
            top: 0; left: 0; right: 0; bottom: 0;
            background: rgba(232, 250, 240, 0.95);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 5000;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.7s;
            font-family: 'Cairo', Arial, sans-serif;
        }
        .welcome-overlay.show {
            opacity: 1;
            pointer-events: all;
            transition: opacity 0.7s;
        }
        .welcome-msg {
            text-align: center;
            background: #fff;
            border-radius: 28px;
            padding: 45px 34px 38px 34px;
            box-shadow: 0 10px 45px #bbffe0b9;
            font-size: 2.2rem;
            color: #19844d;
            font-weight: bold;
            letter-spacing: 1px;
            position: relative;
            animation: welcomePop 1.2s cubic-bezier(.25,1.6,.38,1.09);
        }
        .welcome-msg span {
            display: block;
            font-size: 1.3rem;
            color: #1976d2;
            font-weight: 700;
            margin-top: 16px;
        }
        @keyframes welcomePop {
            0%   {transform: scale(0.6); opacity: 0;}
            70%  {transform: scale(1.09);}
            100% {transform: scale(1); opacity: 1;}
        }
        .dash-container {
            max-width: 860px;
            margin: 55px auto 0;
            background: #fff;
            border-radius: 28px;
            box-shadow: 0 9px 38px #dbe7f366;
            padding: 45px 22px 36px 22px;
            display: flex;
            flex-direction: column;
            align-items: center;
            opacity: 1;
            transition: opacity 0.5s;
        }
        .dash-container.hide { opacity: 0.2; pointer-events: none;}
        h1 {
            color: #1976d2;
            font-size: 2.3rem;
            margin-bottom: 36px;
            font-weight: 900;
            letter-spacing: 1.1px;
            text-shadow: 0 1px 10px #dbe7f355;
        }
        .dash-links {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 30px;
            width: 100%;
        }
        .dash-card {
            background: linear-gradient(130deg,#f3f8ff 50%,#f5fafd 100%);
            border-radius: 16px;
            box-shadow: 0 2px 12px #1976d21c;
            padding: 35px 18px 28px 18px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: box-shadow 0.13s, transform 0.13s;
            cursor: pointer;
            position: relative;
            text-align: center;
            user-select: none;
        }
        .dash-card:hover {
            box-shadow: 0 6px 26px #1976d249;
            transform: translateY(-6px) scale(1.025);
        }
        .dash-card i {
            font-size: 2.4rem;
            color: #1976d2;
            margin-bottom: 12px;
        }
        .dash-card span {
            font-size: 1.24rem;
            font-weight: bold;
            color: #252b38;
            margin-bottom: 8px;
        }
        .dash-card .enter-link {
            margin-top: 11px;
            display: inline-block;
            padding: 8px 26px;
            border-radius: 8px;
            background: #1976d2;
            color: #fff;
            font-weight: 700;
            font-size: 1.09rem;
            text-decoration: none;
            transition: background 0.15s;
            box-shadow: 0 2px 8px #1976d221;
        }
        .dash-card .enter-link:hover {
            background: #1353a6;
        }
        .pw-modal {
            display: none;
            position: fixed;
            right: 0; left: 0; top: 0; bottom: 0;
            background: #222c4362;
            align-items: center; justify-content: center;
            z-index: 90;
        }
        .pw-modal.active {display: flex;}
        .pw-modal-content {
            background: #fff;
            border-radius: 18px;
            padding: 28px 19px 18px 19px;
            min-width: 270px;
            box-shadow: 0 7px 38px #1976d257;
            display: flex; flex-direction: column; align-items: center;
        }
        .pw-modal input {
            margin-top: 6px;
            padding: 8px 10px;
            border-radius: 7px;
            border: 1.1px solid #b8bdd1;
            font-size: 1.12rem;
            width: 150px;
            text-align: center;
            margin-bottom: 12px;
        }
        .pw-modal button {
            padding: 7px 30px;
            border-radius: 8px;
            background: #1976d2;
            color: #fff;
            font-weight: 700;
            border: none;
            font-size: 1rem;
            margin-bottom: 5px;
        }
        .pw-modal .close-btn {
            background: #eee; color: #222; font-weight: bold; padding: 4px 16px; margin-bottom: 0;
            margin-top: 8px; border-radius: 6px; border: 1px solid #bbb;
        }
        .pw-modal .err-msg {color: #be001e; margin-bottom: 4px; font-size: 1rem;}
        /* رسالة النسخ */
        #copyMsg {
            display: none;
            position: fixed;
            top: 30px;
            left: 50%;
            transform: translateX(-50%);
            background: #1976d2;
            color: #fff;
            padding: 14px 30px;
            border-radius: 10px;
            font-size: 1.18em;
            z-index: 9999;
            box-shadow: 0 2px 20px #1976d279;
        }
        @media (max-width: 600px) {
            .welcome-msg {font-size: 1.2rem; padding: 24px 7px;}
            .dash-container {padding: 13px;}
            .dash-links {gap: 14px;}
            .dash-card {padding: 21px 5px 16px 5px;}
            h1 {font-size: 1.3rem;}
        }
    </style>
</head>
<body>
    <!-- رسالة ترحيب متحركة -->
    <div class="welcome-overlay" id="welcomeOverlay">
        <div class="welcome-msg">
            أهلاً بك في <br>
            <span>مخازن زياد العبيدي</span>
        </div>
    </div>

    <div class="dash-container hide" id="dashMain">
        <h1><i class="fa fa-home"></i> لوحة التحكم الرئيسية</h1>
        <div class="dash-links">

            <div class="dash-card" onclick="window.location='cashier.php'">
                <i class="fa fa-cash-register"></i>
                <span>الكاشير</span>
                <div class="enter-link">دخول</div>
            </div>

            <div class="dash-card" onclick="window.location='purchase_add.php'">
                <i class="fa fa-cart-plus"></i>
                <span>إضافة فاتورة شراء</span>
                <div class="enter-link">دخول</div>
            </div>

            <div class="dash-card" onclick="pwShow('suppliers.php')">
                <i class="fa fa-users"></i>
                <span>إدارة الموردين</span>
                <div class="enter-link">دخول</div>
            </div>

            <div class="dash-card" onclick="pwShow('report_products.php')">
                <i class="fa fa-chart-bar"></i>
                <span>تقرير المبيعات</span>
                <div class="enter-link">دخول</div>
            </div>

            <div class="dash-card" onclick="window.location='products.php'">
                <i class="fa fa-archive"></i>
                <span>المخزون (المنتجات)</span>
                <div class="enter-link">دخول</div>
            </div>

            <!-- بطاقة عروض المندوبين مع حماية كلمة المرور -->
            <div class="dash-card" onclick="pwShow('https://mosul.pw/shop/all_offers.php')">
                <i class="fa fa-handshake"></i>
                <span>عروض المندوبين</span>
                <div class="enter-link">دخول</div>
            </div>

            <!-- بطاقة نسخ رابط المندوب -->
            <div class="dash-card" onclick="copyRepOfferLink()">
                <i class="fa fa-link"></i>
                <span>انسخ رابط المندوب</span>
                <div class="enter-link">نسخ الرابط</div>
            </div>

        </div>
    </div>

    <!-- Modal كلمة المرور -->
    <div class="pw-modal" id="pwModal">
        <div class="pw-modal-content">
            <span style="font-weight:bold;font-size:1.13rem;">ادخل كلمة المرور للمتابعة</span>
            <input type="password" id="pwInput" placeholder="كلمة المرور" onkeydown="if(event.key==='Enter'){pwCheck();}">
            <div id="pwError" class="err-msg" style="display:none;"></div>
            <button onclick="pwCheck()">تأكيد</button>
            <button class="close-btn" onclick="pwHide()">إغلاق</button>
        </div>
    </div>
    <!-- رسالة النسخ -->
    <div id="copyMsg">تم نسخ الرابط!</div>
    <script>
        // الرسالة الترحيبية
        window.onload = function(){
            var welcome = document.getElementById('welcomeOverlay');
            var main    = document.getElementById('dashMain');
            welcome.classList.add('show');
            setTimeout(function(){
                welcome.classList.remove('show');
                welcome.style.display = 'none';
                main.classList.remove('hide');
            }, 2000); // عدل الوقت كما تشاء
        };

        // كود الحماية للباسورد
        let pwModal      = document.getElementById('pwModal');
        let pwInput      = document.getElementById('pwInput');
        let pwError      = document.getElementById('pwError');
        let pwRedirectTo = '';

        function pwShow(link){
            pwRedirectTo = link;
            pwModal.classList.add('active');
            pwError.style.display = 'none';
            pwInput.value = '';
            pwInput.focus();
        }
        function pwHide(){
            pwModal.classList.remove('active');
            pwInput.value = '';
            pwError.style.display = 'none';
        }
        function pwCheck(){
            let pw = pwInput.value.trim();
            if (pw === '1997') {
                window.location = pwRedirectTo;
            } else {
                pwError.innerText = "كلمة المرور غير صحيحة!";
                pwError.style.display = 'block';
                pwInput.value = '';
                pwInput.focus();
            }
        }

        // نسخ رابط المندوب
        function copyRepOfferLink() {
            var link = "https://mosul.pw/shop/rep_offers.php";
            if (navigator.clipboard) {
                navigator.clipboard.writeText(link).then(function() {
                    showCopyMsg();
                }, function() {
                    fallbackCopyTextToClipboard(link);
                });
            } else {
                fallbackCopyTextToClipboard(link);
            }
        }
        function fallbackCopyTextToClipboard(text) {
            var textArea = document.createElement("textarea");
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();
            try {
                var successful = document.execCommand('copy');
                showCopyMsg();
            } catch (err) {}
            document.body.removeChild(textArea);
        }
        function showCopyMsg() {
            var el = document.getElementById("copyMsg");
            el.style.display = 'block';
            setTimeout(function(){ el.style.display = 'none'; }, 1600);
        }
    </script>
</body>
</html>
