<?php
include('config.php');

$barcode = isset($_GET['barcode']) ? trim($_GET['barcode']) : '';
$result = ['found'=>false];

if ($barcode != '') {
    $stmt = mysqli_prepare($conn, "SELECT id FROM products WHERE barcode=? LIMIT 1");
    mysqli_stmt_bind_param($stmt, 's', $barcode);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $product_id);
    if (mysqli_stmt_fetch($stmt)) {
        $result = ['found'=>true, 'product_id'=>$product_id];
    }
    mysqli_stmt_close($stmt);
}

header('Content-Type: application/json; charset=utf-8');
echo json_encode($result, JSON_UNESCAPED_UNICODE);
