<?php
include('config.php'); // الاتصال بقاعدة البيانات

// معالجة الإرسال
if (isset($_POST['submit'])) {
    $rep_name = mysqli_real_escape_string($conn, $_POST['rep_name']);
    $phone = mysqli_real_escape_string($conn, $_POST['phone']);
    $company = mysqli_real_escape_string($conn, $_POST['company']);
    $product_name = mysqli_real_escape_string($conn, $_POST['product_name']);
    $price = floatval($_POST['price']);
    $notes = mysqli_real_escape_string($conn, $_POST['notes']);

    $q = "INSERT INTO offers (rep_name, phone, company, product_name, price, notes) VALUES 
         ('$rep_name', '$phone', '$company', '$product_name', '$price', '$notes')";
    if(mysqli_query($conn, $q)){
        // إعادة توجيه لتصفير الحقول ومنع التكرار عند التحديث
        header("Location: rep_offers.php?success=1");
        exit();
    } else {
        $msg = "❌ حدث خطأ أثناء الحفظ: " . mysqli_error($conn);
    }
}

// رسالة النجاح عند إضافة عرض جديد
if (isset($_GET['success'])) {
    $msg = "✅ تم حفظ العرض بنجاح!";
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة عرض مندوب</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #e0ecfc 0%, #f2f9fb 100%);
            font-family: 'Cairo', Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .offer-box {
            background: #fff;
            border-radius: 26px;
            box-shadow: 0 8px 32px #b9defe50;
            padding: 38px 30px 28px 30px;
            width: 100%;
            max-width: 460px;
            transition: box-shadow .2s;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        h2 {
            color: #1769aa;
            font-weight: 800;
            text-align: center;
            letter-spacing: 1px;
            margin-bottom: 28px;
            font-size: 2.0em;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 18px;
            width: 100%;
            max-width: 400px;
            align-items: stretch;
        }
        .input-group {
            position: relative;
            display: flex;
            align-items: center;
            width: 100%;
        }
        .input-group i {
            position: absolute;
            right: 14px;
            color: #1976d2a6;
            font-size: 1.15em;
        }
        input, textarea {
            width: 100%;
            padding: 11px 42px 11px 12px;
            border: 1.5px solid #d8e6f3;
            border-radius: 9px;
            font-size: 1.09em;
            background: #f8fbfd;
            transition: border-color .2s;
            margin: 0;
        }
        input:focus, textarea:focus {
            border-color: #2196f3;
            background: #fff;
            outline: none;
        }
        textarea {
            min-height: 60px;
            max-height: 120px;
            resize: vertical;
        }
        button {
            background: linear-gradient(90deg,#2196f3 60%,#1769aa 100%);
            color: #fff;
            border: none;
            padding: 13px 0;
            border-radius: 9px;
            font-size: 1.13em;
            font-weight: bold;
            letter-spacing: 1px;
            cursor: pointer;
            margin-top: 5px;
            box-shadow: 0 2px 10px #b3cbe850;
            transition: background .2s;
            width: 100%;
        }
        button:hover {
            background: #1976d2;
        }
        .msg {
            text-align: center;
            padding: 10px 0;
            margin-bottom: 16px;
            font-size: 1.14em;
            border-radius: 8px;
            background: #e3f4e6;
            color: #258940;
            font-weight: 700;
            display: block;
        }
        .error {
            background: #ffe3e3;
            color: #b51b1b;
        }
        @media (max-width: 600px) {
            .offer-box { padding: 16px 5px 18px 5px; }
            h2 { font-size: 1.3em; }
            form { max-width: 99vw;}
            input, textarea { font-size: 1em; }
        }
    </style>
</head>
<body>
<div class="offer-box">
    <h2><i class="bi bi-stars"></i> إضافة عرض جديد</h2>
    <?php if(isset($msg)) echo '<div class="msg">'.$msg.' <i class="bi bi-check-square-fill"></i></div>'; ?>
    <form method="post" autocomplete="off">
        <div class="input-group">
            <i class="bi bi-person-fill"></i>
            <input type="text" name="rep_name" placeholder="اسم المندوب" required>
        </div>
        <div class="input-group">
            <i class="bi bi-telephone-fill"></i>
            <input type="text" name="phone" placeholder="رقم الهاتف" required>
        </div>
        <div class="input-group">
            <i class="bi bi-building"></i>
            <input type="text" name="company" placeholder="اسم الشركة" required>
        </div>
        <div class="input-group">
            <i class="bi bi-box-seam"></i>
            <input type="text" name="product_name" placeholder="اسم المنتج" required>
        </div>
        <div class="input-group">
            <i class="bi bi-cash-stack"></i>
            <input type="number" step="0.01" name="price" placeholder="سعر المنتج" required>
        </div>
        <div class="input-group">
            <i class="bi bi-chat-dots-fill"></i>
            <textarea name="notes" placeholder="ملاحظات / البونص أو العرض المتوفر" required></textarea>
        </div>
        <button type="submit" name="submit"><i class="bi bi-cloud-arrow-up-fill"></i> حفظ العرض</button>
    </form>
</div>
</body>
</html>
