<?php
include('config.php');

function redirect_with_message($url, $msg, $type = 'error') {
    header("Location: $url?msg=" . urlencode($msg) . "&type=$type");
    exit;
}

// استقبال بيانات السلة (cart_data)
if (!isset($_POST['cart_data'])) {
    redirect_with_message('cashier.php', 'لم يتم استقبال بيانات البيع', 'error');
}

$cart = json_decode($_POST['cart_data'], true);

if (!is_array($cart) || count($cart) == 0) {
    redirect_with_message('cashier.php', 'سلة البيع فارغة أو تالفة', 'error');
}

$total = 0;
$paid = 0;
$has_wholesale = false;
$has_retail = false;

foreach($cart as $item) {
    if (!isset($item['id'], $item['qty'], $item['price'], $item['type']))
        redirect_with_message('cashier.php', 'بيانات صنف غير كاملة', 'error');

    $qty   = intval($item['qty']);
    $price = floatval($item['price']);
    $type  = $item['type'];

    if ($qty <= 0) redirect_with_message('cashier.php', 'لا يمكن بيع كمية أقل من 1', 'error');
    if ($price <= 0) redirect_with_message('cashier.php', 'لا يمكن البيع بسعر 0', 'error');
    if ($type == "wholesale") $has_wholesale = true;
    if ($type == "retail")    $has_retail    = true;
    $total += $qty * $price;
}

// تحديد نوع البيع الأساسي للفاتورة
if ($has_wholesale && $has_retail) $sale_type = 'mixed';
elseif ($has_wholesale)            $sale_type = 'wholesale';
else                               $sale_type = 'retail';

$paid = $total;

// إنشاء سجل الفاتورة
mysqli_query($conn, "INSERT INTO sales (total, paid, sale_type, created_at) VALUES ($total, $paid, '$sale_type', NOW())");
$sale_id = mysqli_insert_id($conn);

// حفظ تفاصيل البيع وتحديث المخزون
foreach($cart as $item) {
    $pid   = intval($item['id']);
    $qty   = intval($item['qty']);
    $price = floatval($item['price']);
    $type  = $item['type'];
    $total_row = $qty * $price;

    // تحقق من المخزون الفعلي قبل الحذف
    $q = mysqli_query($conn, "SELECT stock, name FROM products WHERE id = $pid");
    $prod = mysqli_fetch_assoc($q);

    if (!$prod) {
        // منتج محذوف أو غير موجود!
        mysqli_query($conn, "DELETE FROM sales WHERE id = $sale_id");
        mysqli_query($conn, "DELETE FROM sales_items WHERE sale_id = $sale_id");
        redirect_with_message('cashier.php', 'أحد المنتجات غير موجود!', 'error');
    }
    if ($prod['stock'] < $qty) {
        mysqli_query($conn, "DELETE FROM sales WHERE id = $sale_id");
        mysqli_query($conn, "DELETE FROM sales_items WHERE sale_id = $sale_id");
        redirect_with_message('cashier.php', "الكمية المطلوبة من المنتج [{$prod['name']}] أكبر من المخزون المتوفر!", 'error');
    }

    mysqli_query($conn, "INSERT INTO sales_items (sale_id, product_id, qty, unit_price, total, sale_type)
                        VALUES ($sale_id, $pid, $qty, $price, $total_row, '$type')");
    // خصم الكمية من المخزون
    mysqli_query($conn, "UPDATE products SET stock = stock - $qty WHERE id = $pid");
}

redirect_with_message("cashier.php", "تم تنفيذ البيع بنجاح! رقم الفاتورة: $sale_id", "success");
?>
