<?php
include('config.php');

// الفلترة بالتاريخ
$date_from = isset($_GET['from']) ? $_GET['from'] : date('Y-m-d', strtotime('-7 days'));
$date_to   = isset($_GET['to']) ? $_GET['to'] : date('Y-m-d');

// الفلترة باسم المنتج
$product_filter = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;

// جلب المنتجات للقائمة المنسدلة
$products_list = mysqli_query($conn, "SELECT id, name FROM products ORDER BY name");

$where = "WHERE DATE(s.created_at) BETWEEN '$date_from' AND '$date_to'";
if($product_filter > 0){
    $where .= " AND EXISTS (
        SELECT 1 FROM sales_items si WHERE si.sale_id = s.id AND si.product_id = $product_filter
    )";
}

$sales = mysqli_query($conn, "SELECT * FROM sales s $where ORDER BY s.id DESC");
$total_sum = 0;
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إحصائيات المبيعات</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@600&display=swap" rel="stylesheet">
    <style>
        body { background: #f6f8fa; font-family: 'Cairo', Arial, sans-serif; }
        .container { max-width: 1100px; margin: 32px auto; background: #fff; border-radius: 16px; box-shadow: 0 3px 20px #d7e3f888; padding: 30px 14px;}
        h2 { color: #1976d2; text-align: center; margin-bottom: 30px;}
        table { width: 100%; border-collapse: collapse; background: #fff; }
        th, td { padding: 8px; border-bottom: 1px solid #e0e0e0; text-align: center;}
        th { background: #1976d2; color: #fff;}
        .btn { padding: 4px 16px; border-radius: 10px; background: #2e86de; color: #fff; border: none; cursor: pointer;}
        .btn:hover { background: #1256b1;}
        .date-filter {margin-bottom:18px;text-align:center;}
        .total-row {background: #ecf0f7; font-weight: bold;}
        .products-table {width: 98%; margin: 0 auto; border: none; font-size: .99rem;}
        .products-table th {background:#e3edfa; color:#1256b1;}
        .products-table td, .products-table th {padding:4px 6px;border:none;}
        select {font-size:1.07rem;padding:4px 6px;border-radius:7px;border:1px solid #aaa;}
    </style>
</head>
<body>
<div class="container">
    <h2>إحصائيات المبيعات</h2>
    <form class="date-filter" method="get" action="">
        من: <input type="date" name="from" value="<?= htmlspecialchars($date_from) ?>">
        إلى: <input type="date" name="to" value="<?= htmlspecialchars($date_to) ?>">
        &nbsp;&nbsp; اسم المنتج: 
        <select name="product_id">
            <option value="0">كل المنتجات</option>
            <?php while($p = mysqli_fetch_assoc($products_list)): ?>
                <option value="<?= $p['id'] ?>" <?= $product_filter == $p['id'] ? "selected" : "" ?>><?= htmlspecialchars($p['name']) ?></option>
            <?php endwhile; ?>
        </select>
        <button class="btn" type="submit">تصفية</button>
        <a href="sales_stats.php" class="btn" style="background:#d32f2f;">إلغاء التصفية</a>
    </form>
    <table>
        <thead>
            <tr>
                <th>رقم الفاتورة</th>
                <th>التاريخ</th>
                <th>نوع البيع</th>
                <th>المنتجات المباعة</th>
                <th>المجموع</th>
                <th>مدفوع</th>
            </tr>
        </thead>
        <tbody>
        <?php while($sale = mysqli_fetch_assoc($sales)): 
            $sale_id = $sale['id']; 
            $total_sum += $sale['total'];

            // جلب المنتجات المباعة لكل فاتورة (مع اسم المنتج)
            $query_items = "SELECT si.*, p.name FROM sales_items si JOIN products p ON si.product_id = p.id WHERE si.sale_id = $sale_id";
            if($product_filter > 0){
                $query_items .= " AND si.product_id = $product_filter";
            }
            $items = mysqli_query($conn, $query_items);
        ?>
            <tr>
                <td><?= $sale['id'] ?></td>
                <td><?= $sale['created_at'] ?></td>
                <td><?= $sale['sale_type'] == 'wholesale' ? 'جملة' : 'مفرد' ?></td>
                <td style="padding:2px 0;">
                    <table class="products-table">
                        <tr>
                            <th>المنتج</th>
                            <th>الكمية</th>
                            <th>سعر الوحدة</th>
                            <th>الإجمالي</th>
                        </tr>
                        <?php while($item = mysqli_fetch_assoc($items)): ?>
                        <tr>
                            <td><?= htmlspecialchars($item['name']) ?></td>
                            <td><?= (int)$item['qty'] ?></td>
                            <td><?= number_format($item['unit_price'],2) ?> د.ع</td>
                            <td><?= number_format($item['total'],2) ?> د.ع</td>
                        </tr>
                        <?php endwhile; ?>
                    </table>
                </td>
                <td><?= number_format($sale['total'],2) ?> د.ع</td>
                <td><?= number_format($sale['paid'],2) ?> د.ع</td>
            </tr>
        <?php endwhile; ?>
        <tr class="total-row">
            <td colspan="4">المجموع الكلي للفترة:</td>
            <td colspan="2"><?= number_format($total_sum,2) ?> د.ع</td>
        </tr>
        </tbody>
    </table>
</div>
</body>
</html>
