<?php
session_start();
include 'db.php';

// ✅ تأكد أن الإدارة مسجّلة دخول
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// ✅ إعداد الترميز
mysqli_set_charset($conn, "utf8mb4");

// ✅ جلب بيانات الأدمن من الجلسة
$admin_username = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : '';
$admin_role     = isset($_SESSION['admin_role']) ? $_SESSION['admin_role'] : null;

// ✅ لو ماكو role (جلسة قديمة) نحدده من اسم المستخدم
if ($admin_role === null) {
    switch ($admin_username) {
        case 'alawael0':
            // فقط صلاحية الأسئلة
            $admin_role = 'questions_only';
            break;

        case 'alawael1':
            // واجبات + إحصائيات الامتحان
            $admin_role = 'homework_exam_stats';
            break;

        case 'alawael2':
            // تقييمات + درجات + إحصائيات
            $admin_role = 'eval_stats_grades';
            break;

        case 'awael':   // يوزر الإدارة القديم
        case 'alawael': // يوزر الإدارة الكامل
        default:
            // كامل الصلاحيات
            $admin_role = 'super';
            break;
    }
    $_SESSION['admin_role'] = $admin_role;
}

// ✅ هذه الصفحة مخصصة فقط لـ:
// - super         (awael / alawael)
// - questions_only (alawael0)
// ولا يُسمح لـ alawael1 ولا alawael2 بالدخول
if (!in_array($admin_role, array('super', 'questions_only'), true)) {
    header("Location: admin_dashboard.php");
    exit();
}

// ===========================================================
// 🔄 تحديث حالة التمييز (AJAX) - حفظ اللون في قاعدة البيانات
// ===========================================================
if (isset($_POST['ajax_mark']) && isset($_POST['id'])) {
    $qid    = (int)$_POST['id'];
    $marked = (isset($_POST['marked']) && $_POST['marked'] == '1') ? 1 : 0;

    if ($qid > 0) {
        mysqli_query($conn, "UPDATE question_files SET is_marked = $marked WHERE id = $qid LIMIT 1");
    }

    echo 'OK';
    exit();
}

// ===========================================================
// 🗑️ معالجة الحذف قبل أي شيء
// ===========================================================
if (isset($_GET['del_id'])) {
    $del_id = (int)$_GET['del_id'];
    if ($del_id > 0) {
        // 1) جلب مسار الملف
        $qf = mysqli_query($conn, "SELECT file_path FROM question_files WHERE id = $del_id LIMIT 1");
        if ($qf && mysqli_num_rows($qf) == 1) {
            $frow = mysqli_fetch_assoc($qf);
            $file_path = isset($frow['file_path']) ? $frow['file_path'] : '';

            // 2) حذف الملف من السيرفر (إذا كان مسار حقيقي على السيرفر)
            if ($file_path != '') {
                // لو المسار داخلي مثلاً: uploads/questions/xxx.pdf
                if (file_exists($file_path)) {
                    @unlink($file_path);
                } else {
                    // أحياناً يكون المسار يبدأ بشرطة مائلة
                    if (file_exists(__DIR__ . '/' . ltrim($file_path, '/'))) {
                        @unlink(__DIR__ . '/' . ltrim($file_path, '/'));
                    }
                }
            }

            // 3) حذف السجل من قاعدة البيانات
            mysqli_query($conn, "DELETE FROM question_files WHERE id = $del_id");
        }
    }

    // 4) رجوع لنفس الصفحة بدون بارامتر الحذف
    // حتى لا يعيد الحذف بالتحديث
    $back = basename($_SERVER['PHP_SELF']);
    // نحافظ على الفلاتر لو كانت موجودة
    $qs = $_GET;
    unset($qs['del_id']);
    $query_string = http_build_query($qs);
    header("Location: ".$back.($query_string ? "?$query_string" : ""));
    exit();
}

// ===========================================================
// 🧱 جلب القوائم المساعدة
// ===========================================================
$teachers = [];
$resT = mysqli_query($conn, "SELECT id, name, subject, stages, classes FROM teachers ORDER BY name ASC");
if ($resT && mysqli_num_rows($resT) > 0) {
    while ($r = mysqli_fetch_assoc($resT)) {
        $teachers[] = $r;
    }
}

// مراحل من جدول الأسئلة (للفلترة)
$stages_list = [];
$resSt = mysqli_query($conn, "SELECT DISTINCT stage FROM question_files WHERE stage<>'' ORDER BY stage");
if ($resSt) {
    while ($r = mysqli_fetch_assoc($resSt)) {
        $stages_list[] = $r['stage'];
    }
}

// ===========================================================
// 🧠 فلاتر العرض الرئيسي
// (شيلنا الشعبة من الفلاتر)
// ===========================================================
$f_teacher  = isset($_GET['teacher_id']) ? (int)$_GET['teacher_id'] : 0;
$f_stage    = isset($_GET['stage']) ? trim($_GET['stage']) : '';
$f_sem      = isset($_GET['semester']) ? trim($_GET['semester']) : '';
$f_exam     = isset($_GET['exam_type']) ? trim($_GET['exam_type']) : '';
$f_model    = isset($_GET['exam_model']) ? trim($_GET['exam_model']) : '';

// لبناء الشرط - استخدمنا alias q للجدول
$where = " WHERE 1=1 ";
if ($f_teacher > 0) $where .= " AND q.teacher_id = ".$f_teacher." ";
if ($f_stage !== '') $where .= " AND q.stage = '".mysqli_real_escape_string($conn, $f_stage)."' ";
if ($f_sem !== '')   $where .= " AND q.semester = '".mysqli_real_escape_string($conn, $f_sem)."' ";
if ($f_exam !== '') {
    if ($f_exam === 'بدون') {
        $where .= " AND (q.exam_type = '' OR q.exam_type IS NULL) ";
    } else {
        $where .= " AND q.exam_type = '".mysqli_real_escape_string($conn, $f_exam)."' ";
    }
}
if ($f_model !== '') $where .= " AND q.exam_model = '".mysqli_real_escape_string($conn, $f_model)."' ";

// ===========================================================
// 📥 جلب كل الأسئلة (بعد الفلترة)
// ✅ التصفيط الآن حسب اسم المدرّس ثم تاريخ الرفع
// ===========================================================
$q_files = mysqli_query(
    $conn,
    "SELECT q.*, t.name AS t_name
     FROM question_files q
     LEFT JOIN teachers t ON q.teacher_id = t.id
     $where
     ORDER BY t.name ASC, q.uploaded_at DESC"
);

// ===========================================================
// 📊 إحصائيات سريعة
// ===========================================================
$stats = [
    'total'         => 0,
    'f1'            => 0,
    'f2'            => 0,
    'mid'           => 0, // نصف السنة
    'final'         => 0, // آخر السنة
    'sh1'           => 0,
    'sh2'           => 0,
    'sh3'           => 0,
    'daily'         => 0,
];

$all_files_for_missing = [];

if ($q_files) {
    while ($row = mysqli_fetch_assoc($q_files)) {
        $stats['total']++;
        $all_files_for_missing[] = $row;

        // حسب الفصل
        if ($row['semester'] == 'ف1') $stats['f1']++;
        elseif ($row['semester'] == 'ف2') $stats['f2']++;
        elseif ($row['semester'] == 'نصف السنة') $stats['mid']++;
        elseif ($row['semester'] == 'آخر السنة') $stats['final']++;

        // حسب الشهر/اليومي
        if ($row['exam_type'] == 'ش1') $stats['sh1']++;
        elseif ($row['exam_type'] == 'ش2') $stats['sh2']++;
        elseif ($row['exam_type'] == 'ش3') $stats['sh3']++;
        elseif ($row['exam_type'] == 'اليومي') $stats['daily']++;
    }
    // نرجع المؤشر حتى نعرضهم بالجدول
    mysqli_data_seek($q_files, 0);
}

// ===========================================================
// 🟥 المدرسون الذين لم يرفعوا
// ===========================================================
$show_missing = (isset($_GET['show_missing']) && $_GET['show_missing'] == '1');
$miss_sem     = isset($_GET['miss_semester']) ? trim($_GET['miss_semester']) : '';
$miss_exam    = isset($_GET['miss_exam_type']) ? trim($_GET['miss_exam_type']) : '';
$missing_teachers = [];

if ($show_missing) {
    $cond = " WHERE 1=1 ";
    if ($miss_sem !== '') {
        $cond .= " AND semester = '".mysqli_real_escape_string($conn, $miss_sem)."' ";
    }
    if ($miss_exam !== '') {
        if ($miss_exam === 'بدون') {
            $cond .= " AND (exam_type = '' OR exam_type IS NULL) ";
        } else {
            $cond .= " AND exam_type = '".mysqli_real_escape_string($conn, $miss_exam)."' ";
        }
    }

    $uploaded_t_ids = [];
    $q_up = mysqli_query($conn, "SELECT DISTINCT teacher_id FROM question_files $cond");
    if ($q_up) {
        while ($r = mysqli_fetch_assoc($q_up)) {
            $uploaded_t_ids[] = (int)$r['teacher_id'];
        }
    }

    foreach ($teachers as $t) {
        if (!in_array((int)$t['id'], $uploaded_t_ids, true)) {
            $missing_teachers[] = $t;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة الأسئلة المرفوعة - الإدارة</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;600;700&display=swap" rel="stylesheet">
<style>
*{box-sizing:border-box;margin:0;padding:0}
body{
  font-family:'Tajawal',sans-serif;
  min-height:100vh;
  background:radial-gradient(circle at 20% 20%,#1a1f3b,#0b0d18 80%);
  color:#fff;
}
header{
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:14px 20px;
  background:rgba(255,255,255,0.04);
  border-bottom:1px solid rgba(255,255,255,0.07);
  backdrop-filter:blur(6px);
}
header .title{font-size:18px;font-weight:700}
header .btn{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  color:#fff;
  text-decoration:none;
  padding:7px 14px;
  border-radius:10px;
  font-size:13px;
  margin-left:6px;
}
.container{
  width:100%;
  max-width:1300px;
  margin:25px auto 50px;
  padding:0 15px;
}
.stat-grid{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
  gap:12px;
  margin-bottom:18px;
}
.stat-card{
  background:rgba(255,255,255,0.05);
  border:1px solid rgba(255,255,255,0.02);
  border-radius:14px;
  padding:12px;
  text-align:center;
  box-shadow:0 10px 25px rgba(0,0,0,.08);
}
.stat-card h3{font-size:13px;color:#ddd;margin-bottom:4px}
stat-card .num{font-size:22px;font-weight:700;color:#fff}

.filter-box{
  background:rgba(255,255,255,0.03);
  border:1px solid rgba(255,255,255,0.04);
  border-radius:14px;
  padding:12px 12px 4px;
  margin-bottom:18px;
}
.filter-row{
  display:flex;
  gap:8px;
  flex-wrap:wrap;
  align-items:flex-end;
}
.filter-row label{display:block;font-size:12px;margin-bottom:3px}
.filter-row select{
  background:rgba(0,0,0,0.2);
  border:1px solid rgba(255,255,255,0.04);
  color:#fff;
  border-radius:10px;
  padding:6px 9px;
  min-width:130px;
}
.btn-primary{
  background:linear-gradient(90deg,#00e6ff,#007bff);
  border:none;
  border-radius:10px;
  padding:7px 14px;
  color:#fff;
  cursor:pointer;
  font-weight:600;
}
.table-box{
  background:rgba(255,255,255,0.025);
  border:1px solid rgba(255,255,255,0.04);
  border-radius:14px;
  overflow:auto;
}
table{
  width:100%;
  border-collapse:collapse;
  min-width:820px;
}
th,td{
  text-align:center;
  padding:8px 6px;
  border-bottom:1px solid rgba(255,255,255,0.02);
  font-size:13px;
}
th{background:rgba(0,0,0,0.28);position:sticky;top:0;z-index:1}
tbody tr:nth-child(even){background:rgba(0,0,0,0.03);}

/* ✅ تمييز الصفوف */
tbody tr.row-marked{
  background:rgba(0,180,0,0.30) !important;
}
tbody tr.row-marked td{
  border-bottom-color:rgba(0,255,0,0.35);
}

a.dwn{
  background:#28a745;
  color:#fff;
  text-decoration:none;
  padding:4px 10px;
  border-radius:8px;
}
.btn-del{
  background:#d9534f;
  color:#fff;
  text-decoration:none;
  padding:4px 10px;
  border-radius:8px;
  font-size:12px;
}
.notice-block{
  background:rgba(0,0,0,0.35);
  border:1px solid rgba(255,255,255,0.04);
  border-radius:12px;
  padding:10px 12px;
  margin-top:16px;
  font-size:13px;
  line-height:1.6;
}
.miss-box{
  margin-top:25px;
  background:rgba(255,255,255,0.025);
  border:1px solid rgba(255,255,255,0.04);
  border-radius:14px;
  padding:12px;
}
.miss-title{font-weight:600;margin-bottom:10px}
.badge-red{background:rgba(255,0,74,0.15);border:1px solid rgba(255,0,74,0.35);padding:3px 6px;border-radius:8px;font-size:12px}
.badge-green{background:rgba(0,255,135,0.15);border:1px solid rgba(0,255,135,0.45);padding:3px 6px;border-radius:8px;font-size:12px}
@media(max-width:650px){
  .filter-row{flex-direction:column;align-items:flex-start}
  header{flex-wrap:wrap;gap:8px}
}
</style>
<script>
// تنبيه قبل الحذف
function confirmDelete(url){
  if (confirm("⚠️ هل أنت متأكد من حذف هذا السؤال؟ سيتم حذف الملف والسجل نهائيًا.")) {
    window.location = url;
  }
}

// ✅ تلوين الصفوف + حفظ الحالة في قاعدة البيانات عبر AJAX
document.addEventListener('DOMContentLoaded', function(){
  var checkboxes = document.querySelectorAll('input.mark-row');

  for (var i = 0; i < checkboxes.length; i++) {
    checkboxes[i].addEventListener('change', function(){
      var tr = this.closest('tr');
      if (!tr) return;

      var qid    = this.getAttribute('data-id');
      var marked = this.checked ? 1 : 0;

      // تلوين الصف على الواجهة
      if (this.checked) {
        tr.classList.add('row-marked');
      } else {
        tr.classList.remove('row-marked');
      }

      // إرسال التغيير للسيرفر (نفس الملف) لتحديث قاعدة البيانات
      var xhr = new XMLHttpRequest();
      xhr.open('POST', window.location.href, true);
      xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
      xhr.send('ajax_mark=1&id=' + encodeURIComponent(qid) + '&marked=' + marked);
    });
  }
});
</script>
</head>
<body>
<header>
  <div class="title">📁 إدارة الأسئلة المرفوعة (جميع المدرسين)</div>
  <div>
    <a href="admin_dashboard.php" class="btn">العودة للوحة</a>
    <a href="admin_logout.php" class="btn" style="background:#d9534f;">خروج</a>
  </div>
</header>

<div class="container">

  <!-- 📊 إحصائيات -->
  <div class="stat-grid">
    <div class="stat-card"><h3>إجمالي الملفات</h3><div class="num"><?php echo $stats['total']; ?></div></div>
    <div class="stat-card"><h3>ف1</h3><div class="num"><?php echo $stats['f1']; ?></div></div>
    <div class="stat-card"><h3>ف2</h3><div class="num"><?php echo $stats['f2']; ?></div></div>
    <div class="stat-card"><h3>نصف السنة</h3><div class="num"><?php echo $stats['mid']; ?></div></div>
    <div class="stat-card"><h3>آخر السنة</h3><div class="num"><?php echo $stats['final']; ?></div></div>
    <div class="stat-card"><h3>ش1</h3><div class="num"><?php echo $stats['sh1']; ?></div></div>
    <div class="stat-card"><h3>ش2</h3><div class="num"><?php echo $stats['sh2']; ?></div></div>
    <div class="stat-card"><h3>ش3</h3><div class="num"><?php echo $stats['sh3']; ?></div></div>
    <div class="stat-card"><h3>اليومي</h3><div class="num"><?php echo $stats['daily']; ?></div></div>
  </div>

  <!-- 🧪 فلاتر (بدون الشعبة) -->
  <div class="filter-box">
    <form method="get" class="filter-row">
      <div>
        <label>المدرّس</label>
        <select name="teacher_id">
          <option value="0">الكل</option>
          <?php foreach ($teachers as $t): ?>
            <option value="<?php echo (int)$t['id']; ?>" <?php echo ($f_teacher == (int)$t['id'])?'selected':''; ?>>
              <?php echo htmlspecialchars($t['name'], ENT_QUOTES, 'UTF-8'); ?>
              <?php if ($t['subject'] != '') echo ' - '.htmlspecialchars($t['subject'], ENT_QUOTES, 'UTF-8'); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>المرحلة</label>
        <select name="stage">
          <option value="">الكل</option>
          <?php foreach ($stages_list as $st): ?>
            <option value="<?php echo htmlspecialchars($st, ENT_QUOTES, 'UTF-8'); ?>" <?php echo ($f_stage==$st)?'selected':''; ?>>
              <?php echo htmlspecialchars($st, ENT_QUOTES, 'UTF-8'); ?>
            </option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>الفصل</label>
        <select name="semester">
          <option value="">الكل</option>
          <option value="ف1" <?php echo ($f_sem=='ف1'?'selected':''); ?>>ف1</option>
          <option value="ف2" <?php echo ($f_sem=='ف2'?'selected':''); ?>>ف2</option>
          <option value="نصف السنة" <?php echo ($f_sem=='نصف السنة'?'selected':''); ?>>نصف السنة</option>
          <option value="آخر السنة" <?php echo ($f_sem=='آخر السنة'?'selected':''); ?>>آخر السنة</option>
        </select>
      </div>
      <div>
        <label>الشهر / اليومي</label>
        <select name="exam_type">
          <option value="">الكل</option>
          <option value="ش1" <?php echo ($f_exam=='ش1'?'selected':''); ?>>الشهر الأول (ش1)</option>
          <option value="ش2" <?php echo ($f_exam=='ش2'?'selected':''); ?>>الشهر الثاني (ش2)</option>
          <option value="ش3" <?php echo ($f_exam=='ش3'?'selected':''); ?>>الشهر الثالث (ش3)</option>
          <option value="اليومي" <?php echo ($f_exam=='اليومي'?'selected':''); ?>>اليومي</option>
          <option value="بدون" <?php echo ($f_exam=='بدون'?'selected':''); ?>>بدون (نصف/آخر السنة)</option>
        </select>
      </div>
      <div>
        <label>نموذج</label>
        <select name="exam_model">
          <option value="">الكل</option>
          <option value="A" <?php echo ($f_model=='A'?'selected':''); ?>>A</option>
          <option value="B" <?php echo ($f_model=='B'?'selected':''); ?>>B</option>
          <option value="مؤجلين" <?php echo ($f_model=='مؤجلين'?'selected':''); ?>>مؤجلين</option>
        </select>
      </div>
      <div>
        <button type="submit" class="btn-primary">🔍 تطبيق</button>
      </div>
    </form>
  </div>

  <!-- 📋 جدول الأسئلة (بدون عمود الشعبة) + عمود الحذف + Checkbox التمييز -->
  <div class="table-box">
    <table>
      <thead>
        <tr>
          <th>#</th>
          <th>المدرّس</th>
          <th>المادة</th>
          <th>المرحلة</th>
          <th>الفصل</th>
          <th>النوع</th>
          <th>النموذج</th>
          <th>تاريخ الرفع</th>
          <th>ملف</th>
          <th>تمييز</th>
          <th>حذف</th>
        </tr>
      </thead>
      <tbody>
      <?php
      if ($q_files && mysqli_num_rows($q_files) > 0):
        $i=1;
        while ($row = mysqli_fetch_assoc($q_files)):
          // نستخدم الاسم القادم من JOIN، ولو فارغ نكتب "غير معروف"
          $tname = ($row['t_name'] != '' ? $row['t_name'] : 'غير معروف');

          // نبني رابط الحذف مع الحفاظ على الفلاتر الحالية
          $qs2 = $_GET;
          $qs2['del_id'] = $row['id'];
          $del_url = basename($_SERVER['PHP_SELF']) . '?' . http_build_query($qs2);
      ?>
        <tr class="<?php echo (!empty($row['is_marked']) ? 'row-marked' : ''); ?>">
          <td><?php echo $i++; ?></td>
          <td><?php echo htmlspecialchars($tname, ENT_QUOTES, 'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($row['subject'], ENT_QUOTES, 'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($row['stage'], ENT_QUOTES, 'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($row['semester'], ENT_QUOTES, 'UTF-8'); ?></td>
          <td><?php echo $row['exam_type']!=='' ? htmlspecialchars($row['exam_type'], ENT_QUOTES, 'UTF-8') : '—'; ?></td>
          <td><?php echo $row['exam_model']!=='' ? htmlspecialchars($row['exam_model'], ENT_QUOTES, 'UTF-8') : '—'; ?></td>
          <td><?php echo date('Y-m-d H:i', strtotime($row['uploaded_at'])); ?></td>
          <td>
            <?php if ($row['file_path']!=''): ?>
              <a class="dwn" href="<?php echo htmlspecialchars($row['file_path'], ENT_QUOTES, 'UTF-8'); ?>" target="_blank">⬇</a>
            <?php endif; ?>
          </td>
          <td>
            <!-- ✅ Checkbox لتلوين الصف + حفظ في قاعدة البيانات -->
            <input 
              type="checkbox" 
              class="mark-row" 
              data-id="<?php echo (int)$row['id']; ?>" 
              title="تمييز هذا الصف (مثلاً: تم تنزيله)"
              <?php echo (!empty($row['is_marked']) ? 'checked' : ''); ?>
            >
          </td>
          <td>
            <a href="javascript:void(0)" onclick="confirmDelete('<?php echo $del_url; ?>')" class="btn-del">🗑 حذف</a>
          </td>
        </tr>
      <?php
        endwhile;
      else:
      ?>
        <tr><td colspan="11">لا توجد ملفات بهذا الفلتر.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>

  <div class="notice-block">
    ✅ يمكنك اختيار الفصل + الشهر ثم التمرير للأسفل في قسم "المتأخرين" لتعرف من لم يرفع.
    <br>✅ يمكنك أيضًا تمييز أي صف عن طريق مربع الاختيار (اللون الأخضر) لمتابعة الملفات التي تم تنزيلها.
  </div>

  <!-- 🟥 قسم المدرسين الذين لم يرفعوا -->
  <div class="miss-box">
    <div class="miss-title">المدرسون الذين لم يرفعوا أسئلة لفصل/شهر معيّن</div>
    <form method="get" style="display:flex;gap:8px;flex-wrap:wrap;align-items:flex-end;margin-bottom:12px;">
      <input type="hidden" name="show_missing" value="1">
      <div>
        <label>الفصل</label>
        <select name="miss_semester" style="padding:5px 8px;border-radius:8px;">
          <option value="">الكل</option>
          <option value="ف1" <?php echo ($miss_sem=='ف1'?'selected':''); ?>>ف1</option>
          <option value="ف2" <?php echo ($miss_sem=='ف2'?'selected':''); ?>>ف2</option>
          <option value="نصف السنة" <?php echo ($miss_sem=='نصف السنة'?'selected':''); ?>>نصف السنة</option>
          <option value="آخر السنة" <?php echo ($miss_sem=='آخر السنة'?'selected':''); ?>>آخر السنة</option>
        </select>
      </div>
      <div>
        <label>الشهر / اليومي</label>
        <select name="miss_exam_type" style="padding:5px 8px;border-radius:8px;">
          <option value="">الكل</option>
          <option value="ش1" <?php echo ($miss_exam=='ش1'?'selected':''); ?>>الشهر الأول (ش1)</option>
          <option value="ش2" <?php echo ($miss_exam=='ش2'?'selected':''); ?>>الشهر الثاني (ش2)</option>
          <option value="ش3" <?php echo ($miss_exam=='ش3'?'selected':''); ?>>الشهر الثالث (ش3)</option>
          <option value="اليومي" <?php echo ($miss_exam=='اليومي'?'selected':''); ?>>اليومي</option>
          <option value="بدون" <?php echo ($miss_exam=='بدون'?'selected':''); ?>>بدون (نصف/آخر السنة)</option>
        </select>
      </div>
      <div>
        <button type="submit" class="btn-primary">📋 عرض المتأخرين</button>
      </div>
    </form>

    <?php if ($show_missing): ?>
      <?php if (count($missing_teachers) > 0): ?>
        <div style="max-height:240px;overflow:auto;">
          <table style="width:100%;border-collapse:collapse;">
            <thead>
              <tr>
                <th style="background:rgba(0,0,0,0.25);">#</th>
                <th style="background:rgba(0,0,0,0.25);">المدرّس</th>
                <th style="background:rgba(0,0,0,0.25);">المادة</th>
                <th style="background:rgba(0,0,0,0.25);">المراحل</th>
                <th style="background:rgba(0,0,0,0.25);">الشعب</th>
              </tr>
            </thead>
            <tbody>
            <?php $i=1; foreach ($missing_teachers as $mt): ?>
              <tr>
                <td><?php echo $i++; ?></td>
                <td><?php echo htmlspecialchars($mt['name'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($mt['subject'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($mt['stages'], ENT_QUOTES, 'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($mt['classes'], ENT_QUOTES, 'UTF-8'); ?></td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <p style="font-size:12px;margin-top:6px;color:#ffcccc;">
          👆 هؤلاء لم يرفعوا وفق الفلتر المحدد فوق.
        </p>
      <?php else: ?>
        <p class="badge-green">👌 جميع المدرسين رفعوا للفلتر الحالي.</p>
      <?php endif; ?>
    <?php else: ?>
      <p class="badge-red">اختر فصل/شهر ثم اضغط "عرض المتأخرين".</p>
    <?php endif; ?>
  </div>

</div>
</body>
</html>
