<?php
session_start();
include 'db.php';

// ✅ منع الدخول بدون تسجيل
if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit();
}

// ✅ جلب بيانات الأدمن من الجلسة
$admin_username = isset($_SESSION['admin_username']) ? $_SESSION['admin_username'] : '';
$admin_role     = isset($_SESSION['admin_role']) ? $_SESSION['admin_role'] : null;

// ✅ لو ماكو role (جلسة قديمة مثلاً) نحدده من اسم المستخدم
if ($admin_role === null) {
    switch ($admin_username) {
        case 'alawael0':
            // فقط كارت أسئلة المدرسين
            $admin_role = 'questions_only';
            break;

        case 'alawael1':
            // عرض الواجبات + المادة الداخلة بالامتحان + إحصائية الواجبات
            $admin_role = 'homework_exam_stats';
            break;

        case 'alawael2':
            // تقييمات الطلبة + الإحصائيات + درجات الطلبة للمواد + الواجبات + إحصائية الواجبات
            $admin_role = 'eval_stats_grades';
            break;

        case 'awael':   // اليوزر القديم
        case 'alawael': // الكامل الصلاحيات
        default:
            // كامل الصلاحيات
            $admin_role = 'super';
            break;
    }
    $_SESSION['admin_role'] = $admin_role;
}

// ✅ السماح فقط لمن له كامل الصلاحيات (super)
if ($admin_role !== 'super') {
    header("Location: admin_dashboard.php");
    exit();
}

$all_stages = array('أول','ثاني','ثالث','رابع','خامس','سادس');
$letters = array('A','B','C','D','E','F');

function sanitize($s){ return trim($s); }

$notice = "";
// حذف
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM teachers WHERE id=$id");
    $notice = "✅ تم حذف المدرس رقم $id";
}

// جلب للتحرير
$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $res = mysqli_query($conn, "SELECT * FROM teachers WHERE id=$id LIMIT 1");
    if ($res && mysqli_num_rows($res) === 1) $edit = mysqli_fetch_assoc($res);
}

// حفظ إضافة/تعديل
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $name = isset($_POST['name']) ? mysqli_real_escape_string($conn, sanitize($_POST['name'])) : '';
    $password = isset($_POST['password']) ? mysqli_real_escape_string($conn, sanitize($_POST['password'])) : '';
    $subject = isset($_POST['subject']) ? mysqli_real_escape_string($conn, sanitize($_POST['subject'])) : '';

    // مراحل مختارة
    $stages_sel = isset($_POST['stages']) ? $_POST['stages'] : array();
    $stages_clean = array();
    foreach ($stages_sel as $st) {
        if (in_array($st, $all_stages)) $stages_clean[] = $st;
    }
    $stages_str = implode(', ', $stages_clean);

    // بناء classes بنفس تنسيق القاعدة: "ثالث: A,B" أو "ثالث: جميع الشعب"
    $pairs = array();
    foreach ($all_stages as $st) {
        if (in_array($st, $stages_clean)) {
            $key_all = 'all_'.$st;      // checkbox جميع الشعب
            $key_cls = 'cls_'.$st;      // array من الحروف
            if (isset($_POST[$key_all]) && $_POST[$key_all] == '1') {
                $pairs[] = $st . ': جميع الشعب';
            } else {
                $vals = isset($_POST[$key_cls]) ? $_POST[$key_cls] : array();
                $chosen = array();
                foreach ($vals as $v) {
                    if (in_array($v, $letters)) $chosen[] = $v;
                }
                if (count($chosen) > 0) {
                    $pairs[] = $st . ': ' . implode(',', $chosen);
                } else {
                    // لم يُحدد شيء لهذه المرحلة، نتجاهلها
                }
            }
        }
    }
    $classes_str = implode(', ', $pairs);

    if ($id > 0) {
        $sql = "UPDATE teachers SET 
                    name='$name',
                    password='$password',
                    subject='$subject',
                    stages='$stages_str',
                    classes='$classes_str'
                WHERE id=$id";
        mysqli_query($conn, $sql);
        $notice = "✅ تم تحديث بيانات المدرس.";
    } else {
        $sql = "INSERT INTO teachers(name,password,subject,stages,classes)
                VALUES('$name','$password','$subject','$stages_str','$classes_str')";
        mysqli_query($conn, $sql);
        $notice = "✅ تم إضافة المدرس.";
    }
    header("Location: admin_teachers.php?msg=".urlencode($notice));
    exit();
}

// رسالة نجاح
if (isset($_GET['msg'])) $notice = $_GET['msg'];

// قائمة المدرسين
$teachers = mysqli_query($conn, "SELECT * FROM teachers ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إدارة المدرسين</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Tahoma,Arial;background:#f6f7fb;margin:0}
.top{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:#fff;border-bottom:1px solid #eee}
.container{max-width:1200px;margin:20px auto;padding:0 16px}
.notice{background:#eaf7ee;border:1px solid #c6efd1;color:#2a7d2e;padding:10px;border-radius:10px;margin-bottom:12px}
.grid{display:grid;grid-template-columns:1fr 1fr;gap:18px}
.card{background:#fff;border:1px solid #eee;border-radius:16px;box-shadow:0 10px 25px rgba(0,0,0,.05);padding:16px}
h2{margin-top:0}
table{width:100%;border-collapse:collapse}
th,td{border-bottom:1px solid #eee;padding:8px 6px;text-align:right;font-size:14px}
.small{font-size:12px;color:#777}
.row{display:flex;flex-wrap:wrap;gap:8px;margin-bottom:10px}
.badge{display:inline-block;background:#f0f4ff;border:1px solid #dbe4ff;padding:6px 10px;border-radius:8px}
input[type=text],input[type=password],select{width:100%;padding:10px;border:1px solid #ddd;border-radius:10px}
.btn{display:inline-block;background:#2d6cdf;color:#fff;text-decoration:none;padding:8px 12px;border-radius:10px}
.btn.red{background:#c0392b}
.stage-block{border:1px dashed #ddd;padding:10px;border-radius:12px;margin-bottom:8px}
.stage-title{font-weight:bold;margin-bottom:6px}
label.chk{display:inline-flex;align-items:center;gap:6px;margin-inline-end:10px}
</style>
</head>
<body>
  <div class="top">
    <div><strong>إدارة المدرسين</strong></div>
    <div>
      <a class="btn" href="admin_dashboard.php">العودة للوحة</a>
      <a class="btn red" href="admin_logout.php">خروج</a>
    </div>
  </div>
  <div class="container">
    <?php if($notice!==""):?><div class="notice"><?php echo htmlspecialchars($notice);?></div><?php endif;?>

    <div class="grid">
      <div class="card">
        <h2><?php echo $edit ? "تعديل مدرس" : "إضافة مدرس";?></h2>
        <form method="post">
          <input type="hidden" name="id" value="<?php echo $edit? (int)$edit['id'] : 0; ?>">
          <label>الاسم</label>
          <input type="text" name="name" required value="<?php echo $edit? htmlspecialchars($edit['name']):'';?>">
          <div style="height:8px"></div>

          <label>كلمة المرور (للمدرّس)</label>
          <input type="password" name="password" required value="<?php echo $edit? htmlspecialchars($edit['password']):'';?>">
          <div class="small">هذه تُحفظ كما هي في جدول teachers (كما هو معمول به عندكم).</div>
          <div style="height:8px"></div>

          <label>المادة (اختياري لبعض المدرسين)</label>
          <input type="text" name="subject" placeholder="مثال: عربي / رياضيات / فيزياء" value="<?php echo $edit? htmlspecialchars($edit['subject']):'';?>">
          <div style="height:10px"></div>

          <div class="stage-block">
            <div class="stage-title">المراحل</div>
            <div class="row">
            <?php
              $st_init = $edit? explode(',', str_replace(' ','',$edit['stages'])): array();
              $st_init = array_map('trim', $st_init);
              foreach($all_stages as $st):
                $checked = in_array($st, $st_init) ? 'checked' : '';
            ?>
              <label class="chk"><input type="checkbox" name="stages[]" value="<?php echo $st;?>" <?php echo $checked;?> onclick="toggleStage('<?php echo $st;?>', this.checked)"> <?php echo $st;?></label>
            <?php endforeach;?>
            </div>

            <?php
            // بناء أقسام الشعب لكل مرحلة
            $classes_init = $edit? $edit['classes'] : '';
            // مثال: "ثالث: D, رابع: جميع الشعب"
            $stage_map = array();
            if ($classes_init !== '') {
                $parts = explode(',', $classes_init);
                // نجمع بالنمط: [مرحلة => 'جميع الشعب' أو 'A,B']
                foreach ($parts as $p) {
                    $p = trim($p);
                    if ($p === '') continue;
                    $spl = explode(':', $p);
                    if (count($spl) >= 2) {
                        $st = trim($spl[0]);
                        $rest = trim($spl[1]);
                        $stage_map[$st] = $rest;
                    }
                }
            }
            ?>
            <?php foreach($all_stages as $st): 
                $visible = in_array($st, $st_init) ? '' : 'display:none;';
                $existing = isset($stage_map[$st]) ? $stage_map[$st] : '';
                $is_all = ($existing === 'جميع الشعب');
                $chosen_letters = array();
                if (!$is_all && $existing !== '') $chosen_letters = array_map('trim', explode(',', $existing));
            ?>
              <div id="blk_<?php echo $st;?>" class="stage-block" style="<?php echo $visible;?>">
                <div class="stage-title"><?php echo $st;?> — الشعب</div>
                <label class="chk"><input type="checkbox" name="all_<?php echo $st;?>" value="1" <?php echo $is_all?'checked':'';?> onclick="toggleAll('<?php echo $st;?>', this.checked)"> جميع الشعب</label>
                <div class="row" id="rows_<?php echo $st;?>">
                  <?php foreach($letters as $L): 
                      $checked = in_array($L, $chosen_letters) ? 'checked' : '';
                  ?>
                    <label class="chk"><input type="checkbox" name="cls_<?php echo $st;?>[]" value="<?php echo $L;?>" <?php echo $checked;?>> <?php echo $L;?></label>
                  <?php endforeach;?>
                </div>
              </div>
            <?php endforeach;?>
          </div>

          <div style="height:10px"></div>
          <button class="btn" type="submit"><?php echo $edit? "تحديث" : "إضافة";?></button>
        </form>
      </div>

      <div class="card">
        <h2>قائمة المدرسين</h2>
        <table>
          <thead>
            <tr>
              <th>#</th><th>الاسم</th><th>المادة</th><th>المراحل</th><th>الشعب</th><th>تحكم</th>
            </tr>
          </thead>
          <tbody>
          <?php while($t = mysqli_fetch_assoc($teachers)): ?>
            <tr>
              <td><?php echo (int)$t['id'];?></td>
              <td><?php echo htmlspecialchars($t['name']);?></td>
              <td><?php echo htmlspecialchars($t['subject']);?></td>
              <td><span class="badge"><?php echo htmlspecialchars($t['stages']);?></span></td>
              <td class="small"><?php echo htmlspecialchars($t['classes']);?></td>
              <td>
                <a class="btn" href="?edit=<?php echo (int)$t['id'];?>">تعديل</a>
                <a class="btn red" href="?delete=<?php echo (int)$t['id'];?>" onclick="return confirm('حذف المدرس؟')">حذف</a>
              </td>
            </tr>
          <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

<script>
function toggleStage(stage, on){
  var blk = document.getElementById('blk_'+stage);
  if (blk) blk.style.display = on ? '' : 'none';
}
function toggleAll(stage, on){
  var rows = document.getElementById('rows_'+stage);
  if (!rows) return;
  var inputs = rows.querySelectorAll('input[type=checkbox]');
  for (var i=0;i<inputs.length;i++){ inputs[i].disabled = on; if(on) inputs[i].checked=false; }
}
</script>
</body>
</html>
