<?php
session_start();
include 'db.php';

// ✅ التحقق من تسجيل الدخول
if (!isset($_SESSION['teacher_id'])) {
    header("Location: login.php");
    exit();
}

mysqli_set_charset($conn, "utf8mb4");

$teacher_id = $_SESSION['teacher_id'];

// ✅ جلب المادة من الجلسة أو قاعدة البيانات
if (isset($_SESSION['teacher_subject']) && $_SESSION['teacher_subject'] != '') {
    $teacher_subject = $_SESSION['teacher_subject'];
} else {
    $sub_query = mysqli_query($conn, "SELECT subject FROM teachers WHERE id='$teacher_id' LIMIT 1");
    if ($sub_query && mysqli_num_rows($sub_query) > 0) {
        $row_sub = mysqli_fetch_assoc($sub_query);
        $teacher_subject = isset($row_sub['subject']) ? $row_sub['subject'] : 'غير محدد';
    } else {
        $teacher_subject = 'غير محدد';
    }
    $_SESSION['teacher_subject'] = $teacher_subject;
}

// ✅ دالة لتوحيد نص المرحلة حتى يطابق اللي في قاعدة البيانات
function normalize_stage($s) {
    $s = trim($s);
    $rep = array('أ'=>'ا','إ'=>'ا','آ'=>'ا','الأ'=>'ال','ال'=>'ال');
    $s2 = strtr($s, $rep);

    if (mb_strpos($s2, 'اول') !== false)   return 'الأول المتوسط';
    if (mb_strpos($s2, 'ثاني') !== false || mb_strpos($s2, 'ثانى') !== false || mb_strpos($s2, '2') !== false) return 'الثاني المتوسط';
    if (mb_strpos($s2, 'ثالث') !== false || mb_strpos($s2, '3') !== false) return 'الثالث المتوسط';
    if (mb_strpos($s2, 'رابع') !== false)  return 'الرابع العلمي';
    if (mb_strpos($s2, 'خامس') !== false)  return 'الخامس العلمي';
    if (mb_strpos($s2, 'سادس') !== false)  return 'السادس العلمي';
    return $s;
}

// ✅ دالة ترجع SQL NULL أو رقم (للأعمدة اللي تقبل NULL)
function sql_num_or_null($v) {
    if ($v === null || $v === '') return "NULL";
    return "'".floatval($v)."'";
}

// ✅ دالة ترجع 0 إذا فاضي (للأعمدة اللي ما تقبل NULL في الجدول)
function sql_num_or_zero($v) {
    if ($v === null || $v === '') return "0";
    return "'".floatval($v)."'";
}

// ✅ دالة تنسيق لعرض الأرقام بدون .00
function fmt_num($v) {
    if ($v === null || $v === '') return '';
    $v = floatval($v);
    if (floor($v) == $v) {
        return (string)intval($v);
    }
    return rtrim(rtrim(number_format($v, 2, '.', ''), '0'), '.');
}

// ✅ دالة تقريب للفصل (نفسها نستخدمها ف1 وف2)
function round_sem1($v) {
    $v = floatval($v);
    $base = floor($v);
    $dec  = $v - $base;
    return ($dec >= 0.5) ? ($base + 1) : $base;
}

// ✅ استقبال المرحلة والشعبة
$stage = isset($_GET['stage']) ? trim($_GET['stage']) : '';
$class = isset($_GET['class']) ? trim($_GET['class']) : '';

if ($stage == '' || $class == '') {
    die("<div style='color:red;text-align:center;font-family:Cairo;margin-top:50px;'>❌ خطأ: لم يتم تحديد المرحلة أو الشعبة!</div>");
}

// ✅ طبّق التطبيع
$stage_db = normalize_stage($stage);

// ✅ تنظيف اسم الشعبة
if (strpos($class, ':') !== false) {
    $parts = explode(':', $class);
    $class = trim(end($parts));
}
$class = str_replace(":", "", $class);

// ✅ جلب الطلاب مرتبين
if ($class == 'جميع الشعب' || strtolower($class) == 'all') {
    $sql_students = "
        SELECT * FROM students
        WHERE stage = '".mysqli_real_escape_string($conn, $stage_db)."'
        ORDER BY class ASC, name ASC
    ";
} else {
    $sql_students = "
        SELECT * FROM students
        WHERE stage = '".mysqli_real_escape_string($conn, $stage_db)."'
          AND class = '".mysqli_real_escape_string($conn, $class)."'
        ORDER BY class ASC, name ASC
    ";
}
$result_students = mysqli_query($conn, $sql_students);

// ✅ دالة: الحقل مقفول إذا قيمته > 0
function is_locked($val) {
    return (isset($val) && $val !== '' && floatval($val) > 0);
}

// ✅ دالة أعلى 3
function top3_avg($arr) {
    $clean = array();
    foreach ($arr as $v) {
        $clean[] = floatval($v);
    }
    rsort($clean);
    $top3 = array_slice($clean, 0, 3);
    $sum = array_sum($top3);
    $count = count($top3) > 0 ? count($top3) : 1;
    return round($sum / $count, 2);
}

// ✅ حفظ
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $teacher_subject_esc = mysqli_real_escape_string($conn, $teacher_subject);

    if (isset($_POST['grades']) && is_array($_POST['grades'])) {
        foreach ($_POST['grades'] as $student_id => $grades) {
            $student_id = intval($student_id);

            // نستلم القيم كنص حتى نعرف الفارغ
            $m1_raw  = isset($grades['month1'])  ? trim($grades['month1'])  : '';
            $m2_raw  = isset($grades['month2'])  ? trim($grades['month2'])  : '';
            $m3_raw  = isset($grades['month3'])  ? trim($grades['month3'])  : '';
            $d1_raw  = isset($grades['daily1'])  ? trim($grades['daily1'])  : '';
            $mid_raw = isset($grades['midterm']) ? trim($grades['midterm']) : '';

            $m4_raw  = isset($grades['month4'])  ? trim($grades['month4'])  : '';
            $m5_raw  = isset($grades['month5'])  ? trim($grades['month5'])  : '';
            $m6_raw  = isset($grades['month6'])  ? trim($grades['month6'])  : '';
            $d2_raw  = isset($grades['daily2'])  ? trim($grades['daily2'])  : '';

            $fin_raw = isset($grades['final_result']) ? trim($grades['final_result']) : '';

            // الفارغ يبقى NULL، والـ 0 يبقى 0
            $in_month1  = ($m1_raw  === '') ? null : (float)$m1_raw;
            $in_month2  = ($m2_raw  === '') ? null : (float)$m2_raw;
            $in_month3  = ($m3_raw  === '') ? null : (float)$m3_raw;
            $in_daily1  = ($d1_raw  === '') ? null : (float)$d1_raw;
            $in_midterm = ($mid_raw === '') ? null : (float)$mid_raw;

            $in_month4  = ($m4_raw  === '') ? null : (float)$m4_raw;
            $in_month5  = ($m5_raw  === '') ? null : (float)$m5_raw;
            $in_month6  = ($m6_raw  === '') ? null : (float)$m6_raw;
            $in_daily2  = ($d2_raw  === '') ? null : (float)$d2_raw;

            $in_final   = ($fin_raw === '') ? null : (float)$fin_raw;

            // جلب القديم
            $qold = mysqli_query($conn, "
                SELECT * FROM grades 
                WHERE student_id='$student_id' AND teacher_id='$teacher_id' AND subject='$teacher_subject_esc'
                LIMIT 1
            ");

            if ($qold && mysqli_num_rows($qold) > 0) {
                $old = mysqli_fetch_assoc($qold);

                // إذا مقفول نخلي القديم
                $month1  = is_locked($old['month1'])  ? $old['month1']  : $in_month1;
                $month2  = is_locked($old['month2'])  ? $old['month2']  : $in_month2;
                $month3  = is_locked($old['month3'])  ? $old['month3']  : $in_month3;
                $daily1  = is_locked($old['daily1'])  ? $old['daily1']  : $in_daily1;
                $midterm = is_locked($old['midterm']) ? $old['midterm'] : $in_midterm;

                $month4  = is_locked($old['month4'])  ? $old['month4']  : $in_month4;
                $month5  = is_locked($old['month5'])  ? $old['month5']  : $in_month5;
                $month6  = is_locked($old['month6'])  ? $old['month6']  : $in_month6;
                $daily2  = is_locked($old['daily2'])  ? $old['daily2']  : $in_daily2;

                $final_result = is_locked($old['final_result']) ? $old['final_result'] : $in_final;

                // حساب ف1
                $m1_calc = ($month1 !== null && $month1 !== '') ? floatval($month1) : 0;
                $m2_calc = ($month2 !== null && $month2 !== '') ? floatval($month2) : 0;
                $m3_calc = ($month3 !== null && $month3 !== '') ? floatval($month3) : 0;
                $d1_calc = ($daily1 !== null && $daily1 !== '') ? floatval($daily1) : 0;

                if ($d1_calc > 0) {
                    $semester1 = top3_avg(array($m1_calc, $m2_calc, $m3_calc, $d1_calc));
                } else {
                    $semester1 = round(($m1_calc + $m2_calc + $m3_calc) / 3, 2);
                }
                // 👈 تقريب الفصل الأول
                $semester1 = round_sem1($semester1);

                // ف2
                $m4_calc = ($month4 !== null && $month4 !== '') ? floatval($month4) : 0;
                $m5_calc = ($month5 !== null && $month5 !== '') ? floatval($month5) : 0;
                $m6_calc = ($month6 !== null && $month6 !== '') ? floatval($month6) : 0;
                $d2_calc = ($daily2 !== null && $daily2 !== '') ? floatval($daily2) : 0;

                if ($d2_calc > 0) {
                    $semester2 = top3_avg(array($m4_calc, $m5_calc, $m6_calc, $d2_calc));
                } else {
                    $semester2 = round(($m4_calc + $m5_calc + $m6_calc) / 3, 2);
                }
                // 👈 نفس الشي للفصل الثاني
                $semester2 = round_sem1($semester2);

                if (is_locked($old['semester1'])) $semester1 = $old['semester1'];
                if (is_locked($old['semester2'])) $semester2 = $old['semester2'];

                // المعدل السنوي
                if (is_locked($old['annual_average'])) {
                    $annual_average = $old['annual_average'];
                } else {
                    $mid_calc = ($midterm !== null && $midterm !== '') ? floatval($midterm) : 0;
                    $annual_average = round( ($semester1 + $semester2 + $mid_calc) / 3, 2 );
                }

                // تجهيز SQL
                // هذني تقبل NULL
                $sql_m1  = sql_num_or_null($month1);
                $sql_m2  = sql_num_or_null($month2);
                $sql_m3  = sql_num_or_null($month3);
                $sql_mid = sql_num_or_null($midterm);

                // هذني بالجدول NOT NULL → نرسل 0 إذا فاضي
                $sql_d1  = sql_num_or_zero($daily1);
                $sql_m4  = sql_num_or_zero($month4);
                $sql_m5  = sql_num_or_zero($month5);
                $sql_m6  = sql_num_or_zero($month6);
                $sql_d2  = sql_num_or_zero($daily2);

                $sql_fin    = sql_num_or_null($final_result);
                $sql_sem1   = sql_num_or_null($semester1);
                $sql_sem2   = sql_num_or_null($semester2);
                $sql_annual = sql_num_or_null($annual_average);

                $upd = mysqli_query($conn, "
                    UPDATE grades SET 
                        month1=$sql_m1, month2=$sql_m2, month3=$sql_m3, daily1=$sql_d1, semester1=$sql_sem1,
                        midterm=$sql_mid,
                        month4=$sql_m4, month5=$sql_m5, month6=$sql_m6, daily2=$sql_d2, semester2=$sql_sem2,
                        annual_average=$sql_annual, final_result=$sql_fin, saved_at=NOW()
                    WHERE id='{$old['id']}'
                ");
            } else {
                // أول إدخال
                $m1_calc = ($in_month1 !== null) ? floatval($in_month1) : 0;
                $m2_calc = ($in_month2 !== null) ? floatval($in_month2) : 0;
                $m3_calc = ($in_month3 !== null) ? floatval($in_month3) : 0;
                $d1_calc = ($in_daily1 !== null) ? floatval($in_daily1) : 0;

                if ($d1_calc > 0) {
                    $semester1 = top3_avg(array($m1_calc, $m2_calc, $m3_calc, $d1_calc));
                } else {
                    $semester1 = round(($m1_calc + $m2_calc + $m3_calc) / 3, 2);
                }
                // 👈 تقريب الفصل الأول
                $semester1 = round_sem1($semester1);

                $m4_calc = ($in_month4 !== null) ? floatval($in_month4) : 0;
                $m5_calc = ($in_month5 !== null) ? floatval($in_month5) : 0;
                $m6_calc = ($in_month6 !== null) ? floatval($in_month6) : 0;
                $d2_calc = ($in_daily2 !== null) ? floatval($in_daily2) : 0;

                if ($d2_calc > 0) {
                    $semester2 = top3_avg(array($m4_calc, $m5_calc, $m6_calc, $d2_calc));
                } else {
                    $semester2 = round(($m4_calc + $m5_calc + $m6_calc) / 3, 2);
                }
                // 👈 تقريب الفصل الثاني
                $semester2 = round_sem1($semester2);

                $mid_calc = ($in_midterm !== null) ? floatval($in_midterm) : 0;
                $annual_average = round( ($semester1 + $semester2 + $mid_calc) / 3, 2 );

                // الأعمدة اللي تقبل NULL
                $sql_m1  = sql_num_or_null($in_month1);
                $sql_m2  = sql_num_or_null($in_month2);
                $sql_m3  = sql_num_or_null($in_month3);
                $sql_mid = sql_num_or_null($in_midterm);
                $sql_fin = sql_num_or_null($in_final);
                $sql_sem1   = sql_num_or_null($semester1);
                $sql_sem2   = sql_num_or_null($semester2);
                $sql_annual = sql_num_or_null($annual_average);

                // الأعمدة اللي ما تقبل NULL
                $sql_d1  = sql_num_or_zero($in_daily1);
                $sql_m4  = sql_num_or_zero($in_month4);
                $sql_m5  = sql_num_or_zero($in_month5);
                $sql_m6  = sql_num_or_zero($in_month6);
                $sql_d2  = sql_num_or_zero($in_daily2);

                $ins = mysqli_query($conn, "
                    INSERT INTO grades 
                    (student_id, teacher_id, subject, 
                     month1, month2, month3, daily1, semester1, midterm,
                     month4, month5, month6, daily2, semester2,
                     annual_average, final_result, saved_at)
                    VALUES
                    ('$student_id','$teacher_id','$teacher_subject_esc',
                     $sql_m1,$sql_m2,$sql_m3,$sql_d1,$sql_sem1,$sql_mid,
                     $sql_m4,$sql_m5,$sql_m6,$sql_d2,$sql_sem2,
                     $sql_annual,$sql_fin,NOW())
                ");
            }
        }
    }

    echo "<script>alert('✅ تم حفظ الدرجات بنجاح مع الفصلين.');</script>";
    $success = "✅ تم حفظ الدرجات بنجاح وتم تطبيق حماية عدم التعديل على الدرجات المحفوظة (>0).";
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>إدارة الدرجات - <?php echo htmlspecialchars($stage); ?> - <?php echo htmlspecialchars($class); ?></title>
<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap" rel="stylesheet">
<style>
body {font-family:"Cairo",Arial,sans-serif;direction:rtl;text-align:right;background:#f2f3f7;margin:0;padding:0;}
.container{width:95%;max-width:1200px;margin:40px auto;background:#fff;padding:25px 35px;border-radius:12px;box-shadow:0 10px 25px rgba(0,0,0,0.1);}
h2{background:#007bff;color:#fff;padding:12px;text-align:center;border-radius:8px;margin-bottom:25px;}
.notice{background:#fff3cd;color:#856404;border:1px solid #ffeeba;padding:10px;text-align:center;border-radius:8px;margin-bottom:15px;}
.table-wrapper{overflow-x:auto;}
table{width:1700px;border-collapse:collapse;margin-bottom:20px;position:relative;}
th,td{border:1px solid #ddd;padding:8px;text-align:center;font-size:14px;white-space:nowrap;}
th{background:#007bff;color:#fff;}
td.name-col{min-width:220px;text-align:right;padding-right:10px;font-weight:bold;position:sticky;right:0;background:#fff;z-index:2;}
td.class-col{min-width:80px;font-weight:bold;position:sticky;right:220px;background:#fff;z-index:2;}
th:nth-child(2){position:sticky;right:0;z-index:3;background:#0056b3;}
th:nth-child(3){position:sticky;right:220px;z-index:3;background:#0056b3;}
input[type="number"]{width:70px;padding:5px;border-radius:5px;border:1px solid #ccc;text-align:center;}
input[readonly]{background:#eee;color:#555;}
button{background:#28a745;color:#fff;padding:10px 25px;border:none;border-radius:6px;font-size:16px;cursor:pointer;transition:0.3s;}
button:hover{background:#218838;}
.success{background:#d4edda;border:1px solid #c3e6cb;color:#155724;padding:10px;text-align:center;border-radius:8px;margin-bottom:15px;}
.no-data{color:red;text-align:center;font-weight:bold;}
a.back{display:inline-block;background:#007bff;color:#fff;padding:8px 15px;text-decoration:none;border-radius:6px;transition:0.3s;}
a.back:hover{background:#0056b3;}
a.eval{display:inline-block;background:#ffc107;color:#000;padding:8px 15px;text-decoration:none;border-radius:6px;margin-bottom:15px;font-weight:bold;}
a.eval:hover{background:#e0a800;}
.strike-lowest { text-decoration: line-through; color: #c00; font-weight: bold; background: #ffe6f2; }
.class-A { background: #e3f2fd !important; color: #0d47a1; }
.class-B { background: #fff3e0 !important; color: #e65100; }
.class-C { background: #e8f5e9 !important; color: #1b5e20; }
.class-D { background: #f3e5f5 !important; color: #4a148c; }
.class-OTHER { background: #eceff1 !important; color: #263238; }
</style>
<script>
function confirmSave() {
    return confirm("⚠️ بعد حفظ الدرجات لن تستطيع تعديلها إلا من قبل الإدارة.\nهل تريد المتابعة؟");
}
</script>
</head>
<body>
<div class="container">
<h2>المرحلة: <?php echo htmlspecialchars($stage_db); ?> - الشعبة: <?php echo htmlspecialchars($class); ?> - المادة: <?php echo htmlspecialchars($teacher_subject); ?></h2>

<div style="text-align:center;margin-bottom:15px;">
    <a class="eval" href="evaluate_students.php?stage=<?php echo urlencode($stage_db); ?>&class=<?php echo urlencode($class); ?>">⭐ تقييم الطلبة (السلوك والمستوى الدراسي)</a>
</div>

<?php 
if (isset($success)) echo "<div class='success'>$success</div>"; 
echo "<div class='notice'>⚠️ الحماية مفعّلة: لا يمكن تعديل أي درجة محفوظة سابقاً. يمكن تعديل الحقول الفارغة فقط. ف1 وف2 تُحسبان الآن بأخذ أعلى 3 درجات إذا كان هناك يومي، والمعدل السنوي = (ف1 + ف2 + نصف السنة) ÷ 3.</div>";?>

<div class="table-wrapper">
<form method="post" onsubmit="return confirmSave();">
<table>
<tr>
<th>#</th>
<th>اسم الطالب</th>
<th>الشعبة</th>
<th>ش1</th>
<th>ش2</th>
<th>ش3</th>
<th>اليومي ف1</th>
<th>ف1</th>
<th>نصف السنة</th>
<th>ش1 (ف2)</th>
<th>ش2 (ف2)</th>
<th>ش3 (ف2)</th>
<th>اليومي ف2</th>
<th>ف2</th>
<th>المعدل السنوي</th>
<th>النتيجة النهائية</th>
<th>تاريخ الحفظ</th>
</tr>

<?php
$counter = 1;
if ($result_students && mysqli_num_rows($result_students) > 0) {
    while ($s = mysqli_fetch_assoc($result_students)) {
        $id = $s['id'];
        $g = mysqli_query($conn, "SELECT * FROM grades WHERE student_id='$id' AND teacher_id='$teacher_id' AND subject='".mysqli_real_escape_string($conn,$teacher_subject)."' LIMIT 1");
        $grade = ($g && mysqli_num_rows($g) > 0) ? mysqli_fetch_assoc($g) : array();
        $saved_at = (isset($grade['saved_at']) && $grade['saved_at'] != '') ? $grade['saved_at'] : "";

        // نجيب الدرجات كما هي
        $month1  = array_key_exists('month1',$grade) ? $grade['month1'] : null;
        $month2  = array_key_exists('month2',$grade) ? $grade['month2'] : null;
        $month3  = array_key_exists('month3',$grade) ? $grade['month3'] : null;
        $daily1  = array_key_exists('daily1',$grade) ? $grade['daily1'] : null;
        $midterm = array_key_exists('midterm',$grade) ? $grade['midterm'] : null;

        $month4  = array_key_exists('month4',$grade) ? $grade['month4'] : null;
        $month5  = array_key_exists('month5',$grade) ? $grade['month5'] : null;
        $month6  = array_key_exists('month6',$grade) ? $grade['month6'] : null;
        $daily2  = array_key_exists('daily2',$grade) ? $grade['daily2'] : null;

        $final_result   = array_key_exists('final_result',$grade) ? $grade['final_result'] : null;

        // نتحقق: هل هذا سجل فيه أي NULL (يعني جديد أو معدل)؟
        $fields_check = array('month1','month2','month3','daily1','midterm','month4','month5','month6','daily2','final_result','semester1','semester2','annual_average');
        $has_null = false;
        if (!empty($grade)) {
            foreach ($fields_check as $fc) {
                if (!isset($grade[$fc]) || $grade[$fc] === null) {
                    $has_null = true;
                    break;
                }
            }
        } else {
            $has_null = true;
        }

        // حساب ف1
        $m1_calc = ($month1 !== null && $month1 !== '') ? floatval($month1) : 0;
        $m2_calc = ($month2 !== null && $month2 !== '') ? floatval($month2) : 0;
        $m3_calc = ($month3 !== null && $month3 !== '') ? floatval($month3) : 0;
        $d1_calc = ($daily1 !== null && $daily1 !== '') ? floatval($daily1) : 0;

        if ($d1_calc > 0) {
            $first_sem_vals = array(
                'month1' => $m1_calc,
                'month2' => $m2_calc,
                'month3' => $m3_calc,
                'daily1' => $d1_calc
            );
            $min_key = null;
            $min_val = null;
            foreach ($first_sem_vals as $k => $v) {
                if ($min_val === null) {
                    $min_val = $v;
                    $min_key = $k;
                    continue;
                }
                if ($v < $min_val) {
                    $min_val = $v;
                    $min_key = $k;
                }
            }
            $semester1 = top3_avg(array($m1_calc, $m2_calc, $m3_calc, $d1_calc));
        } else {
            $min_key = null;
            $semester1 = round(($m1_calc + $m2_calc + $m3_calc) / 3, 2);
        }
        // 👈 تقريب الفصل الأول في العرض
        $semester1 = round_sem1($semester1);

        // ف2
        $m4_calc = ($month4 !== null && $month4 !== '') ? floatval($month4) : 0;
        $m5_calc = ($month5 !== null && $month5 !== '') ? floatval($month5) : 0;
        $m6_calc = ($month6 !== null && $month6 !== '') ? floatval($month6) : 0;
        $d2_calc = ($daily2 !== null && $daily2 !== '') ? floatval($daily2) : 0;

        if ($d2_calc > 0) {
            $second_sem_vals = array(
                'month4' => $m4_calc,
                'month5' => $m5_calc,
                'month6' => $m6_calc,
                'daily2' => $d2_calc
            );
            $min_key2 = null;
            $min_val2 = null;
            foreach ($second_sem_vals as $k2 => $v2) {
                if ($min_val2 === null) {
                    $min_val2 = $v2;
                    $min_key2 = $k2;
                    continue;
                }
                if ($v2 < $min_val2) {
                    $min_val2 = $v2;
                    $min_key2 = $k2;
                }
            }
            $semester2 = top3_avg(array($m4_calc, $m5_calc, $m6_calc, $d2_calc));
        } else {
            $min_key2 = null;
            $semester2 = round(($m4_calc + $m5_calc + $m6_calc) / 3, 2);
        }
        // 👈 تقريب الفصل الثاني في العرض
        $semester2 = round_sem1($semester2);

        // المعدل السنوي
        $mid_calc = ($midterm !== null && $midterm !== '') ? floatval($midterm) : 0;
        $annual_display = round( ($semester1 + $semester2 + $mid_calc) / 3, 2 );

        // readonly
        $ro_m1 = ($month1  !== null && $month1  !== '' && floatval($month1)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_m2 = ($month2  !== null && $month2  !== '' && floatval($month2)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_m3 = ($month3  !== null && $month3  !== '' && floatval($month3)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_d1 = ($daily1  !== null && $daily1  !== '' && floatval($daily1)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_mid= ($midterm !== null && $midterm !== '' && floatval($midterm) > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';

        $ro_m4 = ($month4  !== null && $month4  !== '' && floatval($month4)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_m5 = ($month5  !== null && $month5  !== '' && floatval($month5)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_m6 = ($month6  !== null && $month6  !== '' && floatval($month6)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';
        $ro_d2 = ($daily2  !== null && $daily2  !== '' && floatval($daily2)  > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';

        $ro_fin= ($final_result !== null && $final_result !== '' && floatval($final_result) > 0) ? 'readonly title="مقفل - تواصل مع الإدارة للتعديل"' : '';

        // تلوين الشعبة
        $cls = trim($s['class']);
        $cls_simple = strtoupper($cls);
        if ($cls_simple == 'A' || $cls_simple == 'أ' || $cls_simple == 'آ') {
            $class_color = 'class-A';
        } elseif ($cls_simple == 'B' || $cls_simple == 'ب') {
            $class_color = 'class-B';
        } elseif ($cls_simple == 'C' || $cls_simple == 'ج') {
            $class_color = 'class-C';
        } elseif ($cls_simple == 'D' || $cls_simple == 'د') {
            $class_color = 'class-D';
        } else {
            $class_color = 'class-OTHER';
        }

        // 👇 التحكم بالعرض + إزالة .00
        if ($has_null) {
            $val_m1   = ($month1  === null || $month1  === '') ? '' : fmt_num($month1);
            $val_m2   = ($month2  === null || $month2  === '') ? '' : fmt_num($month2);
            $val_m3   = ($month3  === null || $month3  === '') ? '' : fmt_num($month3);
            $val_d1   = ($daily1  === null || $daily1  === '') ? '' : fmt_num($daily1);
            $val_mid  = ($midterm === null || $midterm === '') ? '' : fmt_num($midterm);

            $val_m4   = ($month4  === null || $month4  === '') ? '' : fmt_num($month4);
            $val_m5   = ($month5  === null || $month5  === '') ? '' : fmt_num($month5);
            $val_m6   = ($month6  === null || $month6  === '') ? '' : fmt_num($month6);
            $val_d2   = ($daily2  === null || $daily2  === '') ? '' : fmt_num($daily2);

            $val_final = ($final_result === null || $final_result === '') ? '' : fmt_num($final_result);
        } else {
            $val_m1   = (floatval($month1)  == 0 ? '' : fmt_num($month1));
            $val_m2   = (floatval($month2)  == 0 ? '' : fmt_num($month2));
            $val_m3   = (floatval($month3)  == 0 ? '' : fmt_num($month3));
            $val_d1   = (floatval($daily1)  == 0 ? '' : fmt_num($daily1));
            $val_mid  = (floatval($midterm) == 0 ? '' : fmt_num($midterm));

            $val_m4   = (floatval($month4)  == 0 ? '' : fmt_num($month4));
            $val_m5   = (floatval($month5)  == 0 ? '' : fmt_num($month5));
            $val_m6   = (floatval($month6)  == 0 ? '' : fmt_num($month6));
            $val_d2   = (floatval($daily2)  == 0 ? '' : fmt_num($daily2));

            $val_final= (floatval($final_result) == 0 ? '' : fmt_num($final_result));
        }

        // فراغات الفصل الثاني لو كانت 0
        if ($val_m4 !== '' && floatval($val_m4) == 0) $val_m4 = '';
        if ($val_m5 !== '' && floatval($val_m5) == 0) $val_m5 = '';
        if ($val_m6 !== '' && floatval($val_m6) == 0) $val_m6 = '';
        if ($val_d2 !== '' && floatval($val_d2) == 0) $val_d2 = '';
        if ($val_d1 !== '' && floatval($val_d1) == 0) $val_d1 = '';

        echo "<tr>
    <td>".$counter."</td>
    <td class='name-col'>".htmlspecialchars($s['name'])."</td>
    <td class='class-col ".$class_color."'>".htmlspecialchars($s['class'])."</td>

    <td><input type='number' name='grades[".$id."][month1]' value='".$val_m1."' $ro_m1 ".(isset($min_key)&&$min_key=='month1' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][month2]' value='".$val_m2."' $ro_m2 ".(isset($min_key)&&$min_key=='month2' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][month3]' value='".$val_m3."' $ro_m3 ".(isset($min_key)&&$min_key=='month3' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][daily1]'  value='".$val_d1."' $ro_d1 ".(isset($min_key)&&$min_key=='daily1' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][semester1]' value='".fmt_num($semester1)."' readonly></td>
    <td><input type='number' name='grades[".$id."][midterm]' value='".$val_mid."' $ro_mid></td>

    <td><input type='number' name='grades[".$id."][month4]' value='".$val_m4."' $ro_m4 ".(isset($min_key2)&&$min_key2=='month4' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][month5]' value='".$val_m5."' $ro_m5 ".(isset($min_key2)&&$min_key2=='month5' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][month6]' value='".$val_m6."' $ro_m6 ".(isset($min_key2)&&$min_key2=='month6' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][daily2]' value='".$val_d2."' $ro_d2 ".(isset($min_key2)&&$min_key2=='daily2' ? "class=\"strike-lowest\"" : "")."></td>
    <td><input type='number' name='grades[".$id."][semester2]' value='".fmt_num($semester2)."' readonly></td>

    <td><input type='number' value='".fmt_num($annual_display)."' readonly></td>
    <td><input type='number' name='grades[".$id."][final_result]' value='".$val_final."' $ro_fin></td>
    <td>".($saved_at ? date('Y-m-d H:i', strtotime($saved_at)) : "-")."</td>
</tr>";

        $counter++;
    }
} else {
    echo "<tr><td colspan='17' class='no-data'>❌ لا توجد بيانات للطلاب في هذه الشعبة أو المرحلة.</td></tr>";
}
?>
</table>
<div style="text-align:center;">
    <button type="submit">💾 حفظ الدرجات</button>
</div>
</form>
</div>

<p style="text-align:center;margin-top:20px;">
    <a class="back" href="dashboard.php">⬅ العودة إلى لوحة التحكم</a>
</p>
</div>
</body>
</html>
