<?php
session_start();
include 'db.php';

mysqli_set_charset($conn, "utf8mb4");
date_default_timezone_set('Asia/Baghdad');

if (!isset($_SESSION['teacher_id'])) {
    http_response_code(403);
    exit('forbidden');
}

$teacher_id = (int)$_SESSION['teacher_id'];
$notif_id   = isset($_POST['notif_id']) ? (int)$_POST['notif_id'] : 0;

if ($notif_id <= 0) {
    http_response_code(400);
    exit('bad');
}

$now = date('Y-m-d H:i:s');

$sql = "
INSERT INTO admin_notification_reads (notification_id, teacher_id, is_read, read_at)
VALUES ($notif_id, $teacher_id, 1, '$now')
ON DUPLICATE KEY UPDATE
  is_read = 1,
  read_at = IF(read_at IS NULL OR read_at='0000-00-00 00:00:00', VALUES(read_at), read_at)
";

if (mysqli_query($conn, $sql)) {
    echo 'OK';
} else {
    http_response_code(500);
    echo 'ERR: ' . mysqli_error($conn);
}
